/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public final class ConstantUtf8
extends Constant {
    private static final long serialVersionUID = -8709101585611518985L;
    private final String bytes;
    private static volatile int considered = 0;
    private static volatile int hits = 0;
    private static volatile int skipped = 0;
    private static volatile int created = 0;
    private static final int MAX_CACHED_SIZE = Integer.getInteger("bcel.maxcached.size", 200);
    private static final boolean BCEL_STATISTICS = Boolean.getBoolean("bcel.statistics");

    static void printStats() {
        System.err.println("Cache hit " + hits + "/" + considered + ", " + skipped + " skipped");
        System.err.println("Total of " + created + " ConstantUtf8 objects created");
    }

    static void clearStats() {
        created = 0;
        skipped = 0;
        considered = 0;
        hits = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstantUtf8 getCachedInstance(String s) {
        if (s.length() > MAX_CACHED_SIZE) {
            ++skipped;
            return new ConstantUtf8(s);
        }
        ++considered;
        Class<ConstantUtf8> clazz = ConstantUtf8.class;
        synchronized (ConstantUtf8.class) {
            ConstantUtf8 result = (ConstantUtf8)CACHE_HOLDER.CACHE.get(s);
            if (result != null) {
                ++hits;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return result;
            }
            result = new ConstantUtf8(s);
            CACHE_HOLDER.CACHE.put(s, result);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public static ConstantUtf8 getInstance(String s) {
        return new ConstantUtf8(s);
    }

    public static ConstantUtf8 getInstance(DataInput input) throws IOException {
        return ConstantUtf8.getInstance(input.readUTF());
    }

    public ConstantUtf8(ConstantUtf8 c) {
        this(c.getBytes());
    }

    ConstantUtf8(DataInput file) throws IOException {
        super((byte)1);
        this.bytes = file.readUTF();
        ++created;
    }

    public ConstantUtf8(String bytes) {
        super((byte)1);
        if (bytes == null) {
            throw new IllegalArgumentException("bytes must not be null!");
        }
        this.bytes = bytes;
        ++created;
    }

    public void accept(Visitor v) {
        v.visitConstantUtf8(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        file.writeByte(this.tag);
        file.writeUTF(this.bytes);
    }

    public final String getBytes() {
        return this.bytes;
    }

    @Deprecated
    public final void setBytes(String bytes) {
        throw new UnsupportedOperationException();
    }

    public final String toString() {
        return super.toString() + "(\"" + Utility.replace(this.bytes, "\n", "\\n") + "\")";
    }

    static {
        if (BCEL_STATISTICS) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                public void run() {
                    ConstantUtf8.printStats();
                }
            });
        }
    }

    private static class CACHE_HOLDER {
        private static final int MAX_CACHE_ENTRIES = 20000;
        private static final int INITIAL_CACHE_CAPACITY = 26666;
        private static final HashMap<String, ConstantUtf8> CACHE = new LinkedHashMap<String, ConstantUtf8>(26666, 0.75f, true){
            private static final long serialVersionUID = -8506975356158971766L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, ConstantUtf8> eldest) {
                return this.size() > 20000;
            }
        };

        private CACHE_HOLDER() {
        }
    }
}

