/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.StackMapEntry;
import org.apache.bcel.classfile.Visitor;

public final class StackMap
extends Attribute {
    private static final long serialVersionUID = -6238662431726968495L;
    private int map_length;
    private StackMapEntry[] map;

    public StackMap(int name_index, int length, StackMapEntry[] map, ConstantPool constant_pool) {
        super((byte)11, name_index, length, constant_pool);
        this.setStackMap(map);
    }

    StackMap(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        this(name_index, length, (StackMapEntry[])null, constant_pool);
        this.map_length = input.readUnsignedShort();
        this.map = new StackMapEntry[this.map_length];
        for (int i = 0; i < this.map_length; ++i) {
            this.map[i] = new StackMapEntry(input, constant_pool);
        }
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.map_length);
        for (int i = 0; i < this.map_length; ++i) {
            this.map[i].dump(file);
        }
    }

    public final StackMapEntry[] getStackMap() {
        return this.map;
    }

    public final void setStackMap(StackMapEntry[] map) {
        this.map = map;
        this.map_length = map == null ? 0 : map.length;
    }

    public final String toString() {
        StringBuilder buf = new StringBuilder("StackMap(");
        for (int i = 0; i < this.map_length; ++i) {
            buf.append(this.map[i].toString());
            if (i >= this.map_length - 1) continue;
            buf.append(", ");
        }
        buf.append(')');
        return buf.toString();
    }

    public Attribute copy(ConstantPool _constant_pool) {
        StackMap c = (StackMap)this.clone();
        c.map = new StackMapEntry[this.map_length];
        for (int i = 0; i < this.map_length; ++i) {
            c.map[i] = this.map[i].copy();
        }
        c.constant_pool = _constant_pool;
        return c;
    }

    public void accept(Visitor v) {
        v.visitStackMap(this);
    }

    public final int getMapLength() {
        return this.map_length;
    }
}

