/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.classfile.AccessFlags;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.generic.AnnotationEntryGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.NamedAndTyped;
import org.apache.bcel.generic.Type;

public abstract class FieldGenOrMethodGen
extends AccessFlags
implements NamedAndTyped,
Cloneable {
    private static final long serialVersionUID = -2549303846821589647L;
    protected String name;
    protected Type type;
    protected ConstantPoolGen cp;
    private final List<Attribute> attribute_vec = new ArrayList<Attribute>();
    protected List<AnnotationEntryGen> annotation_vec = new ArrayList<AnnotationEntryGen>();

    protected FieldGenOrMethodGen() {
    }

    public void setType(Type type) {
        if (type.getType() == 16) {
            throw new IllegalArgumentException("Type can not be " + type);
        }
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public void setConstantPool(ConstantPoolGen cp) {
        this.cp = cp;
    }

    public void addAttribute(Attribute a) {
        this.attribute_vec.add(a);
    }

    public void addAnnotationEntry(AnnotationEntryGen ag) {
        this.annotation_vec.add(ag);
    }

    public void removeAttribute(Attribute a) {
        this.attribute_vec.remove(a);
    }

    public void removeAnnotationEntry(AnnotationEntryGen ag) {
        this.annotation_vec.remove(ag);
    }

    public void removeAttributes() {
        this.attribute_vec.clear();
    }

    public void removeAnnotationEntries() {
        this.annotation_vec.clear();
    }

    public Attribute[] getAttributes() {
        Attribute[] attributes = new Attribute[this.attribute_vec.size()];
        this.attribute_vec.toArray(attributes);
        return attributes;
    }

    public AnnotationEntryGen[] getAnnotationEntries() {
        AnnotationEntryGen[] annotations = new AnnotationEntryGen[this.annotation_vec.size()];
        this.annotation_vec.toArray(annotations);
        return annotations;
    }

    public abstract String getSignature();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error("Clone Not Supported");
        }
    }
}

