/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.bcel.Constants;
import org.apache.bcel.ExceptionConstants;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.ExceptionThrower;
import org.apache.bcel.generic.NameSignatureInstruction;
import org.apache.bcel.generic.StackConsumer;
import org.apache.bcel.generic.StackProducer;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class INVOKEDYNAMIC
extends NameSignatureInstruction
implements ExceptionThrower,
StackConsumer,
StackProducer {
    private static final long serialVersionUID = 1L;

    INVOKEDYNAMIC() {
    }

    public INVOKEDYNAMIC(short opcode, int index) {
        super(opcode, index);
    }

    @Override
    public String toString(ConstantPool cp) {
        Constant c = cp.getConstant(this.index);
        StringTokenizer tok = new StringTokenizer(cp.constantToString(c));
        return Constants.OPCODE_NAMES[this.opcode] + " " + tok.nextToken().replace('.', '/') + tok.nextToken();
    }

    public ConstantInvokeDynamic getInvokeDynamic(ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        return (ConstantInvokeDynamic)cp.getConstant(this.index);
    }

    @Override
    public ConstantNameAndType getNameAndType(ConstantPoolGen cpg) {
        ConstantPool cp = cpg.getConstantPool();
        ConstantInvokeDynamic id = this.getInvokeDynamic(cpg);
        return (ConstantNameAndType)cp.getConstant(id.getNameAndTypeIndex());
    }

    @Override
    public int consumeStack(ConstantPoolGen cpg) {
        String signature = this.getSignature(cpg);
        return Type.getArgumentTypesSize(signature);
    }

    @Override
    public int produceStack(ConstantPoolGen cpg) {
        String signature = this.getSignature(cpg);
        return Type.getReturnTypeSize(signature);
    }

    @Override
    public Type getType(ConstantPoolGen cpg) {
        return this.getReturnType(cpg);
    }

    public String getMethodName(ConstantPoolGen cpg) {
        return this.getName(cpg);
    }

    public Type getReturnType(ConstantPoolGen cpg) {
        return Type.getReturnType(this.getSignature(cpg));
    }

    public Type[] getArgumentTypes(ConstantPoolGen cpg) {
        return Type.getArgumentTypes(this.getSignature(cpg));
    }

    @Override
    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        super.initFromFile(bytes, wide);
        this.length = (short)5;
        bytes.readUnsignedShort();
    }

    @Override
    public Class<?>[] getExceptions() {
        Class[] cs = new Class[4 + ExceptionConstants.EXCS_INTERFACE_METHOD_RESOLUTION.length];
        System.arraycopy(ExceptionConstants.EXCS_INTERFACE_METHOD_RESOLUTION, 0, cs, 0, ExceptionConstants.EXCS_INTERFACE_METHOD_RESOLUTION.length);
        cs[ExceptionConstants.EXCS_INTERFACE_METHOD_RESOLUTION.length + 3] = ExceptionConstants.INCOMPATIBLE_CLASS_CHANGE_ERROR;
        cs[ExceptionConstants.EXCS_INTERFACE_METHOD_RESOLUTION.length + 2] = ExceptionConstants.ILLEGAL_ACCESS_ERROR;
        cs[ExceptionConstants.EXCS_INTERFACE_METHOD_RESOLUTION.length + 1] = ExceptionConstants.ABSTRACT_METHOD_ERROR;
        cs[ExceptionConstants.EXCS_INTERFACE_METHOD_RESOLUTION.length] = ExceptionConstants.UNSATISFIED_LINK_ERROR;
        return cs;
    }

    @Override
    public void accept(Visitor v) {
        v.visitExceptionThrower(this);
        v.visitTypedInstruction(this);
        v.visitStackConsumer(this);
        v.visitStackProducer(this);
        v.visitCPInstruction(this);
        v.visitNameSignatureInstruction(this);
        v.visitINVOKEDYNAMIC(this);
    }
}

