/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.generic.BranchHandle;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.CPInstruction;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.CodeExceptionGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionListObserver;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.Select;
import org.apache.bcel.generic.TargetLostException;
import org.apache.bcel.util.ByteSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstructionList
implements Serializable {
    private static final long serialVersionUID = 2651389055345707857L;
    private InstructionHandle start = null;
    private InstructionHandle end = null;
    private int length = 0;
    private int[] byte_positions;
    private List<InstructionListObserver> observers;

    public InstructionList() {
    }

    public InstructionList(Instruction i) {
        this.append(i);
    }

    public InstructionList(BranchInstruction i) {
        this.append(i);
    }

    public InstructionList(CompoundInstruction c) {
        this.append(c.getInstructionList());
    }

    public boolean isEmpty() {
        return this.start == null;
    }

    public static InstructionHandle findHandle(InstructionHandle[] ihs, int[] pos, int count, int target) {
        int l = 0;
        int r = count - 1;
        do {
            int i;
            int j;
            if ((j = pos[i = (l + r) / 2]) == target) {
                return ihs[i];
            }
            if (target < j) {
                r = i - 1;
                continue;
            }
            l = i + 1;
        } while (l <= r);
        return null;
    }

    public InstructionHandle findHandle(int pos) {
        int[] positions = this.byte_positions;
        InstructionHandle ih = this.start;
        for (int i = 0; i < this.length; ++i) {
            if (positions[i] == pos) {
                return ih;
            }
            ih = ih.next;
        }
        return null;
    }

    public InstructionList(byte[] code) {
        ByteSequence bytes = new ByteSequence(code);
        InstructionHandle[] ihs = new InstructionHandle[code.length];
        int[] pos = new int[code.length];
        int count = 0;
        try {
            while (bytes.available() > 0) {
                int off;
                pos[count] = off = bytes.getIndex();
                Instruction i = Instruction.readInstruction(bytes);
                InstructionHandle ih = i instanceof BranchInstruction ? this.append((BranchInstruction)i) : this.append(i);
                ih.setPosition(off);
                ihs[count] = ih;
                ++count;
            }
        }
        catch (IOException e) {
            throw new ClassGenException(e.toString(), e);
        }
        this.byte_positions = new int[count];
        System.arraycopy(pos, 0, this.byte_positions, 0, count);
        for (int i = 0; i < count; ++i) {
            if (!(ihs[i] instanceof BranchHandle)) continue;
            BranchInstruction bi = (BranchInstruction)ihs[i].instruction;
            int target = bi.position + bi.getIndex();
            InstructionHandle ih = InstructionList.findHandle(ihs, pos, count, target);
            if (ih == null) {
                throw new ClassGenException("Couldn't find target for branch: " + bi);
            }
            bi.setTarget(ih);
            if (!(bi instanceof Select)) continue;
            Select s = (Select)bi;
            int[] indices = s.getIndices();
            for (int j = 0; j < indices.length; ++j) {
                target = bi.position + indices[j];
                ih = InstructionList.findHandle(ihs, pos, count, target);
                if (ih == null) {
                    throw new ClassGenException("Couldn't find target for switch: " + bi);
                }
                s.setTarget(j, ih);
            }
        }
    }

    public InstructionHandle append(InstructionHandle ih, InstructionList il) {
        if (il == null) {
            throw new ClassGenException("Appending null InstructionList");
        }
        if (il.isEmpty()) {
            return ih;
        }
        InstructionHandle next = ih.next;
        InstructionHandle ret = il.start;
        ih.next = il.start;
        il.start.prev = ih;
        il.end.next = next;
        if (next != null) {
            next.prev = il.end;
        } else {
            this.end = il.end;
        }
        this.length += il.length;
        il.clear();
        return ret;
    }

    public InstructionHandle append(Instruction i, InstructionList il) {
        InstructionHandle ih = this.findInstruction2(i);
        if (ih == null) {
            throw new ClassGenException("Instruction " + i + " is not contained in this list.");
        }
        return this.append(ih, il);
    }

    public InstructionHandle append(InstructionList il) {
        if (il == null) {
            throw new ClassGenException("Appending null InstructionList");
        }
        if (il.isEmpty()) {
            return null;
        }
        if (this.isEmpty()) {
            this.start = il.start;
            this.end = il.end;
            this.length = il.length;
            il.clear();
            return this.start;
        }
        return this.append(this.end, il);
    }

    private void append(InstructionHandle ih) {
        if (this.isEmpty()) {
            this.start = this.end = ih;
            ih.prev = null;
            ih.next = null;
        } else {
            this.end.next = ih;
            ih.prev = this.end;
            ih.next = null;
            this.end = ih;
        }
        ++this.length;
    }

    public InstructionHandle append(Instruction i) {
        InstructionHandle ih = InstructionHandle.getInstructionHandle(i);
        this.append(ih);
        return ih;
    }

    public BranchHandle append(BranchInstruction i) {
        BranchHandle ih = BranchHandle.getBranchHandle(i);
        this.append(ih);
        return ih;
    }

    public InstructionHandle append(Instruction i, Instruction j) {
        return this.append(i, new InstructionList(j));
    }

    public InstructionHandle append(Instruction i, CompoundInstruction c) {
        return this.append(i, c.getInstructionList());
    }

    public InstructionHandle append(CompoundInstruction c) {
        return this.append(c.getInstructionList());
    }

    public InstructionHandle append(InstructionHandle ih, CompoundInstruction c) {
        return this.append(ih, c.getInstructionList());
    }

    public InstructionHandle append(InstructionHandle ih, Instruction i) {
        return this.append(ih, new InstructionList(i));
    }

    public BranchHandle append(InstructionHandle ih, BranchInstruction i) {
        BranchHandle bh = BranchHandle.getBranchHandle(i);
        InstructionList il = new InstructionList();
        il.append(bh);
        this.append(ih, il);
        return bh;
    }

    public InstructionHandle insert(InstructionHandle ih, InstructionList il) {
        if (il == null) {
            throw new ClassGenException("Inserting null InstructionList");
        }
        if (il.isEmpty()) {
            return ih;
        }
        InstructionHandle prev = ih.prev;
        InstructionHandle ret = il.start;
        ih.prev = il.end;
        il.end.next = ih;
        il.start.prev = prev;
        if (prev != null) {
            prev.next = il.start;
        } else {
            this.start = il.start;
        }
        this.length += il.length;
        il.clear();
        return ret;
    }

    public InstructionHandle insert(InstructionList il) {
        if (this.isEmpty()) {
            this.append(il);
            return this.start;
        }
        return this.insert(this.start, il);
    }

    private void insert(InstructionHandle ih) {
        if (this.isEmpty()) {
            this.start = this.end = ih;
            ih.prev = null;
            ih.next = null;
        } else {
            this.start.prev = ih;
            ih.next = this.start;
            ih.prev = null;
            this.start = ih;
        }
        ++this.length;
    }

    public InstructionHandle insert(Instruction i, InstructionList il) {
        InstructionHandle ih = this.findInstruction1(i);
        if (ih == null) {
            throw new ClassGenException("Instruction " + i + " is not contained in this list.");
        }
        return this.insert(ih, il);
    }

    public InstructionHandle insert(Instruction i) {
        InstructionHandle ih = InstructionHandle.getInstructionHandle(i);
        this.insert(ih);
        return ih;
    }

    public BranchHandle insert(BranchInstruction i) {
        BranchHandle ih = BranchHandle.getBranchHandle(i);
        this.insert(ih);
        return ih;
    }

    public InstructionHandle insert(Instruction i, Instruction j) {
        return this.insert(i, new InstructionList(j));
    }

    public InstructionHandle insert(Instruction i, CompoundInstruction c) {
        return this.insert(i, c.getInstructionList());
    }

    public InstructionHandle insert(CompoundInstruction c) {
        return this.insert(c.getInstructionList());
    }

    public InstructionHandle insert(InstructionHandle ih, Instruction i) {
        return this.insert(ih, new InstructionList(i));
    }

    public InstructionHandle insert(InstructionHandle ih, CompoundInstruction c) {
        return this.insert(ih, c.getInstructionList());
    }

    public BranchHandle insert(InstructionHandle ih, BranchInstruction i) {
        BranchHandle bh = BranchHandle.getBranchHandle(i);
        InstructionList il = new InstructionList();
        il.append(bh);
        this.insert(ih, il);
        return bh;
    }

    public void move(InstructionHandle start, InstructionHandle end, InstructionHandle target) {
        if (start == null || end == null) {
            throw new ClassGenException("Invalid null handle: From " + start + " to " + end);
        }
        if (target == start || target == end) {
            throw new ClassGenException("Invalid range: From " + start + " to " + end + " contains target " + target);
        }
        InstructionHandle ih = start;
        while (ih != end.next) {
            if (ih == null) {
                throw new ClassGenException("Invalid range: From " + start + " to " + end);
            }
            if (ih == target) {
                throw new ClassGenException("Invalid range: From " + start + " to " + end + " contains target " + target);
            }
            ih = ih.next;
        }
        InstructionHandle prev = start.prev;
        InstructionHandle next = end.next;
        if (prev != null) {
            prev.next = next;
        } else {
            this.start = next;
        }
        if (next != null) {
            next.prev = prev;
        } else {
            this.end = prev;
        }
        end.next = null;
        start.prev = null;
        if (target == null) {
            if (this.start != null) {
                this.start.prev = end;
            }
            end.next = this.start;
            this.start = start;
        } else {
            next = target.next;
            target.next = start;
            start.prev = target;
            end.next = next;
            if (next != null) {
                next.prev = end;
            } else {
                this.end = end;
            }
        }
    }

    public void move(InstructionHandle ih, InstructionHandle target) {
        this.move(ih, ih, target);
    }

    private void remove(InstructionHandle prev, InstructionHandle next) throws TargetLostException {
        InstructionHandle last;
        InstructionHandle first;
        if (prev == null && next == null) {
            first = this.start;
            last = this.end;
            this.end = null;
            this.start = null;
        } else {
            if (prev == null) {
                first = this.start;
                this.start = next;
            } else {
                first = prev.next;
                prev.next = next;
            }
            if (next == null) {
                last = this.end;
                this.end = prev;
            } else {
                last = next.prev;
                next.prev = prev;
            }
        }
        first.prev = null;
        last.next = null;
        ArrayList<InstructionHandle> target_vec = new ArrayList<InstructionHandle>();
        InstructionHandle ih = first;
        while (ih != null) {
            ih.getInstruction().dispose();
            ih = ih.next;
        }
        StringBuilder buf = new StringBuilder("{ ");
        InstructionHandle ih2 = first;
        while (ih2 != null) {
            next = ih2.next;
            --this.length;
            if (ih2.hasTargeters()) {
                target_vec.add(ih2);
                buf.append(ih2.toString(true) + " ");
                ih2.prev = null;
                ih2.next = null;
            } else {
                ih2.dispose();
            }
            ih2 = next;
        }
        buf.append("}");
        if (!target_vec.isEmpty()) {
            InstructionHandle[] targeted = new InstructionHandle[target_vec.size()];
            target_vec.toArray(targeted);
            throw new TargetLostException(targeted, buf.toString());
        }
    }

    public void delete(InstructionHandle ih) throws TargetLostException {
        this.remove(ih.prev, ih.next);
    }

    public void delete(Instruction i) throws TargetLostException {
        InstructionHandle ih = this.findInstruction1(i);
        if (ih == null) {
            throw new ClassGenException("Instruction " + i + " is not contained in this list.");
        }
        this.delete(ih);
    }

    public void delete(InstructionHandle from, InstructionHandle to) throws TargetLostException {
        this.remove(from.prev, to.next);
    }

    public void delete(Instruction from, Instruction to) throws TargetLostException {
        InstructionHandle from_ih = this.findInstruction1(from);
        if (from_ih == null) {
            throw new ClassGenException("Instruction " + from + " is not contained in this list.");
        }
        InstructionHandle to_ih = this.findInstruction2(to);
        if (to_ih == null) {
            throw new ClassGenException("Instruction " + to + " is not contained in this list.");
        }
        this.delete(from_ih, to_ih);
    }

    private InstructionHandle findInstruction1(Instruction i) {
        InstructionHandle ih = this.start;
        while (ih != null) {
            if (ih.instruction == i) {
                return ih;
            }
            ih = ih.next;
        }
        return null;
    }

    private InstructionHandle findInstruction2(Instruction i) {
        InstructionHandle ih = this.end;
        while (ih != null) {
            if (ih.instruction == i) {
                return ih;
            }
            ih = ih.prev;
        }
        return null;
    }

    public boolean contains(InstructionHandle i) {
        if (i == null) {
            return false;
        }
        InstructionHandle ih = this.start;
        while (ih != null) {
            if (ih == i) {
                return true;
            }
            ih = ih.next;
        }
        return false;
    }

    public boolean contains(Instruction i) {
        return this.findInstruction1(i) != null;
    }

    public void setPositions() {
        this.setPositions(false);
    }

    public void setPositions(boolean check) {
        Instruction i;
        InstructionHandle ih;
        int max_additional_bytes = 0;
        int additional_bytes = 0;
        int index = 0;
        int count = 0;
        int[] pos = new int[this.length];
        if (check) {
            ih = this.start;
            while (ih != null) {
                i = ih.instruction;
                if (i instanceof BranchInstruction) {
                    Instruction inst = ((BranchInstruction)i).getTarget().instruction;
                    if (!this.contains(inst)) {
                        throw new ClassGenException("Branch target of " + Constants.OPCODE_NAMES[i.opcode] + ":" + inst + " not in instruction list");
                    }
                    if (i instanceof Select) {
                        InstructionHandle[] targets;
                        for (InstructionHandle target : targets = ((Select)i).getTargets()) {
                            inst = target.instruction;
                            if (this.contains(inst)) continue;
                            throw new ClassGenException("Branch target of " + Constants.OPCODE_NAMES[i.opcode] + ":" + inst + " not in instruction list");
                        }
                    }
                    if (!(ih instanceof BranchHandle)) {
                        throw new ClassGenException("Branch instruction " + Constants.OPCODE_NAMES[i.opcode] + ":" + inst + " not contained in BranchHandle.");
                    }
                }
                ih = ih.next;
            }
        }
        ih = this.start;
        while (ih != null) {
            i = ih.instruction;
            ih.setPosition(index);
            pos[count++] = index;
            switch (i.getOpcode()) {
                case 167: 
                case 168: {
                    max_additional_bytes += 2;
                    break;
                }
                case 170: 
                case 171: {
                    max_additional_bytes += 3;
                }
            }
            index += i.getLength();
            ih = ih.next;
        }
        ih = this.start;
        while (ih != null) {
            additional_bytes += ih.updatePosition(additional_bytes, max_additional_bytes);
            ih = ih.next;
        }
        count = 0;
        index = 0;
        ih = this.start;
        while (ih != null) {
            i = ih.instruction;
            ih.setPosition(index);
            pos[count++] = index;
            index += i.getLength();
            ih = ih.next;
        }
        this.byte_positions = new int[count];
        System.arraycopy(pos, 0, this.byte_positions, 0, count);
    }

    public byte[] getByteCode() {
        this.setPositions();
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(b);
        try {
            InstructionHandle ih = this.start;
            while (ih != null) {
                Instruction i = ih.instruction;
                i.dump(out);
                ih = ih.next;
            }
        }
        catch (IOException e) {
            System.err.println(e);
            return new byte[0];
        }
        return b.toByteArray();
    }

    public Instruction[] getInstructions() {
        ByteSequence bytes = new ByteSequence(this.getByteCode());
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        try {
            while (bytes.available() > 0) {
                instructions.add(Instruction.readInstruction(bytes));
            }
        }
        catch (IOException e) {
            throw new ClassGenException(e.toString(), e);
        }
        return instructions.toArray(new Instruction[instructions.size()]);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean verbose) {
        StringBuilder buf = new StringBuilder();
        InstructionHandle ih = this.start;
        while (ih != null) {
            buf.append(ih.toString(verbose)).append("\n");
            ih = ih.next;
        }
        return buf.toString();
    }

    public Iterator<InstructionHandle> iterator() {
        return new Iterator<InstructionHandle>(){
            private InstructionHandle ih;
            {
                this.ih = InstructionList.this.start;
            }

            @Override
            public InstructionHandle next() throws NoSuchElementException {
                if (this.ih == null) {
                    throw new NoSuchElementException();
                }
                InstructionHandle i = this.ih;
                this.ih = this.ih.next;
                return i;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.ih != null;
            }
        };
    }

    public InstructionHandle[] getInstructionHandles() {
        InstructionHandle[] ihs = new InstructionHandle[this.length];
        InstructionHandle ih = this.start;
        for (int i = 0; i < this.length; ++i) {
            ihs[i] = ih;
            ih = ih.next;
        }
        return ihs;
    }

    public int[] getInstructionPositions() {
        return this.byte_positions;
    }

    public InstructionList copy() {
        HashMap<InstructionHandle, InstructionHandle> map = new HashMap<InstructionHandle, InstructionHandle>();
        InstructionList il = new InstructionList();
        InstructionHandle ih = this.start;
        while (ih != null) {
            Instruction i = ih.instruction;
            Instruction c = i.copy();
            if (c instanceof BranchInstruction) {
                map.put(ih, il.append((BranchInstruction)c));
            } else {
                map.put(ih, il.append(c));
            }
            ih = ih.next;
        }
        ih = this.start;
        InstructionHandle ch = il.start;
        while (ih != null) {
            Instruction i = ih.instruction;
            Instruction c = ch.instruction;
            if (i instanceof BranchInstruction) {
                BranchInstruction bi = (BranchInstruction)i;
                BranchInstruction bc = (BranchInstruction)c;
                InstructionHandle itarget = bi.getTarget();
                bc.setTarget((InstructionHandle)map.get(itarget));
                if (bi instanceof Select) {
                    InstructionHandle[] itargets = ((Select)bi).getTargets();
                    InstructionHandle[] ctargets = ((Select)bc).getTargets();
                    for (int j = 0; j < itargets.length; ++j) {
                        ctargets[j] = (InstructionHandle)map.get(itargets[j]);
                    }
                }
            }
            ih = ih.next;
            ch = ch.next;
        }
        return il;
    }

    public void replaceConstantPool(ConstantPoolGen old_cp, ConstantPoolGen new_cp) {
        InstructionHandle ih = this.start;
        while (ih != null) {
            Instruction i = ih.instruction;
            if (i instanceof CPInstruction) {
                CPInstruction ci = (CPInstruction)i;
                Constant c = old_cp.getConstant(ci.getIndex());
                ci.setIndex(new_cp.addConstant(c, old_cp));
            }
            ih = ih.next;
        }
    }

    private void clear() {
        this.end = null;
        this.start = null;
        this.length = 0;
    }

    public void dispose() {
        InstructionHandle ih = this.end;
        while (ih != null) {
            ih.dispose();
            ih = ih.prev;
        }
        this.clear();
    }

    public InstructionHandle getStart() {
        return this.start;
    }

    public InstructionHandle getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.length;
    }

    public int size() {
        return this.length;
    }

    public void redirectBranches(InstructionHandle old_target, InstructionHandle new_target) {
        InstructionHandle ih = this.start;
        while (ih != null) {
            Instruction i = ih.getInstruction();
            if (i instanceof BranchInstruction) {
                BranchInstruction b = (BranchInstruction)i;
                InstructionHandle target = b.getTarget();
                if (target == old_target) {
                    b.setTarget(new_target);
                }
                if (b instanceof Select) {
                    InstructionHandle[] targets = ((Select)b).getTargets();
                    for (int j = 0; j < targets.length; ++j) {
                        if (targets[j] != old_target) continue;
                        ((Select)b).setTarget(j, new_target);
                    }
                }
            }
            ih = ih.next;
        }
    }

    public void redirectLocalVariables(LocalVariableGen[] lg, InstructionHandle old_target, InstructionHandle new_target) {
        for (LocalVariableGen element : lg) {
            InstructionHandle start = element.getStart();
            InstructionHandle end = element.getEnd();
            if (start == old_target) {
                element.setStart(new_target);
            }
            if (end != old_target) continue;
            element.setEnd(new_target);
        }
    }

    public void redirectExceptionHandlers(CodeExceptionGen[] exceptions, InstructionHandle old_target, InstructionHandle new_target) {
        for (CodeExceptionGen exception : exceptions) {
            if (exception.getStartPC() == old_target) {
                exception.setStartPC(new_target);
            }
            if (exception.getEndPC() == old_target) {
                exception.setEndPC(new_target);
            }
            if (exception.getHandlerPC() != old_target) continue;
            exception.setHandlerPC(new_target);
        }
    }

    public void addObserver(InstructionListObserver o) {
        if (this.observers == null) {
            this.observers = new ArrayList<InstructionListObserver>();
        }
        this.observers.add(o);
    }

    public void removeObserver(InstructionListObserver o) {
        if (this.observers != null) {
            this.observers.remove(o);
        }
    }

    public void update() {
        if (this.observers != null) {
            for (InstructionListObserver observer : this.observers) {
                observer.notify(this);
            }
        }
    }
}

