/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.util.ByteSequence;

public abstract class LocalVariableInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    private static final long serialVersionUID = 8322269736316122743L;
    protected int n = -1;
    private short c_tag = (short)-1;
    private short canon_tag = (short)-1;

    private boolean wide() {
        return this.n > 255;
    }

    LocalVariableInstruction(short canon_tag, short c_tag) {
        this.canon_tag = canon_tag;
        this.c_tag = c_tag;
    }

    LocalVariableInstruction() {
    }

    protected LocalVariableInstruction(short opcode, short c_tag, int n) {
        super(opcode, (short)2);
        this.c_tag = c_tag;
        this.canon_tag = opcode;
        this.setIndex(n);
    }

    public void dump(DataOutputStream out) throws IOException {
        if (this.wide()) {
            out.writeByte(196);
        }
        out.writeByte(this.opcode);
        if (this.length > 1) {
            if (this.wide()) {
                out.writeShort(this.n);
            } else {
                out.writeByte(this.n);
            }
        }
    }

    public String toString(boolean verbose) {
        if (this.opcode >= 26 && this.opcode <= 45 || this.opcode >= 59 && this.opcode <= 78) {
            return super.toString(verbose);
        }
        return super.toString(verbose) + " " + this.n;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        if (wide) {
            this.n = bytes.readUnsignedShort();
            this.length = (short)4;
        } else if (this.opcode >= 21 && this.opcode <= 25 || this.opcode >= 54 && this.opcode <= 58) {
            this.n = bytes.readUnsignedByte();
            this.length = (short)2;
        } else if (this.opcode <= 45) {
            this.n = (this.opcode - 26) % 4;
            this.length = 1;
        } else {
            this.n = (this.opcode - 59) % 4;
            this.length = 1;
        }
    }

    public final int getIndex() {
        return this.n;
    }

    public void setIndex(int n) {
        if (n < 0 || n > 65535) {
            throw new ClassGenException("Illegal value: " + n);
        }
        this.n = n;
        if (n >= 0 && n <= 3) {
            this.opcode = (short)(this.c_tag + n);
            this.length = 1;
        } else {
            this.opcode = this.canon_tag;
            this.length = this.wide() ? (short)4 : (short)2;
        }
    }

    public short getCanonicalTag() {
        return this.canon_tag;
    }

    public Type getType(ConstantPoolGen cp) {
        switch (this.canon_tag) {
            case 21: 
            case 54: {
                return Type.INT;
            }
            case 22: 
            case 55: {
                return Type.LONG;
            }
            case 24: 
            case 57: {
                return Type.DOUBLE;
            }
            case 23: 
            case 56: {
                return Type.FLOAT;
            }
            case 25: 
            case 58: {
                return Type.OBJECT;
            }
        }
        throw new ClassGenException("Oops: unknown case in switch" + this.canon_tag);
    }
}

