/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassPath;
import org.apache.bcel.util.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassLoaderRepository
implements Repository {
    private static final long serialVersionUID = -1052781833503868187L;
    private final ClassLoader loader;
    private final Map<String, JavaClass> loadedClasses = new HashMap<String, JavaClass>();

    public ClassLoaderRepository(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public void storeClass(JavaClass clazz) {
        this.loadedClasses.put(clazz.getClassName(), clazz);
        clazz.setRepository(this);
    }

    @Override
    public void removeClass(JavaClass clazz) {
        this.loadedClasses.remove(clazz.getClassName());
    }

    @Override
    public JavaClass findClass(String className) {
        return this.loadedClasses.containsKey(className) ? this.loadedClasses.get(className) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JavaClass loadClass(String className) throws ClassNotFoundException {
        JavaClass javaClass;
        String classFile = className.replace('.', '/');
        JavaClass RC = this.findClass(className);
        if (RC != null) {
            return RC;
        }
        InputStream is = this.loader.getResourceAsStream(classFile + ".class");
        if (is == null) {
            throw new ClassNotFoundException(className + " not found.");
        }
        try {
            ClassParser parser = new ClassParser(is, className);
            RC = parser.parse();
            this.storeClass(RC);
            javaClass = RC;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ClassNotFoundException(className + " not found: " + e, e);
            }
        }
        is.close();
        return javaClass;
    }

    @Override
    public JavaClass loadClass(Class<?> clazz) throws ClassNotFoundException {
        return this.loadClass(clazz.getName());
    }

    @Override
    public void clear() {
        this.loadedClasses.clear();
    }

    @Override
    public ClassPath getClassPath() {
        return null;
    }
}

