/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.hierarchy;

import com.whitemagicsoftware.hierarchy.ClassPathUpdater;
import com.whitemagicsoftware.hierarchy.ClassWalker;
import com.whitemagicsoftware.hierarchy.exceptions.ClasspathException;
import com.whitemagicsoftware.hierarchy.exceptions.HierarchyNotFoundException;
import com.whitemagicsoftware.util.MultiValueMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public abstract class ClassAnalyzer
implements Runnable {
    public static final String CLASS_EXTENSION = ".class";
    private static final char FS = File.separatorChar;
    private static final char PS = '.';
    private Set<String> classes = new HashSet<String>(64);
    private ClassWalker classWalker = new ClassWalker();
    private Pattern excludeRegex = Pattern.compile("");
    private MultiValueMap<JavaClass, JavaClass> hierarchy = new MultiValueMap();
    private Map<String, JavaClass> parsedClasses = new HashMap<String, JavaClass>(1024);
    private Set<File> classpathFiles = new HashSet<File>();

    @Override
    public void run() {
        String path = ClassPathUpdater.getSystemClassPath();
        this.doAnalysis();
        ClassPathUpdater.setSystemClassPath(path);
    }

    protected abstract void doAnalysis();

    public abstract void visitSubclass(JavaClass var1, JavaClass var2);

    public abstract void visitSuperclass(JavaClass var1, JavaClass var2);

    public void addClasses(String[] filenames) {
        this.addClasses(Arrays.asList(filenames));
    }

    public void addClasses(Collection<String> filenames) {
        this.getClasses().addAll(filenames);
    }

    public void addClassFiles(Collection<File> files) {
        for (File f : files) {
            this.addClass(f.toString());
        }
    }

    public void addClass(String filename) {
        this.getClasses().add(filename);
    }

    public void excludeSimple(String exclude) {
        this.setExcludeRegex("^" + exclude.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*"));
    }

    public void setExcludeRegex(String excludeRegex) {
        if (excludeRegex == null) {
            excludeRegex = "";
        }
        this.excludeRegex = Pattern.compile(excludeRegex);
    }

    private Pattern getExcludeRegex() {
        return this.excludeRegex;
    }

    protected void analyze() throws ClassNotFoundException, ClasspathException, HierarchyNotFoundException {
        HashSet<JavaClass> classes = new HashSet<JavaClass>();
        for (String className : this.getClasses()) {
            JavaClass jc = this.getJavaClass(className);
            if (className.endsWith(CLASS_EXTENSION)) {
                this.updateClassPath(this.getPackageRootPath(jc));
            }
            classes.add(jc);
        }
        this.initClasspathFiles();
        this.findSuperclasses(classes);
        this.findSubclasses(classes);
        if (this.getHierarchy().size() == 0) {
            throw new HierarchyNotFoundException(this.getClasses().toString());
        }
    }

    private File getPackageRootPath(JavaClass jc) {
        String path = this.getClassDirectory(jc.getFileName()).getAbsolutePath();
        int i = path.lastIndexOf(this.getPackagePath(jc));
        if (i == -1) {
            throw new IllegalArgumentException("Package directory mismatch.");
        }
        return new File(path.substring(0, i));
    }

    private ClassParser createClassParser(InputStream is, String filename) throws IOException {
        return is == null ? new ClassParser(filename) : new ClassParser(is, filename);
    }

    private String getPackageName(JavaClass jc) {
        String packageName = jc.getPackageName();
        return packageName == null ? "" : packageName;
    }

    private String getPackagePath(JavaClass jc) {
        return this.getPackageName(jc).replace('.', FS);
    }

    public void updateClassPath(File path) throws ClasspathException {
        ClassPathUpdater.add(path);
    }

    public void updateClassPath(Collection<File> files) throws ClasspathException {
        for (File f : files) {
            this.updateClassPath(f);
        }
    }

    private void findSuperclasses(Set<JavaClass> children) throws ClassNotFoundException {
        for (JavaClass child : children) {
            this.findSuperclasses(child);
        }
    }

    protected void findSuperclasses(JavaClass child) throws ClassNotFoundException {
        JavaClass parent = child.getSuperClass();
        while (parent != null && this.canVisit(parent) && this.canVisit(child)) {
            if (this.register(parent, child)) {
                this.visitSuperclass(parent, child);
            }
            child = parent;
            parent = child.getSuperClass();
        }
    }

    protected void findSubclasses(JavaClass parent) {
        HashSet<JavaClass> parents = new HashSet<JavaClass>();
        parents.add(parent);
        this.findSubclasses(parents);
    }

    protected void findSubclasses(Set<JavaClass> parents) {
        HashSet<JavaClass> subclasses = new HashSet<JavaClass>(parents.size());
        for (File file : this.getClasspathFiles()) {
            if (file.isDirectory()) {
                this.findDirectorySubclasses(parents, file, subclasses);
                continue;
            }
            this.findArchiveSubclasses(parents, file, subclasses);
        }
        if (subclasses.size() > 0) {
            this.findSubclasses(subclasses);
        }
    }

    private void initClasspathFiles() {
        Set<File> classpathFiles = this.getClasspathFiles();
        classpathFiles.clear();
        for (String pathElement : ClassPathUpdater.getClassPathElements()) {
            File file = new File(pathElement);
            if (!file.exists()) continue;
            classpathFiles.add(file);
        }
    }

    private void findDirectorySubclasses(Set<JavaClass> parents, File path, Set<JavaClass> children) {
        Collection<File> files = this.getClassWalker().getCollection();
        if (files.isEmpty()) {
            files = this.getClassWalker().walk(path);
        }
        for (File file : files) {
            try {
                this.registerSubclasses(parents, this.getJavaClass(file.getAbsolutePath()), children);
            }
            catch (ClassNotFoundException ex) {
                this.classNotFound(file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findArchiveSubclasses(Set<JavaClass> parents, File archive, Set<JavaClass> children) {
        JarFile jarFile = null;
        try {
            jarFile = this.createJarFile(archive);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                try {
                    if (!this.isClassEntry(entry)) continue;
                    this.registerSubclasses(parents, this.extractSubclass(jarFile, entry), children);
                }
                catch (ClassNotFoundException ex) {
                    this.classNotFound(jarFile, entry);
                }
            }
        }
        catch (IOException ex) {
            this.archiveNotFound(archive);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ex) {
                    this.archiveNotClosed(ex);
                }
            }
        }
    }

    protected ClassWalker getClassWalker() {
        return this.classWalker;
    }

    protected void setClassWalker(ClassWalker classWalker) {
        this.classWalker = classWalker;
    }

    private boolean isSubclass(JavaClass parent, JavaClass child) throws ClassNotFoundException {
        JavaClass childSuperclass = child.getSuperClass();
        return childSuperclass != null && childSuperclass.equals((Object)parent);
    }

    private JarFile createJarFile(File archive) throws IOException {
        return new JarFile(archive);
    }

    private void registerSubclasses(Set<JavaClass> parents, JavaClass child, Set<JavaClass> children) throws ClassNotFoundException {
        for (JavaClass parent : parents) {
            if (!this.isSubclass(parent, child) || !this.canVisit(child) || !this.canVisit(parent) || !this.register(parent, child)) continue;
            children.add(child);
            this.visitSubclass(parent, child);
        }
    }

    protected boolean canVisit(JavaClass jc) {
        String className = jc.getClassName();
        return !this.isInnerClass(className) && !this.getExcludeRegex().matcher(className).matches();
    }

    protected boolean isInnerClass(String className) {
        return className.indexOf(36) > 0;
    }

    private boolean register(JavaClass parent, JavaClass child) {
        return this.getHierarchy().put(parent, child) != null;
    }

    private JavaClass extractSubclass(JarFile jf, JarEntry je) throws ClassNotFoundException {
        try {
            return this.isClassEntry(je) ? this.getJavaClass(jf.getInputStream(je), je.getName()) : null;
        }
        catch (IOException ex) {
            throw new ClassNotFoundException(je.getName(), ex);
        }
    }

    private boolean isClassEntry(JarEntry jarEntry) {
        return jarEntry == null ? false : jarEntry.getName().endsWith(CLASS_EXTENSION);
    }

    private File getClassDirectory(String filename) {
        File file = new File(filename);
        return file.isDirectory() ? file : file.getParentFile();
    }

    protected void archiveNotFound(File archive) {
        System.err.println("Archive not found: " + archive.getAbsolutePath());
    }

    protected void archiveNotClosed(IOException ex) {
        System.err.println("Archive not closed: " + ex.toString());
    }

    protected void classNotFound(JarFile jf, JarEntry je) {
        this.classNotFound(jf.getName() + "::" + je.getName());
    }

    protected void classNotFound(File file) {
        this.classNotFound(file.getAbsolutePath());
    }

    protected void classNotFound(String path) {
        System.err.println("Class not found: " + path);
    }

    private Set<String> getClasses() {
        return this.classes;
    }

    private MultiValueMap<JavaClass, JavaClass> getHierarchy() {
        return this.hierarchy;
    }

    public void reset() {
        this.getHierarchy().clear();
        this.getClasspathFiles().clear();
    }

    private JavaClass getJavaClass(InputStream is, String className) throws ClassNotFoundException {
        JavaClass jc = this.getParsedClasses().get(className);
        if (jc == null) {
            try {
                jc = Repository.lookupClass((String)className);
            }
            catch (ClassNotFoundException ex) {
                try {
                    jc = this.createClassParser(is, className).parse();
                }
                catch (Exception e) {
                    throw new ClassNotFoundException(className);
                }
            }
            this.getParsedClasses().put(className, jc);
        }
        return jc;
    }

    private JavaClass getJavaClass(String className) throws ClassNotFoundException {
        return this.getJavaClass(null, className);
    }

    private Map<String, JavaClass> getParsedClasses() {
        return this.parsedClasses;
    }

    private Set<File> getClasspathFiles() {
        return this.classpathFiles;
    }
}

