/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.hierarchy;

import com.whitemagicsoftware.hierarchy.exceptions.ClasspathException;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class ClassPathUpdater {
    private static final Class<?>[] PARAMETERS = new Class[]{URL.class};
    private static final Class<?> CLASS_LOADER = URLClassLoader.class;
    private static final String ADD_URL = "addURL";
    private static final String NS = File.pathSeparator;
    private static final String PROPERTY_CLASSPATH = "java.class.path";
    private static Method addURL;

    private ClassPathUpdater() {
    }

    public static void addPaths(String paths) throws ClasspathException {
        for (String path : paths.split(NS)) {
            try {
                ClassPathUpdater.add(path);
            }
            catch (ClasspathException ex) {
                if (ex.getCause() instanceof FileNotFoundException) continue;
                throw ex;
            }
        }
    }

    public static void add(String s) throws ClasspathException {
        ClassPathUpdater.add(new File(s));
    }

    public static void add(File f) throws ClasspathException {
        String classPath;
        if (f == null) {
            ClassPathUpdater.classpathException(new IllegalArgumentException("Path is null."));
        } else if (!f.exists()) {
            ClassPathUpdater.classpathException(new FileNotFoundException(f.getAbsolutePath()));
        }
        String pathName = f.getAbsolutePath();
        if (pathName.endsWith(".class")) {
            f = f.getParentFile();
            pathName = f.getAbsolutePath();
        }
        if ((classPath = ClassPathUpdater.getSystemClassPath()).lastIndexOf(pathName) == -1) {
            ClassPathUpdater.setSystemClassPath(classPath + NS + pathName);
            try {
                ClassPathUpdater.add(f.toURI().toURL());
            }
            catch (Exception ex) {
                ClassPathUpdater.classpathException(ex);
            }
        }
    }

    private static void add(URL url) throws ClasspathException {
        try {
            ClassPathUpdater.getAddURL().invoke((Object)ClassPathUpdater.getCurrentClassLoader(), url);
        }
        catch (Exception ex) {
            ClassPathUpdater.classpathException(ex);
        }
    }

    public static String[] getClassPathElements() {
        return ClassPathUpdater.getSystemClassPath().split(NS);
    }

    private static Method getAddURL() {
        return addURL;
    }

    private static ClassLoader getCurrentClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private static void classpathException(Exception cause) throws ClasspathException {
        throw new ClasspathException(cause);
    }

    public static String getSystemClassPath() {
        String path = System.getProperty(PROPERTY_CLASSPATH);
        return path == null ? "" : path;
    }

    public static void setSystemClassPath(String path) {
        System.setProperty(PROPERTY_CLASSPATH, path);
    }

    static {
        try {
            addURL = CLASS_LOADER.getDeclaredMethod(ADD_URL, PARAMETERS);
            addURL.setAccessible(true);
        }
        catch (NoSuchMethodException ex) {
            System.err.println(ex);
        }
    }
}

