/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.hierarchy;

import java.io.File;
import java.util.Collection;
import java.util.HashSet;

public class ClassWalker {
    private static final int DEFAULT_DEPTH = 32;
    private Collection<File> collection = new HashSet<File>(64);

    public Collection<File> walk(File path) {
        Collection<File> c = this.getCollection();
        c.clear();
        this.walk(path, 0, c);
        return c;
    }

    public Collection<File> getCollection() {
        return this.collection;
    }

    private void walk(File path, int depth, Collection<File> collection) {
        File[] files;
        int childDepth = depth + 1;
        if (childDepth < this.getMaximumDepth() && (files = path.listFiles()) != null) {
            for (int i = files.length - 1; i >= 0; --i) {
                File child = files[i];
                if (child.isHidden() || child.getName().startsWith(".")) continue;
                if (child.isDirectory()) {
                    this.walk(child, childDepth, collection);
                    continue;
                }
                if (!child.isFile() || !child.getAbsolutePath().endsWith(".class")) continue;
                collection.add(child);
            }
        }
    }

    protected int getMaximumDepth() {
        return 32;
    }
}

