/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.hierarchy.analyzers;

import com.whitemagicsoftware.hierarchy.ClassAnalyzer;
import com.whitemagicsoftware.hierarchy.ClassPathUpdater;
import com.whitemagicsoftware.hierarchy.exceptions.ClasspathException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;

public abstract class BaseClassAnalyzer
extends ClassAnalyzer {
    protected static final char PS = File.pathSeparatorChar;
    private OptionParser optionParser;

    protected void initClasspath(Collection<String> properties) throws ClasspathException {
        for (String property : properties) {
            ClassPathUpdater.addPaths(System.getProperty(property));
        }
    }

    protected void initBootstrapClasspath() throws ClasspathException {
        ClassPathUpdater.addPaths(System.getProperty("sun.boot.class.path"));
    }

    protected OptionSet parseOptions(String[] args) throws IOException, ClasspathException {
        OptionParser parser = this.getOptionParser();
        ArgumentAcceptingOptionSpec classes = parser.acceptsAll(Arrays.asList("c", "classes"), "Class name to analyze.").withRequiredArg().describedAs("C1.class" + PS + "C2.class").ofType(File.class).withValuesSeparatedBy(PS);
        ArgumentAcceptingOptionSpec classpath = parser.acceptsAll(Arrays.asList("cp", "classpath"), "Directory or Java archive to search.").withRequiredArg().describedAs("dir" + PS + "file.jar").ofType(File.class).withValuesSeparatedBy(PS);
        ArgumentAcceptingOptionSpec properties = parser.acceptsAll(Arrays.asList("p", "properties"), "Search System property classpaths.").withRequiredArg().describedAs("java.ext.dirs" + PS + "java.library.path").ofType(String.class).withValuesSeparatedBy(PS);
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            this.showHelp();
        }
        if (options.has("classpath")) {
            this.updateClassPath(options.valuesOf((OptionSpec)classpath));
        }
        if (options.has("properties")) {
            this.initClasspath(options.valuesOf((OptionSpec)properties));
        }
        if (options.has("classes")) {
            this.addClassFiles(options.valuesOf((OptionSpec)classes));
        }
        if (options.has("exclude")) {
            this.excludeSimple((String)options.valueOf("exclude"));
        }
        if (options.has("display-classpath")) {
            this.displayClasspath();
        }
        this.initBootstrapClasspath();
        return options;
    }

    protected OptionParser getOptionParser() {
        if (this.optionParser == null) {
            this.optionParser = this.createOptionParser();
        }
        return this.optionParser;
    }

    protected OptionParser createOptionParser() {
        return new OptionParser(){
            {
                this.acceptsAll(Arrays.asList("h", "?", "help"), "Show this help text.");
                this.acceptsAll(Arrays.asList("e", "exclude"), "Ignore packages and classes.").withRequiredArg().describedAs("java.awt.*|java.nio.*");
                this.acceptsAll(Arrays.asList("dc", "display-classpath"), "Write classpath to standard out.");
            }
        };
    }

    protected void showHelp() throws IOException {
        this.getOptionParser().printHelpOn((OutputStream)System.out);
        this.exit();
    }

    protected void exit() {
        System.exit(1);
    }

    private void displayClasspath() {
        System.out.println("CLASSPATH=" + ClassPathUpdater.getSystemClassPath());
    }
}

