/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.hierarchy.analyzers;

import com.whitemagicsoftware.hierarchy.analyzers.BaseClassAnalyzer;
import com.whitemagicsoftware.hierarchy.exceptions.ClasspathException;
import com.whitemagicsoftware.hierarchy.exceptions.HierarchyNotFoundException;
import java.io.IOException;
import org.apache.bcel.classfile.JavaClass;

public class GraphVizClassAnalyzer
extends BaseClassAnalyzer {
    @Override
    public void doAnalysis() {
        this.dotOutputBegin();
        try {
            this.analyze();
        }
        catch (ClassNotFoundException ex) {
            System.err.println(ex.toString());
        }
        catch (ClasspathException ex) {
            System.err.println(ex.toString());
        }
        catch (HierarchyNotFoundException ex) {
            System.err.println(ex.toString());
        }
        this.dotOutputEnd();
    }

    @Override
    public void visitSubclass(JavaClass parent, JavaClass child) {
        this.dotOutput(parent, child);
    }

    @Override
    public void visitSuperclass(JavaClass parent, JavaClass child) {
        this.dotOutput(parent, child);
    }

    private void dotOutputBegin() {
        System.out.println("digraph G {");
        System.out.println("node [shape=box];");
        System.out.println("rankdir=LR;");
    }

    private void dotOutputEnd() {
        System.out.println("}");
    }

    private void dotOutput(JavaClass parent, JavaClass child) {
        System.out.print("\"");
        System.out.print(parent.getClassName());
        System.out.print("\" -> \"");
        System.out.print(child.getClassName());
        System.out.println("\"");
    }

    public static void main(String[] args) throws InterruptedException, IOException, ClasspathException {
        GraphVizClassAnalyzer ca = new GraphVizClassAnalyzer();
        Thread thread = new Thread(ca);
        ca.parseOptions(args);
        thread.run();
        thread.join();
    }
}

