/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.hierarchy.analyzers;

import com.whitemagicsoftware.hierarchy.analyzers.BaseClassAnalyzer;
import com.whitemagicsoftware.hierarchy.exceptions.ClasspathException;
import com.whitemagicsoftware.hierarchy.exceptions.HierarchyNotFoundException;
import com.whitemagicsoftware.util.DefaultTreeImpl;
import com.whitemagicsoftware.util.MultiValueMap;
import com.whitemagicsoftware.util.MultiValueMapTransformer;
import com.whitemagicsoftware.util.Tree;
import com.whitemagicsoftware.util.TreeFactory;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.bcel.classfile.JavaClass;

public class PrefuseClassAnalyzer
extends BaseClassAnalyzer {
    private MultiValueMap<JavaClass, JavaClass> map = new MultiValueMap();

    @Override
    public void doAnalysis() {
        try {
            this.analyze();
        }
        catch (ClassNotFoundException ex) {
            System.err.println(ex.toString());
        }
        catch (ClasspathException ex) {
            System.err.println(ex.toString());
        }
        catch (HierarchyNotFoundException ex) {
            System.err.println(ex.toString());
        }
    }

    @Override
    public void visitSubclass(JavaClass parent, JavaClass child) {
        this.put(parent, child);
    }

    @Override
    public void visitSuperclass(JavaClass parent, JavaClass child) {
        this.put(parent, child);
    }

    private void put(JavaClass parent, JavaClass child) {
        this.getMap().put(parent, child);
    }

    private MultiValueMap<JavaClass, JavaClass> getMap() {
        return this.map;
    }

    protected Set<Tree> transform() {
        return this.createTransformer().transform();
    }

    private MultiValueMapTransformer<JavaClass> createTransformer() {
        return new MultiValueMapTransformer<JavaClass>(this.getMap(), this.getTreeFactory());
    }

    protected TreeFactory<JavaClass> getTreeFactory() {
        return new PrefuseTreeFactoryImpl<JavaClass>();
    }

    public static void main(String[] args) throws InterruptedException, IOException, ClasspathException {
        PrefuseClassAnalyzer pca = new PrefuseClassAnalyzer();
        Thread thread = new Thread(pca);
        pca.parseOptions(args);
        thread.run();
        thread.join();
        Set<Tree> treeSet = pca.transform();
        Iterator<Tree> iterator = treeSet.iterator();
        iterator.next().walk();
    }

    protected class PrefuseTreeFactoryImpl<Payload>
    implements TreeFactory<Payload> {
        @Override
        public Tree create(Payload payload) {
            return new PrefuseTreeImpl<Payload>(payload);
        }
    }

    protected class PrefuseTreeImpl<Payload>
    extends DefaultTreeImpl<Payload>
    implements Comparable<Payload> {
        public PrefuseTreeImpl(Payload payload) {
            super(payload);
        }

        @Override
        public void walk() {
            this.prefuseOutputBegin();
            this.walk(this, 0);
            this.prefuseOutputEnd();
        }

        protected void prefuseOutputBegin() {
            System.out.printf("<?xml version='1.0'?>\n", new Object[0]);
            System.out.printf("<tree>\n", new Object[0]);
            System.out.printf("  <declarations>\n", new Object[0]);
            System.out.printf("    <attributeDecl name='name' type='String' />\n", new Object[0]);
            System.out.printf("  </declarations>\n", new Object[0]);
        }

        protected void prefuseOutputEnd() {
            System.out.printf("</tree>\n", new Object[0]);
        }

        protected void walk(Tree tree, int level) {
            TreeSet<Tree> children = new TreeSet<Tree>(tree.getChildren());
            String spaces = this.getIndent(++level);
            PrefuseTreeImpl treeImpl = (PrefuseTreeImpl)tree;
            if (children.isEmpty()) {
                System.out.printf("%s<leaf>\n", spaces);
                System.out.printf("%s  <attribute name='name' value='%s' />\n", spaces, ((JavaClass)treeImpl.getPayload()).getClassName());
                System.out.printf("%s</leaf>\n", spaces);
            } else {
                System.out.printf("%s<branch>\n", spaces);
                System.out.printf("%s  <attribute name='name' value='%s' />\n", spaces, ((JavaClass)treeImpl.getPayload()).getClassName());
                for (Tree child : children) {
                    this.walk(child, level);
                }
                System.out.printf("%s</branch>\n", spaces);
            }
        }

        private String getIndent(int level) {
            StringBuilder spaces = new StringBuilder(128);
            for (int i = 0; i < level; ++i) {
                spaces.append("  ");
            }
            return spaces.toString();
        }

        @Override
        public int compareTo(Object o) {
            if (o instanceof PrefuseTreeImpl) {
                PrefuseTreeImpl that = (PrefuseTreeImpl)o;
                JavaClass thatPayload = (JavaClass)that.getPayload();
                JavaClass thisPayload = (JavaClass)this.getPayload();
                return thisPayload.getClassName().compareTo(thatPayload.getClassName());
            }
            throw new ClassCastException(o.getClass().toString());
        }
    }
}

