/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.hierarchy.app;

import com.whitemagicsoftware.hierarchy.analyzers.PrefuseClassAnalyzer;
import com.whitemagicsoftware.hierarchy.app.TreeView;
import com.whitemagicsoftware.hierarchy.app.actions.AnimationListener;
import com.whitemagicsoftware.hierarchy.exceptions.ClasspathException;
import com.whitemagicsoftware.hierarchy.exceptions.HierarchyNotFoundException;
import com.whitemagicsoftware.util.Tree;
import com.whitemagicsoftware.util.TreeFactory;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.UIManager;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.bcel.classfile.JavaClass;
import prefuse.Display;
import prefuse.data.Node;
import prefuse.util.io.IOLib;

public class Hierarchy
extends PrefuseClassAnalyzer
implements ActionListener,
AnimationListener {
    private JFrame frame;
    private TreeView treeView;
    private boolean highQuality;
    private String exportFilename = null;
    private double exportScale = 2.0;

    @Override
    public void doAnalysis() {
        try {
            this.analyze();
            this.transmogrify();
            this.display();
            if (this.exportRequested()) {
                this.registerAnimationListener();
            }
        }
        catch (ClassNotFoundException ex) {
            System.err.println(ex.toString());
        }
        catch (ClasspathException ex) {
            System.err.println(ex.toString());
        }
        catch (HierarchyNotFoundException ex) {
            System.err.println(ex.toString());
        }
    }

    private void transmogrify() {
        Set<Tree> tree = this.transform();
        Iterator<Tree> i = tree.iterator();
        if (i.hasNext()) {
            i.next().walk();
        }
    }

    private void display() {
        this.applyNativeLookAndFeel();
        this.getFrame().setVisible(true);
        this.getTreeView().display();
        this.getFrame().pack();
        this.getTreeView().zoomToFit();
    }

    private void registerAnimationListener() {
        this.getTreeView().addAnimationListener(this);
    }

    private void applyNativeLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean exportRequested() {
        return this.getExportFilename() != null && this.getExportScale() > 0.0;
    }

    @Override
    public void animationFinished(Display display) {
        File file = new File(this.getExportFilename());
        FileOutputStream out = null;
        double scale = this.getExportScale();
        try {
            String format = IOLib.getExtension((File)file).toLowerCase();
            out = new FileOutputStream(file);
            this.treeView.saveImage(out, format, scale);
        }
        catch (Exception e) {
            System.err.println("Could not save: " + e.getMessage());
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.exit();
    }

    private JFrame getFrame() {
        if (this.frame == null) {
            this.frame = this.createFrame();
        }
        return this.frame;
    }

    protected String getFrameTitle() {
        return "Hierarchy";
    }

    private JFrame createFrame() {
        JFrame frame = new JFrame(this.getFrameTitle());
        frame.setDefaultCloseOperation(3);
        frame.setContentPane((Container)((Object)this.getTreeView()));
        return frame;
    }

    private TreeView getTreeView() {
        if (this.treeView == null) {
            this.treeView = this.createTreeView();
        }
        return this.treeView;
    }

    protected TreeView createTreeView() {
        return new TreeView(this.isHighQuality());
    }

    private void setHighQuality(boolean highQuality) {
        this.highQuality = highQuality;
    }

    private boolean isHighQuality() {
        return this.highQuality;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.exit();
    }

    private void setExportFilename(String exportFilename) {
        this.exportFilename = exportFilename;
    }

    private String getExportFilename() {
        return this.exportFilename;
    }

    private void setExportScale(double exportScale) {
        this.exportScale = exportScale;
    }

    private double getExportScale() {
        return this.exportScale;
    }

    @Override
    protected TreeFactory<JavaClass> getTreeFactory() {
        return new TreeFactoryImpl<JavaClass>();
    }

    @Override
    protected OptionSet parseOptions(String[] args) throws IOException, ClasspathException {
        int fs;
        OptionParser parser = this.getOptionParser();
        ArgumentAcceptingOptionSpec canvasWidth = parser.acceptsAll(Arrays.asList("cw", "canvas-width"), "Initial canvas width (1024 pixels).").withRequiredArg().ofType(Integer.class).describedAs("1024");
        ArgumentAcceptingOptionSpec canvasHeight = parser.acceptsAll(Arrays.asList("ch", "canvas-height"), "Initial canvas height (768 pixels).").withRequiredArg().ofType(Integer.class).describedAs("768");
        ArgumentAcceptingOptionSpec exportFilename = parser.acceptsAll(Arrays.asList("ef", "export-file"), "Save the image to file then exit.").withRequiredArg().ofType(String.class).describedAs("filename.png");
        ArgumentAcceptingOptionSpec exportScale = parser.acceptsAll(Arrays.asList("es", "export-scale"), "Scaling factor for image resolution.").withRequiredArg().ofType(Double.class).describedAs("2");
        ArgumentAcceptingOptionSpec arrowWidth = parser.acceptsAll(Arrays.asList("aw", "arrow-width"), "Initial arrow width (9 pixels).").withRequiredArg().ofType(Integer.class).describedAs("9");
        ArgumentAcceptingOptionSpec arrowHeight = parser.acceptsAll(Arrays.asList("ah", "arrow-height"), "Initial arrow height (9 pixels).").withRequiredArg().ofType(Integer.class).describedAs("9");
        ArgumentAcceptingOptionSpec fontName = parser.acceptsAll(Arrays.asList("fn", "font-name"), "Initial font name (Verdana).").withRequiredArg().ofType(String.class).describedAs("Arial, Verdana");
        ArgumentAcceptingOptionSpec fontSize = parser.acceptsAll(Arrays.asList("fs", "font-size"), "Initial font size (16 pixels).").withRequiredArg().ofType(Integer.class).describedAs("16");
        parser.acceptsAll(Arrays.asList("df", "display-fonts"), "List font names then exit.");
        parser.acceptsAll(Arrays.asList("lq", "low-quality"), "Disable anti-aliasing.");
        OptionSet options = super.parseOptions(args);
        if (options.has("display-fonts")) {
            this.displayFontNames();
        }
        if (!options.has("classes")) {
            this.showHelp();
        }
        this.setHighQuality(!options.has("low-quality"));
        int cw = options.has("canvas-width") ? (Integer)options.valueOf((OptionSpec)canvasWidth) : 1024;
        int ch = options.has("canvas-height") ? (Integer)options.valueOf((OptionSpec)canvasHeight) : 768;
        int aw = options.has("arrow-width") ? (Integer)options.valueOf((OptionSpec)arrowWidth) : 9;
        int ah = options.has("arrow-height") ? (Integer)options.valueOf((OptionSpec)arrowHeight) : 9;
        String fn = options.has("font-name") ? (String)options.valueOf((OptionSpec)fontName) : "Verdana";
        int n = fs = options.has("font-size") ? (Integer)options.valueOf((OptionSpec)fontSize) : 16;
        if (options.has("export-file")) {
            this.setExportFilename((String)options.valueOf((OptionSpec)exportFilename));
        }
        if (options.has("export-scale")) {
            this.setExportScale((Double)options.valueOf((OptionSpec)exportScale));
        }
        TreeView treeView = this.getTreeView();
        treeView.setSize(cw, ch);
        treeView.setArrowHeadSize(aw, ah);
        treeView.setFontName(fn);
        treeView.setFontSize(fs);
        treeView.registerQuitListener(this);
        return options;
    }

    private void displayFontNames() {
        for (String font : this.getTreeView().getFontNames()) {
            System.out.println(font);
        }
        this.exit();
    }

    public static void main(String[] args) throws IOException, ClasspathException, InterruptedException {
        Hierarchy hierarchy = new Hierarchy();
        Thread thread = new Thread(hierarchy);
        hierarchy.parseOptions(args);
        thread.run();
        thread.join();
    }

    protected class TreeFactoryImpl<Payload>
    extends PrefuseClassAnalyzer.PrefuseTreeFactoryImpl<Payload> {
        protected TreeFactoryImpl() {
        }

        @Override
        public Tree create(Payload payload) {
            return new TreeImpl<Payload>(payload);
        }
    }

    protected class TreeImpl<Payload>
    extends PrefuseClassAnalyzer.PrefuseTreeImpl<Payload> {
        public TreeImpl(Payload payload) {
            super(payload);
        }

        @Override
        public void walk() {
            Node branch = this.addNode((JavaClass)this.getPayload());
            for (Tree leaf : this.getChildren()) {
                this.walk(leaf, branch);
            }
        }

        protected void walk(Tree tree, Node parent) {
            TreeSet<Tree> children = new TreeSet<Tree>(tree.getChildren());
            parent = this.addEdge((JavaClass)((TreeImpl)tree).getPayload(), parent);
            if (!children.isEmpty()) {
                for (Tree child : children) {
                    this.walk(child, parent);
                }
            }
        }

        private Node addNode(JavaClass jc) {
            return Hierarchy.this.getTreeView().addNode(jc);
        }

        private Node addEdge(JavaClass jc, Node parent) {
            return Hierarchy.this.getTreeView().addEdge(jc, parent);
        }
    }
}

