/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.hierarchy.app;

import com.whitemagicsoftware.hierarchy.app.OrthogonalEdgeRenderer;
import com.whitemagicsoftware.hierarchy.app.TreeView;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.animate.LocationAnimator;
import prefuse.action.layout.CollapsedSubtreeLayout;
import prefuse.action.layout.graph.NodeLinkTreeLayout;
import prefuse.activity.Pacer;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.render.LabelRenderer;

public class OrientedTreeView
extends TreeView {
    private static final long serialVersionUID = 1988941592126611209L;
    private static final String ORIENT = "orient";

    @Override
    public void initInterface() {
        super.initInterface();
        this.registerKeyboardAction(new OrientAction(0), "left-to-right", KeyStroke.getKeyStroke("ctrl 1"), 0);
        this.registerKeyboardAction(new OrientAction(2), "top-to-bottom", KeyStroke.getKeyStroke("ctrl 2"), 0);
        this.registerKeyboardAction(new OrientAction(1), "right-to-left", KeyStroke.getKeyStroke("ctrl 3"), 0);
        this.registerKeyboardAction(new OrientAction(3), "bottom-to-top", KeyStroke.getKeyStroke("ctrl 4"), 0);
    }

    @Override
    public void display() {
        super.display();
        this.getVisualization().putAction(ORIENT, (Action)this.createOrientFilters());
    }

    private ActionList createOrientFilters() {
        ActionList orient = new ActionList(500L);
        orient.setPacingFunction((Pacer)new SlowInSlowOutPacer());
        orient.add((Action)new LocationAnimator("graph.nodes"));
        orient.add((Action)new RepaintAction());
        return orient;
    }

    @Override
    protected void setOrientation(int orientation) {
        Visualization vis = this.getVisualization();
        LabelRenderer nodeRenderer = this.getNodeRenderer();
        OrthogonalEdgeRenderer edgeRenderer = this.getEdgeRenderer();
        NodeLinkTreeLayout rtl = (NodeLinkTreeLayout)vis.getAction("layout");
        CollapsedSubtreeLayout stl = (CollapsedSubtreeLayout)vis.getAction("sublayout");
        switch (orientation) {
            case 0: {
                nodeRenderer.setHorizontalAlignment(0);
                edgeRenderer.setHorizontalAlignment1(1);
                edgeRenderer.setHorizontalAlignment2(0);
                edgeRenderer.setVerticalAlignment1(2);
                edgeRenderer.setVerticalAlignment2(2);
                break;
            }
            case 1: {
                nodeRenderer.setHorizontalAlignment(1);
                edgeRenderer.setHorizontalAlignment1(0);
                edgeRenderer.setHorizontalAlignment2(1);
                edgeRenderer.setVerticalAlignment1(2);
                edgeRenderer.setVerticalAlignment2(2);
                break;
            }
            case 2: {
                nodeRenderer.setHorizontalAlignment(2);
                edgeRenderer.setHorizontalAlignment1(2);
                edgeRenderer.setHorizontalAlignment2(2);
                edgeRenderer.setVerticalAlignment1(3);
                edgeRenderer.setVerticalAlignment2(4);
                break;
            }
            case 3: {
                nodeRenderer.setHorizontalAlignment(2);
                edgeRenderer.setHorizontalAlignment1(2);
                edgeRenderer.setHorizontalAlignment2(2);
                edgeRenderer.setVerticalAlignment1(4);
                edgeRenderer.setVerticalAlignment2(3);
            }
        }
        rtl.setOrientation(orientation);
        stl.setOrientation(orientation);
        super.setOrientation(orientation);
    }

    public class OrientAction
    extends AbstractAction {
        private static final long serialVersionUID = 2533300620911123415L;
        private int orient;

        public OrientAction(int orientation) {
            this.orient = orientation;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            OrientedTreeView.this.setOrientation(this.orient);
            OrientedTreeView.this.getVisualization().cancel(OrientedTreeView.ORIENT);
            OrientedTreeView.this.getVisualization().run("layout");
            OrientedTreeView.this.getVisualization().run(OrientedTreeView.ORIENT);
        }
    }
}

