/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.hierarchy.app;

import com.whitemagicsoftware.util.MultiValueMap;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Set;
import prefuse.Display;
import prefuse.data.Node;
import prefuse.render.EdgeRenderer;
import prefuse.util.display.PaintListener;
import prefuse.visual.EdgeItem;
import prefuse.visual.VisualItem;

public class OrthogonalEdgeRenderer
extends EdgeRenderer
implements PaintListener {
    private static final int MAX_ARROW_WIDTH = 32;
    private static final int MAX_ARROW_HEIGHT = 32;
    private static final int DEFAULT_ARROW_WIDTH = 9;
    private static final int DEFAULT_ARROW_HEIGHT = 9;
    private Path2D.Double shape = new Path2D.Double();
    private Set<Node> previousNodeSources = new HashSet<Node>(1024);
    private MultiValueMap<Integer, Line2D.Double> midPointMap = new MultiValueMap();

    public OrthogonalEdgeRenderer() {
        this.setArrowHeadSize(9, 9);
    }

    private MultiValueMap<Integer, Line2D.Double> getPointMap() {
        return this.midPointMap;
    }

    private Set<Node> getPreviousNodeSources() {
        return this.previousNodeSources;
    }

    public void setArrowHeadSize(int w, int h) {
        if (w <= 32 && h <= 32 && w > 0 && h > 0) {
            super.setArrowHeadSize(w, h);
        }
    }

    protected Shape getRawShape(VisualItem vi) {
        Path2D.Double result = this.getShape();
        boolean drawSegment = true;
        if (vi instanceof EdgeItem) {
            EdgeItem ei = (EdgeItem)vi;
            Rectangle2D source = ei.getSourceItem().getBounds();
            double sx = ei.getSourceItem().getX();
            double sy = source.getY() + source.getHeight();
            double tx = ei.getTargetItem().getX();
            double ty = ei.getTargetItem().getBounds().getY();
            int midy = (int)(sy + ty) >> 1;
            int aw = this.getArrowHeadWidth() >> 1;
            int ah = this.getArrowHeadHeight();
            result.reset();
            if (this.getPreviousNodeSources().add(ei.getSourceNode())) {
                result.moveTo(sx, sy);
                result.lineTo(sx - (double)aw, sy + (double)ah);
                result.lineTo(sx + (double)aw, sy + (double)ah);
                result.lineTo(sx, sy);
                if (sx != tx) {
                    result.moveTo(sx, sy + (double)ah);
                    result.lineTo(sx, midy);
                }
            }
            Line2D.Double segment = new Line2D.Double(sx, midy, tx, midy);
            if (this.getPointMap().put(midy, segment) != null) {
                for (Line2D.Double psegment : this.getPointMap().getValues(midy)) {
                    double psx = psegment.getX1();
                    double ptx = psegment.getX2();
                    if (sx != psx || tx == ptx) continue;
                    double pdx = psx - ptx;
                    double cdx = sx - tx;
                    if (tx < sx && ptx < sx) {
                        if (pdx > cdx) {
                            drawSegment = false;
                            continue;
                        }
                        sx = ptx;
                        continue;
                    }
                    if (!(tx > sx) || !(ptx > sx)) continue;
                    if (pdx < cdx) {
                        drawSegment = false;
                        continue;
                    }
                    sx = ptx;
                }
            }
            if (sx != tx) {
                if (drawSegment) {
                    result.moveTo(sx, midy);
                    result.lineTo(tx, midy);
                }
                result.moveTo(tx, midy);
                result.lineTo(tx, ty);
            } else {
                result.moveTo(sx, sy + (double)ah);
                result.lineTo(tx, ty);
            }
        }
        return result;
    }

    private Path2D.Double getShape() {
        return this.shape;
    }

    public void prePaint(Display d, Graphics2D g) {
        this.getPreviousNodeSources().clear();
        this.getPointMap().clear();
    }

    public void postPaint(Display d, Graphics2D g) {
    }
}

