/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.hierarchy.app;

import com.whitemagicsoftware.hierarchy.app.KeyboardZoomControl;
import com.whitemagicsoftware.hierarchy.app.OrthogonalEdgeRenderer;
import com.whitemagicsoftware.hierarchy.app.actions.AnimationListener;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.KeyStroke;
import org.apache.bcel.classfile.JavaClass;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.GroupAction;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.animate.LocationAnimator;
import prefuse.action.animate.VisibilityAnimator;
import prefuse.action.assignment.ColorAction;
import prefuse.action.assignment.FontAction;
import prefuse.action.layout.CollapsedSubtreeLayout;
import prefuse.action.layout.Layout;
import prefuse.action.layout.graph.NodeLinkTreeLayout;
import prefuse.activity.Pacer;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.Control;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.PanControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.expression.Predicate;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.util.FontLib;
import prefuse.util.GraphicsLib;
import prefuse.util.display.DisplayLib;
import prefuse.util.display.ExportDisplayAction;
import prefuse.visual.VisualItem;
import prefuse.visual.expression.InGroupPredicate;
import prefuse.visual.sort.ItemSorter;
import prefuse.visual.sort.TreeDepthItemSorter;

public class TreeView
extends Display
implements ComponentListener {
    private static final long serialVersionUID = 1422299519800234304L;
    private static final boolean GRAPH_TYPE_DIRECTED = true;
    protected static final String GRAPH = "graph";
    protected static final String NODES = "graph.nodes";
    protected static final String EDGES = "graph.edges";
    protected static final String LAYOUT = "layout";
    protected static final String SUBLAYOUT = "sublayout";
    protected static final String FILTER = "filter";
    protected static final String ANIMATE = "animate";
    protected static final String ZOOM = "zoom";
    protected static final String NODE_NAME = "label";
    protected static final String NODE_ABSTRACT = "abstract";
    protected static final String NODE_ENUM = "enum";
    protected static final String NODE_FINAL = "final";
    protected static final String NODE_PRIVATE = "private";
    protected static final String NODE_PROTECTED = "protected";
    protected static final String NODE_PUBLIC = "public";
    protected static final int ANIMATION_SPEED = 500;
    protected static final int AUTO_ZOOM_DELAY = 100;
    private static final String ACTION_QUIT = "action.quit";
    private static final String ACTION_SAVE = "action.save";
    private Graph graph;
    private LabelRenderer shapeRenderer;
    private OrthogonalEdgeRenderer edgeRenderer;
    private RendererFactory rendererFactory;
    private int orientation = 2;
    private Timer zoomTimer = new Timer();
    private Timer animateTimer = new Timer();
    private AnimateAfterAction animateAfterAction = new AnimateAfterAction();
    private List<AnimationListener> animationListeners = new ArrayList<AnimationListener>();
    private boolean prepareZoom = false;
    private String fontName = "Verdana";
    private int fontSize = 16;
    private static final String ANIMATE_AFTER = "animate.after";

    public TreeView() {
        this(true);
    }

    public TreeView(boolean highQuality) {
        super(new Visualization());
        this.setHighQuality(highQuality);
        this.addPaintListener(this.getEdgeRenderer());
    }

    public void display() {
        this.initInterface();
        Visualization visualization = this.getVisualization();
        visualization.add(GRAPH, (TupleSet)this.getGraph());
        visualization.setRendererFactory(this.getRendererFactory());
        visualization.putAction(FILTER, (Action)this.createGraphFilters());
        visualization.putAction(LAYOUT, (Action)this.createGraphLayout());
        visualization.putAction(SUBLAYOUT, (Action)this.createGraphSubLayout());
        visualization.putAction(ZOOM, (Action)this.createZoomToFitAction());
        visualization.putAction(ANIMATE, (Action)this.createAnimationFilters());
        visualization.putAction(ANIMATE_AFTER, this.getAnimateAfterAction());
        visualization.alwaysRunAfter(FILTER, ANIMATE);
        visualization.alwaysRunAfter(ZOOM, ANIMATE_AFTER);
        visualization.setInteractive(NODES, null, false);
        visualization.run(FILTER);
        visualization.run(LAYOUT);
        this.addComponentListener(this);
    }

    private Action getAnimateAfterAction() {
        return this.animateAfterAction;
    }

    private void setPrepareZoom(boolean prepareZoom) {
        this.prepareZoom = prepareZoom;
    }

    private boolean isPrepareZoom() {
        return this.prepareZoom;
    }

    private List<AnimationListener> getAnimationListeners() {
        return this.animationListeners;
    }

    public void addAnimationListener(AnimationListener listener) {
        this.getAnimationListeners().add(listener);
    }

    public void removeAnimationListener(AnimationListener listener) {
        this.getAnimationListeners().remove(listener);
    }

    protected void registerDefaultCommands() {
        this.registerKeyboardAction((ActionListener)this.getExportDisplayAction(), ACTION_SAVE, KeyStroke.getKeyStroke("ctrl S"), 0);
    }

    protected void registerQuitListener(ActionListener listener) {
        this.registerKeyboardAction(listener, ACTION_QUIT, KeyStroke.getKeyStroke("ctrl Q"), 0);
    }

    private ExportDisplayAction getExportDisplayAction() {
        return new ExportDisplayAction((Display)this);
    }

    protected void zoomToFit() {
        this.getVisualization().run(ZOOM);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.rescheduleZoom();
    }

    private void rescheduleZoom() {
        this.setPrepareZoom(true);
        this.zoomTimer.cancel();
        this.zoomTimer = new Timer();
        this.zoomTimer.schedule((TimerTask)new ResizeTask(), 100L);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public void initInterface() {
        this.setItemSorter((ItemSorter)new TreeDepthItemSorter());
        this.addControlListener((Control)new DragControl());
        this.addControlListener((Control)new PanControl());
        this.addControlListener((Control)new ZoomToFitControl());
        this.addControlListener((Control)new ZoomControl());
        this.addControlListener((Control)new KeyboardZoomControl());
        this.addControlListener((Control)new FocusControl(1, FILTER));
    }

    private Layout createGraphLayout() {
        return new NodeLinkTreeLayout(GRAPH, this.getOrientation(), 50.0, 50.0, 30.0);
    }

    private Layout createGraphSubLayout() {
        return new CollapsedSubtreeLayout(GRAPH, this.getOrientation());
    }

    private ActionList createGraphFilters() {
        ColorAction text = new ColorAction(NODES, VisualItem.TEXTCOLOR);
        text.setDefaultColor(ColorLib.rgb((int)0, (int)0, (int)128));
        ColorAction outline = new ColorAction(NODES, VisualItem.STROKECOLOR);
        outline.setDefaultColor(ColorLib.rgb((int)102, (int)127, (int)178));
        ColorAction edges = new ColorAction(EDGES, VisualItem.STROKECOLOR);
        edges.setDefaultColor(ColorLib.rgb((int)102, (int)127, (int)178));
        ColorAction arrows = new ColorAction(EDGES, VisualItem.FILLCOLOR);
        arrows.setDefaultColor(ColorLib.rgb((int)102, (int)127, (int)178));
        FontAction font = new FontAction(NODES, this.getFont());
        ActionList filter = new ActionList();
        filter.add((Action)text);
        filter.add((Action)outline);
        filter.add((Action)edges);
        filter.add((Action)arrows);
        filter.add((Action)font);
        return filter;
    }

    private ActionList createAnimationFilters() {
        ActionList animate = new ActionList(500L);
        animate.setPacingFunction((Pacer)new SlowInSlowOutPacer());
        animate.add((Action)new VisibilityAnimator(GRAPH));
        animate.add((Action)new LocationAnimator(NODES));
        animate.add((Action)new ColorAnimator(NODES));
        animate.add((Action)new RepaintAction());
        return animate;
    }

    private ZoomToFitAction createZoomToFitAction() {
        return new ZoomToFitAction(GRAPH);
    }

    public Font getFont() {
        return FontLib.getFont((String)this.getFontName(), (double)this.getFontSize());
    }

    private boolean isValidFont(String fontName) {
        return fontName == null ? false : this.getAllFontNames().contains(fontName.toLowerCase());
    }

    private List<String> getAllFontNames() {
        String[] fontNames = this.getFontNames();
        for (int i = fontNames.length - 1; i >= 0; --i) {
            fontNames[i] = fontNames[i].toLowerCase();
        }
        return Arrays.asList(fontNames);
    }

    protected String[] getFontNames() {
        return this.getGraphicsEnvironment().getAvailableFontFamilyNames();
    }

    private GraphicsEnvironment getGraphicsEnvironment() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment();
    }

    protected String getFontName() {
        return this.fontName;
    }

    protected void setFontName(String fontName) {
        if (this.isValidFont(fontName)) {
            this.fontName = fontName;
        }
    }

    protected int getFontSize() {
        return this.fontSize;
    }

    protected void setFontSize(int fontSize) {
        if (fontSize > 0) {
            this.fontSize = fontSize;
        }
    }

    public Node addNode(JavaClass jc) {
        Node node = this.getGraph().addNode();
        node.setString(NODE_NAME, jc.getClassName());
        node.setBoolean(NODE_ABSTRACT, jc.isAbstract());
        node.setBoolean(NODE_ENUM, jc.isEnum());
        node.setBoolean(NODE_FINAL, jc.isFinal());
        node.setBoolean(NODE_PRIVATE, jc.isPrivate());
        node.setBoolean(NODE_PROTECTED, jc.isProtected());
        node.setBoolean(NODE_PUBLIC, jc.isPublic());
        return node;
    }

    public Node addEdge(JavaClass jc, Node parent) {
        Node child = this.addNode(jc);
        this.getGraph().addEdge(parent, child);
        return child;
    }

    private RendererFactory getRendererFactory() {
        if (this.rendererFactory == null) {
            this.rendererFactory = this.createRendererFactory();
        }
        return this.rendererFactory;
    }

    private Graph createGraph() {
        Graph graph = new Graph(true);
        graph.addColumn(NODE_NAME, String.class);
        graph.addColumn(NODE_ABSTRACT, Boolean.TYPE);
        graph.addColumn(NODE_ENUM, Boolean.TYPE);
        graph.addColumn(NODE_FINAL, Boolean.TYPE);
        graph.addColumn(NODE_PRIVATE, Boolean.TYPE);
        graph.addColumn(NODE_PROTECTED, Boolean.TYPE);
        graph.addColumn(NODE_PUBLIC, Boolean.TYPE);
        return graph;
    }

    protected Graph getGraph() {
        if (this.graph == null) {
            this.graph = this.createGraph();
        }
        return this.graph;
    }

    protected LabelRenderer getNodeRenderer() {
        if (this.shapeRenderer == null) {
            this.shapeRenderer = this.createNodeRenderer();
        }
        return this.shapeRenderer;
    }

    private LabelRenderer createNodeRenderer() {
        LabelRenderer renderer = new LabelRenderer(NODE_NAME);
        renderer.setRenderType(1);
        renderer.setHorizontalPadding(50);
        renderer.setVerticalPadding(10);
        renderer.setRoundedCorner(10, 10);
        return renderer;
    }

    private RendererFactory createRendererFactory() {
        DefaultRendererFactory rf = new DefaultRendererFactory((Renderer)this.getNodeRenderer());
        rf.add((Predicate)new InGroupPredicate(EDGES), (Renderer)this.getEdgeRenderer());
        return rf;
    }

    protected OrthogonalEdgeRenderer getEdgeRenderer() {
        if (this.edgeRenderer == null) {
            this.edgeRenderer = this.createEdgeRenderer();
        }
        return this.edgeRenderer;
    }

    private OrthogonalEdgeRenderer createEdgeRenderer() {
        return new OrthogonalEdgeRenderer();
    }

    protected int getOrientation() {
        return this.orientation;
    }

    protected void setArrowHeadSize(int width, int height) {
        this.getEdgeRenderer().setArrowHeadSize(width, height);
    }

    protected void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    private class ResizeTask
    extends TimerTask {
        private ResizeTask() {
        }

        @Override
        public void run() {
            TreeView.this.zoomToFit();
        }
    }

    private class ZoomToFitAction
    extends GroupAction {
        protected ZoomToFitAction(String id) {
            super(id);
        }

        public void run(double frac) {
            TreeView display = TreeView.this;
            if (!TreeView.this.isTranformInProgress()) {
                Rectangle2D bounds = this.getVisualization().getBounds(TreeView.GRAPH);
                GraphicsLib.expand((Rectangle2D)bounds, (double)(50 + (int)(1.0 / TreeView.this.getScale())));
                DisplayLib.fitViewToBounds((Display)display, (Rectangle2D)bounds, (long)1000L);
            } else {
                TreeView.this.rescheduleZoom();
            }
        }
    }

    private class AnimateAfterAction
    extends Action {
        private AnimateAfterAction() {
        }

        public void run(double frac) {
            if (TreeView.this.isTranformInProgress() || TreeView.this.isPrepareZoom()) {
                TreeView.this.animateTimer.cancel();
                TreeView.this.animateTimer = new Timer();
                TreeView.this.animateTimer.schedule((TimerTask)new AnimateTask(), 250L);
                TreeView.this.setPrepareZoom(false);
            } else {
                for (AnimationListener listener : TreeView.this.getAnimationListeners()) {
                    listener.animationFinished(TreeView.this);
                }
            }
        }

        private class AnimateTask
        extends TimerTask {
            private AnimateTask() {
            }

            @Override
            public void run() {
                TreeView.this.getAnimateAfterAction().run(0.0);
            }
        }
    }
}

