/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class MultiValueMap<K, V>
extends AbstractMap<K, V> {
    private Map<K, Collection<V>> map;
    private int size;

    @Override
    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    public boolean containsKeyValue(K key, V value) {
        Collection<V> set = this.getValues(key);
        return set == null ? false : set.contains(value);
    }

    @Override
    public boolean containsValue(Object value) {
        for (K key : this.keySet()) {
            if (!this.getValues(key).contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        return this.getMap().keySet();
    }

    @Override
    public V put(K key, V value) {
        Collection<V> values = this.getValues(key);
        V result = null;
        if (values.add(value)) {
            result = value;
            this.increaseSize();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<V> removeMapping(K key) {
        Collection<V> values;
        MultiValueMap multiValueMap = this;
        synchronized (multiValueMap) {
            values = this.getMap().remove(key);
            if (values != null) {
                this.decreaseSize(values.size());
            }
        }
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMapping(K key, V value) {
        Map<K, Collection<Collection<V>>> map;
        boolean removed = false;
        Map<K, Collection<Collection<V>>> map2 = map = this.getMap();
        synchronized (map2) {
            Collection<V> values = map.get(key);
            if (values != null) {
                MultiValueMap multiValueMap = this;
                synchronized (multiValueMap) {
                    removed = values.remove(value);
                    this.decreaseSize(1);
                }
                if (values.isEmpty()) {
                    map.remove(key);
                }
            }
        }
        return removed;
    }

    @Override
    public V get(Object key) {
        Collection<V> values = this.getMap().get(key);
        Iterator<V> i = values.iterator();
        return i.hasNext() ? (V)i.next() : null;
    }

    public Collection<V> getValues(K key) {
        Collection<V> values = this.getMap().get(key);
        if (values == null) {
            values = this.createSet();
            this.getMap().put(key, values);
        }
        return values;
    }

    private Map<K, Collection<V>> getMap() {
        if (this.map == null) {
            this.map = this.createMap();
        }
        return this.map;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    protected Collection<V> createSet() {
        return new HashSet(1024);
    }

    protected Map<K, Collection<V>> createMap() {
        return new HashMap(1024);
    }

    @Override
    public int size() {
        return this.size;
    }

    private void increaseSize() {
        this.setSize(this.size() + 1);
    }

    private void decreaseSize(int by) {
        this.setSize(this.size() - by);
    }

    private void setSize(int size) {
        this.size = size;
        if (this.size < 0) {
            this.size = 0;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
    }

    @Override
    public void clear() {
        this.getMap().clear();
    }

    @Override
    public Collection<V> values() {
        Collection<V> result = this.createSet();
        for (K key : this.keySet()) {
            result.addAll(this.getValues(key));
        }
        return result;
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        protected EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return MultiValueMap.this.size();
        }

        private class EntrySetIterator
        implements Iterator<Map.Entry<K, V>> {
            private Iterator<K> keys;
            private Iterator<V> values;
            private Map.Entry<K, V> current;

            public EntrySetIterator() {
                this.keys = MultiValueMap.this.keySet().iterator();
            }

            @Override
            public boolean hasNext() {
                boolean next;
                Iterator values = this.getValues();
                boolean bl = next = values != null && values.hasNext();
                if (!next) {
                    next = this.getKeys().hasNext();
                }
                return next;
            }

            private Iterator<K> getKeys() {
                return this.keys;
            }

            private Iterator<V> getValues() {
                return this.values;
            }

            private void setValues(Iterator<V> values) {
                this.values = values;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Entry result = null;
                Iterator values = this.getValues();
                if (values == null || !values.hasNext()) {
                    Object key = this.getKeys().next();
                    this.setValues(MultiValueMap.this.getValues(key).iterator());
                    Object value = this.getValues().next();
                    result = new Entry(key, value);
                    this.setCurrent(result);
                }
                return result;
            }

            @Override
            public void remove() {
                if (this.getCurrent() == null) {
                    throw new IllegalStateException();
                }
                MultiValueMap.this.remove(this.getCurrent().getKey(), this.getCurrent().getValue());
            }

            private void setCurrent(Map.Entry<K, V> current) {
                this.current = current;
            }

            private Map.Entry<K, V> getCurrent() {
                return this.current;
            }
        }
    }

    private class Entry
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public Entry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Map.Entry<K, V> thatObject) {
            try {
                Map.Entry that = thatObject;
                return this.getKey().equals(that.getKey()) && this.getValue().equals(that.getValue());
            }
            catch (ClassCastException ex) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            return this.getKey().hashCode() ^ this.getValue().hashCode();
        }
    }
}

