/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.util;

import com.whitemagicsoftware.util.DefaultTreeFactoryImpl;
import com.whitemagicsoftware.util.MultiValueMap;
import com.whitemagicsoftware.util.Tree;
import com.whitemagicsoftware.util.TreeFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class MultiValueMapTransformer<K> {
    private MultiValueMap<K, K> multiValueMap;
    private TreeFactory<K> treeFactory;

    public MultiValueMapTransformer(MultiValueMap<K, K> mvm) {
        this(mvm, new DefaultTreeFactoryImpl());
    }

    public MultiValueMapTransformer(MultiValueMap<K, K> mvm, TreeFactory<K> treeFactory) {
        this.setMultiValueMap(mvm);
        this.setTreeFactory(treeFactory);
    }

    public Set<Tree> transform() {
        MultiValueMap<K, K> input = this.getMultiValueMap();
        Set<K> keys = input.keySet();
        HashSet<K> roots = new HashSet<K>(keys);
        HashMap<K, Tree> map = new HashMap<K, Tree>();
        for (K key : keys) {
            Tree tree = (Tree)map.get(key);
            if (tree == null) {
                tree = this.createTree(key);
                map.put(key, tree);
            }
            for (K childKey : input.getValues(key)) {
                roots.remove(childKey);
                Tree child = (Tree)map.get(childKey);
                if (child == null) {
                    child = this.createTree(childKey);
                    map.put(childKey, child);
                }
                tree.add(child);
            }
        }
        HashSet<Tree> result = new HashSet<Tree>(roots.size());
        for (Object key : roots) {
            result.add((Tree)map.get(key));
        }
        return result;
    }

    public void setMultiValueMap(MultiValueMap<K, K> multiValueMap) {
        this.multiValueMap = multiValueMap;
    }

    private MultiValueMap<K, K> getMultiValueMap() {
        return this.multiValueMap;
    }

    protected Tree createTree(K payload) {
        return this.getTreeFactory().create(payload);
    }

    private void setTreeFactory(TreeFactory<K> treeFactory) {
        this.treeFactory = treeFactory;
    }

    private TreeFactory<K> getTreeFactory() {
        return this.treeFactory;
    }
}

