/*
 * Decompiled with CFR 0.152.
 */
package com.joot.awt.util;

import com.joot.awt.widgets.EscapableDialog;
import java.awt.AWTEvent;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;

public class AlertBox
extends EscapableDialog {
    private Button okButton;
    private String message = "";

    public AlertBox(Frame frame, String string, String string2) {
        super(frame, string, true);
        this.setPosition(frame);
        this.setMessage(string2);
        this.init();
    }

    private void init() {
        String string = this.getMessage();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        Panel panel = new Panel();
        Panel panel2 = new Panel(new GridLayout(stringTokenizer.countTokens(), 1));
        panel.setLayout(new FlowLayout(1));
        panel.add(this.getOKButton());
        while (stringTokenizer.hasMoreTokens()) {
            panel2.add(new Label(stringTokenizer.nextToken()));
        }
        this.add("Center", panel2);
        this.add("South", panel);
        this.enableEvents(201L);
        this.setResizable(false);
        this.setModal(true);
        this.pack();
    }

    protected void setPosition(Frame frame) {
        Point point = frame.getLocation();
        Dimension dimension = frame.getSize();
        this.setLocation(point.x + dimension.width / 2, point.y + dimension.height / 2);
    }

    @Override
    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent.getID() == 201) {
            this.close();
        }
    }

    protected void close() {
        this.setVisible(false);
        this.dispose();
    }

    protected String getOKButtonText() {
        return "OK";
    }

    protected Button createOKButton() {
        Button button = new Button(this.getOKButtonText());
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AlertBox.this.close();
            }
        });
        return button;
    }

    private void setMessage(String string) {
        this.message = string;
    }

    private String getMessage() {
        return this.message == null ? "" : this.message;
    }

    private Button getOKButton() {
        if (this.okButton == null) {
            this.okButton = this.createOKButton();
        }
        return this.okButton;
    }
}

