/*
 * Decompiled with CFR 0.152.
 */
package com.joot.awt.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class EscapableDialog
extends Dialog
implements ContainerListener,
KeyListener {
    private static final boolean ADD = true;
    private static final boolean REMOVE = false;

    public EscapableDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.addContainerListeners(this);
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.addContainerListeners(containerEvent.getChild());
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        this.removeContainerListeners(containerEvent.getChild());
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 27: {
                this.performCancelAction();
                break;
            }
            case 10: {
                this.performAcceptAction();
            }
        }
    }

    public void performCancelAction() {
        this.performDefaultAction();
    }

    public void performAcceptAction() {
        this.performDefaultAction();
    }

    protected void performDefaultAction() {
        this.setVisible(false);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    private void addContainerListeners(Component component) {
        this.updateContainerListeners(component, true);
    }

    private void removeContainerListeners(Component component) {
        this.updateContainerListeners(component, false);
    }

    private void updateContainerListeners(Component component, boolean bl) {
        component.removeKeyListener(this);
        if (bl) {
            component.addKeyListener(this);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            if (bl) {
                container.addContainerListener(this);
            }
            Component[] componentArray = container.getComponents();
            for (int i = componentArray.length - 1; i >= 0; --i) {
                this.updateContainerListeners(componentArray[i], bl);
            }
        }
    }
}

