/*
 * Decompiled with CFR 0.152.
 */
package com.joot.jigo;

import com.joot.jigo.Markup;
import com.joot.jigo.Point;
import com.joot.jigo.Stone;
import com.joot.jigo.WhiteStone;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.Observable;
import java.util.Observer;

public class Goban
extends Panel {
    public static final int DEFAULT_SIZE = 19;
    public static final int DEFAULT_HOSHI_PIXELS = 6;
    private static final int INVALID = -1;
    private static final Color DEFAULT_FGCOLOUR = Color.black;
    private static final Color DEFAULT_BGCOLOUR = Color.lightGray;
    private static final Color DEFAULT_HLCOLOUR = new Color(153, 204, 255);
    private Stone[][] stones;
    private Markup[][] myMarks;
    private Color myFGColour = DEFAULT_FGCOLOUR;
    private Color myBGColour = DEFAULT_BGCOLOUR;
    private Color myHLColour = DEFAULT_HLCOLOUR;
    private Image myBGImage;
    private int myBoardSize = 19;
    private boolean drawBG;
    private boolean drawMarkup = true;
    private boolean drawHoshi = true;
    private boolean drawHighlight = true;
    private Stone mySizingStone;
    private Point myHighlight = new Point(-1, -1);
    private GobanObserver myObserver = new GobanObserver();
    private Image myOffscreenImage;
    private Image myBasicBoard;
    private boolean forceRepaint = true;
    private int myHoshiPixelSize = 6;

    public Goban() {
        this(new WhiteStone());
    }

    public Goban(Color color) {
        this(19, color, (Stone)new WhiteStone());
    }

    public Goban(Stone stone) {
        this(19, stone);
    }

    public Goban(Color color, Stone stone) {
        this(19, color, stone);
    }

    public Goban(int n, Stone stone) {
        this(n, DEFAULT_BGCOLOUR, stone);
    }

    public Goban(int n, Color color, Stone stone) {
        this(n, color, null, stone);
    }

    public Goban(int n, Image image, Stone stone) {
        this(n, DEFAULT_BGCOLOUR, image, stone);
    }

    public Goban(int n, Color color, Image image, Stone stone) {
        this.setSizingStone(stone);
        this.setBGColour(color);
        this.setBGImage(image);
        this.setBoardSize(n);
        this.initializeBoard();
        this.calculateSize();
    }

    public Goban(Image image, Stone stone) {
        this(19, DEFAULT_BGCOLOUR, image, stone);
    }

    private void calculateSize() {
        int n = this.getSizingStone().getWidth() * this.getBoardSize() + 1;
        int n2 = this.getSizingStone().getHeight() * this.getBoardSize() + 1;
        if (this.getWidth() != n || this.getHeight() != n2) {
            this.setBounds(0, 0, n, n2);
            this.setSize(new Dimension(n, n2));
            this.setLocation(0, 0);
            this.setOffscreenImage(null);
        }
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.getSize().width, this.getSize().height);
    }

    @Override
    public java.awt.Point getLocation() {
        return new java.awt.Point(0, 0);
    }

    public void initializeBoard() {
        int n = this.getBoardSize();
        this.stones = new Stone[n][n];
        this.myMarks = new Markup[n][n];
        if (this.shouldForceRepaint()) {
            this.forceRepaint();
        }
    }

    @Override
    public void update(Graphics graphics) {
        if (this.getOffscreenImage() == null) {
            this.setOffscreenImage(this.createImage(this.getWidth(), this.getHeight()));
            this.redraw();
        }
        graphics.drawImage(this.getOffscreenImage(), 0, 0, null);
    }

    @Override
    public void paint(Graphics graphics) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.update(graphics);
    }

    public void forceRepaint() {
        this.getGobanObserver().setChanged();
        this.redraw();
    }

    private void redraw() {
        Image image = this.getOffscreenImage();
        if (image == null) {
            return;
        }
        Graphics graphics = image.getGraphics();
        Image image2 = this.getBasicBoard();
        if (this.getGobanObserver().hasChanged()) {
            Graphics graphics2 = image2.getGraphics();
            if (this.shouldDrawBG()) {
                this.drawBG(graphics2);
            } else {
                graphics2.setColor(this.getBGColour());
                graphics2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            this.drawLines(graphics2);
            if (this.shouldDrawHoshi()) {
                this.drawHoshi(graphics2);
            }
            this.drawStones(graphics2);
            if (this.shouldDrawMarkup()) {
                this.drawMarkup(graphics2);
            }
            this.getGobanObserver().clearChanged();
        }
        graphics.drawImage(image2, 0, 0, null);
        if (this.shouldDrawHighlight()) {
            this.drawHighlight(graphics);
        }
        this.repaint();
    }

    private void drawBG(Graphics graphics) {
        Image image = this.getBGImage();
        if (image == null) {
            return;
        }
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        for (int i = n3 / n; i >= 0; --i) {
            for (int j = n4 / n2; j >= 0; --j) {
                graphics.drawImage(image, i * n, j * n2, null);
            }
        }
    }

    private void drawLines(Graphics graphics) {
        int n = this.getSizingStone().getWidth();
        int n2 = this.getSizingStone().getHeight();
        int n3 = n >> 1;
        int n4 = n2 >> 1;
        int n5 = n3;
        int n6 = n4;
        int n7 = this.getBoardSize() * n - n3 - 1;
        int n8 = this.getBoardSize() * n2 - n4 - 1;
        graphics.setColor(this.getFGColour());
        for (int i = this.getBoardSize() - 1; i >= 0; --i) {
            graphics.drawLine(n3, n6, n7, n6);
            graphics.drawLine(n5, n4, n5, n8);
            n5 += n;
            n6 += n2;
        }
    }

    private void drawStones(Graphics graphics) {
        int n = this.getBoardSize() - 1;
        int n2 = this.getSizingStone().getWidth();
        int n3 = this.getSizingStone().getHeight();
        Stone[][] stoneArray = this.getStones();
        for (int i = n; i >= 0; --i) {
            int n4 = i * n2;
            for (int j = n; j >= 0; --j) {
                Stone stone = stoneArray[i][j];
                if (stone == null) continue;
                stone.draw(graphics, n4, j * n3);
            }
        }
    }

    private Stone[][] getStones() {
        return this.stones;
    }

    private void drawHoshi(Graphics graphics) {
        int n = this.getBoardSize();
        int n2 = this.getHoshiPixelSize();
        int n3 = this.getSizingStone().getWidth();
        int n4 = this.getSizingStone().getHeight();
        int n5 = (n3 >> 1) - (n2 >> 1);
        int n6 = (n4 >> 1) - (n2 >> 1);
        if (n < 9) {
            return;
        }
        int n7 = 3;
        int n8 = 9;
        int n9 = 15;
        if (n < 13) {
            n7 = 2;
            n8 = 4;
            n9 = 6;
        } else if (n < 19) {
            n7 = 3;
            n8 = 6;
            n9 = 9;
        }
        int n10 = n7 * n3 + n5;
        int n11 = n8 * n3 + n5;
        int n12 = n9 * n3 + n5;
        int n13 = n7 * n4 + n6;
        int n14 = n8 * n4 + n6;
        int n15 = n9 * n4 + n6;
        graphics.setColor(this.getFGColour());
        graphics.fillOval(n10, n13, n2, n2);
        graphics.fillOval(n10, n14, n2, n2);
        graphics.fillOval(n10, n15, n2, n2);
        graphics.fillOval(n11, n13, n2, n2);
        graphics.fillOval(n11, n14, n2, n2);
        graphics.fillOval(n11, n15, n2, n2);
        graphics.fillOval(n12, n13, n2, n2);
        graphics.fillOval(n12, n14, n2, n2);
        graphics.fillOval(n12, n15, n2, n2);
    }

    private int getHoshiPixelSize() {
        return this.myHoshiPixelSize;
    }

    public void setHoshiPixelSize(int n) {
        this.myHoshiPixelSize = n;
    }

    private void drawMarkup(Graphics graphics) {
        int n = this.getBoardSize() - 1;
        int n2 = this.getSizingStone().getWidth();
        int n3 = this.getSizingStone().getHeight();
        for (int i = n; i >= 0; --i) {
            int n4 = i * n2;
            for (int j = n; j >= 0; --j) {
                Markup markup = this.myMarks[i][j];
                if (markup == null) continue;
                int n5 = j * n3 - 1;
                Stone stone = this.getStone(i, j);
                if (stone == null) {
                    graphics.setClip(n4, n5 + 1, n2, n3);
                    this.drawBG(graphics);
                    graphics.setClip(0, 0, this.getWidth(), this.getHeight());
                    markup.emptyIntersection();
                }
                if (stone != null) {
                    markup.stone(stone.isWhite());
                }
                markup.draw(graphics, n4, n5, n2, n3);
            }
        }
    }

    protected void drawHighlight(Graphics graphics) {
        Point point = this.getHighlight();
        if (this.isValid(point)) {
            int n = this.getSizingStone().getWidth();
            int n2 = this.getSizingStone().getHeight();
            int n3 = n * point.x;
            int n4 = n2 * point.y;
            int n5 = n >> 1;
            int n6 = n2 >> 1;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = this.getBoardSize() - 1;
            graphics.setColor(this.getHighlightColour());
            graphics.fillRect(n3, n4, n, n2);
            if (point.x == 0) {
                n7 = n5;
            } else if (point.x == n11) {
                n8 = n5;
            }
            if (point.y == 0) {
                n9 = n6;
            } else if (point.y == n11) {
                n10 = n6;
            }
            graphics.setColor(this.getFGColour());
            graphics.drawLine(n3 + n7, n4 + n6, n3 + n - n8, n4 + n6);
            graphics.drawLine(n3 + n5, n4 + n9, n3 + n5, n4 + n2 - n10);
        }
    }

    private Color getHighlightColour() {
        return this.myHLColour;
    }

    public void placeStone(Stone stone, Point point) {
        Stone[][] stoneArray = this.getStones();
        stoneArray[point.x][point.y] = stone;
        if (stone != null) {
            this.getGobanObserver().notifyObservers(point);
        }
        if (this.shouldForceRepaint()) {
            this.forceRepaint();
        }
    }

    public boolean shouldForceRepaint() {
        return this.forceRepaint;
    }

    public void setForceRepaint(boolean bl) {
        this.forceRepaint = bl;
    }

    public void removeStone(Point point) {
        this.placeStone(null, point);
    }

    public void removeAllStones() {
        int n = this.getBoardSize();
        Stone[][] stoneArray = this.getStones();
        for (int i = n - 1; i >= 0; --i) {
            for (int j = n - 1; j >= 0; --j) {
                stoneArray[i][j] = null;
            }
        }
        if (this.shouldForceRepaint()) {
            this.forceRepaint();
        }
    }

    protected boolean hasStone(int n, int n2) {
        return this.stones[n][n2] != null;
    }

    public boolean hasStone(Point point) {
        return this.stones[point.x][point.y] != null;
    }

    protected boolean hasWhiteStone(int n, int n2) {
        Stone stone = this.stones[n][n2];
        return stone == null ? false : stone.isWhite();
    }

    public boolean hasWhiteStone(Point point) {
        return this.hasWhiteStone(point.x, point.y);
    }

    protected boolean hasBlackStone(int n, int n2) {
        Stone stone = this.stones[n][n2];
        return stone == null ? false : !stone.isWhite();
    }

    public boolean hasBlackStone(Point point) {
        return this.hasBlackStone(point.x, point.y);
    }

    public void placeMark(Markup markup, int n, int n2) {
        this.myMarks[n][n2] = markup;
        if (this.shouldForceRepaint()) {
            this.forceRepaint();
        }
    }

    public void placeMark(Markup markup, Point point) {
        this.placeMark(markup, point.x, point.y);
    }

    public void removeMark(Point point) {
        this.placeMark(null, point);
    }

    public void removeAllMarks() {
        int n = this.getBoardSize();
        for (int i = n - 1; i >= 0; --i) {
            for (int j = n - 1; j >= 0; --j) {
                this.myMarks[i][j] = null;
            }
        }
        if (this.shouldForceRepaint()) {
            this.forceRepaint();
        }
    }

    public synchronized void addObserver(Observer observer) {
        this.getGobanObserver().addObserver(observer);
    }

    public boolean isValid(int n, int n2) {
        return n >= 0 && n < this.getBoardSize() && n2 >= 0 && n2 < this.getBoardSize();
    }

    public boolean isValid(Point point) {
        return this.isValid(point.x, point.y);
    }

    protected Stone getStone(int n, int n2) {
        return this.stones[n][n2];
    }

    protected Stone getStone(Point point) {
        return this.getStone(point.x, point.y);
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.calculateSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getWidth() {
        return this.getBounds().width;
    }

    @Override
    public int getHeight() {
        return this.getBounds().height;
    }

    private void setBoardSize(int n) {
        this.myBoardSize = n;
    }

    public int getBoardSize() {
        return this.myBoardSize;
    }

    private Image getBGImage() {
        return this.myBGImage;
    }

    public void setBGImage(Image image) {
        this.setDrawBG(image != null);
        this.myBGImage = image;
    }

    public boolean translateCoord(int n, int n2, Point point) {
        if (n < 0 || n >= this.getWidth() - 1 || n2 < 0 || n2 >= this.getHeight() - 1) {
            return false;
        }
        point.x = n / this.getSizingStone().getWidth();
        point.y = n2 / this.getSizingStone().getHeight();
        return true;
    }

    private void setOffscreenImage(Image image) {
        this.myOffscreenImage = image;
    }

    private Image getOffscreenImage() {
        return this.myOffscreenImage;
    }

    public Stone getSizingStone() {
        return this.mySizingStone;
    }

    private void setSizingStone(Stone stone) {
        this.mySizingStone = stone;
    }

    public void setFGColour(Color color) {
        this.myFGColour = color;
        this.forceRepaint();
    }

    private Color getFGColour() {
        return this.myFGColour;
    }

    public void setBGColour(Color color) {
        this.myBGColour = color;
        this.forceRepaint();
    }

    private Color getBGColour() {
        return this.myBGColour;
    }

    protected Point getHighlight() {
        return this.myHighlight;
    }

    public boolean isHighlighted(Point point) {
        return this.getHighlight().equals(point);
    }

    public boolean isHighlighted() {
        return this.myHighlight.x != -1 && this.shouldDrawHighlight();
    }

    public void setHighlight(int n, int n2) {
        if (this.isValid(n, n2)) {
            this.myHighlight.x = n;
            this.myHighlight.y = n2;
        } else {
            this.myHighlight.x = -1;
        }
        this.redraw();
    }

    public void setHighlight(Point point) {
        this.setHighlight(point.x, point.y);
    }

    public void clearHighlight() {
        this.setHighlight(-1, -1);
    }

    public boolean shouldDrawBG() {
        return this.drawBG;
    }

    private void setDrawBG(boolean bl) {
        this.drawBG = bl;
        this.forceRepaint();
    }

    public boolean shouldDrawHoshi() {
        return this.drawHoshi;
    }

    public void toggleHoshi() {
        this.setDrawHoshi(!this.shouldDrawHoshi());
    }

    private void setDrawHoshi(boolean bl) {
        this.drawHoshi = bl;
        this.forceRepaint();
    }

    public boolean shouldDrawMarkup() {
        return this.drawMarkup;
    }

    public void toggleMarkup() {
        this.setDrawMarkup(!this.drawMarkup);
    }

    private void setDrawMarkup(boolean bl) {
        this.drawMarkup = bl;
        this.forceRepaint();
    }

    private final Image getBasicBoard() {
        if (this.myBasicBoard == null) {
            this.myBasicBoard = this.createImage(this.getWidth(), this.getHeight());
        }
        return this.myBasicBoard;
    }

    public boolean shouldDrawHighlight() {
        return this.drawHighlight;
    }

    public void toggleHighlight() {
        this.setDrawHighlight(!this.shouldDrawHighlight());
    }

    private void setDrawHighlight(boolean bl) {
        this.drawHighlight = bl;
        this.forceRepaint();
    }

    public void copyGraphics(Graphics graphics) {
        graphics.drawImage(this.getOffscreenImage(), 0, 0, null);
    }

    private GobanObserver getGobanObserver() {
        return this.myObserver;
    }

    public class GobanObserver
    extends Observable {
        protected GobanObserver() {
            this.setChanged();
        }

        @Override
        public void addObserver(Observer observer) {
            this.deleteObserver(observer);
            super.addObserver(observer);
        }

        @Override
        protected void setChanged() {
            super.setChanged();
        }

        @Override
        protected void clearChanged() {
            super.clearChanged();
        }

        protected void notifyObservers(Point point) {
            this.setChanged();
            super.notifyObservers(point);
        }
    }
}

