/*
 * Decompiled with CFR 0.152.
 */
package com.joot.jigo;

import com.joot.jigo.Goban;
import com.joot.jigo.Point;
import com.joot.jigo.Rules;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;

public class GobanHighlighter
extends MouseAdapter
implements MouseMotionListener {
    private Rules rules;
    private Goban goban;
    private Point myHighlight = new Point();

    public GobanHighlighter(Goban goban) {
        this.setGoban(goban);
        this.startListening();
    }

    public GobanHighlighter(Rules rules) {
        this.setRules(rules);
        this.startListening();
    }

    private void startListening() {
        this.getGoban().addMouseListener(this);
        this.getGoban().addMouseMotionListener(this);
    }

    private void stopListening() {
        this.getGoban().removeMouseListener(this);
        this.getGoban().removeMouseMotionListener(this);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.getGoban().clearHighlight();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Goban goban = this.getGoban();
        if (goban.translateCoord(mouseEvent.getX(), mouseEvent.getY(), this.myHighlight)) {
            boolean bl = this.canHighlight(this.myHighlight);
            if (bl) {
                if (!goban.isHighlighted(this.myHighlight)) {
                    goban.setHighlight(this.myHighlight);
                }
            } else if (goban.isHighlighted()) {
                goban.clearHighlight();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Goban goban = this.getGoban();
        if (goban.translateCoord(mouseEvent.getX(), mouseEvent.getY(), this.myHighlight)) {
            if (this.canHighlight(this.myHighlight)) {
                goban.setHighlight(this.myHighlight);
            } else {
                goban.clearHighlight();
            }
        }
    }

    private boolean canHighlight(Point point) {
        Rules rules = this.getRules();
        return rules == null ? !this.getGoban().hasStone(point) : rules.canPlay(point);
    }

    private void setGoban(Goban goban) {
        this.goban = goban;
    }

    private Goban getGoban() {
        return this.goban;
    }

    private void setRules(Rules rules) {
        this.rules = rules;
        this.setGoban(rules.getGoban());
    }

    private Rules getRules() {
        return this.rules;
    }
}

