/*
 * Decompiled with CFR 0.152.
 */
package com.joot.jigo;

import com.joot.jigo.Goban;
import com.joot.jigo.Point;
import com.joot.jigo.Stone;
import java.util.Observable;
import java.util.Observer;

public class Rules
extends Observable
implements Observer {
    private static final byte UNEXAMINED = 0;
    private static final byte LIBERTY = 1;
    private static final byte STONE = 2;
    private byte[] emptyStoneMap;
    private byte[][] stoneMap;
    private Goban goban;
    private boolean _legalKo = true;
    private boolean _legalSelfCapture;
    private boolean whiteToPlay;
    private Point ko = new Point(-1, -1);
    private double komi;
    private double whiteCaptures;
    private double blackCaptures;

    public Rules(Goban goban) {
        this.setGoban(goban);
        this.initStoneMap(goban.getBoardSize());
    }

    @Override
    public void update(Observable observable, Object object) {
        Point point = (Point)object;
        Stone stone = this.getGoban().getStone(point);
        int n = 0;
        this.setWhiteToPlay(!stone.isWhite());
        --point.y;
        n += this.tryCullGroup(stone, point);
        point.y += 2;
        n += this.tryCullGroup(stone, point);
        --point.y;
        --point.x;
        n += this.tryCullGroup(stone, point);
        point.x += 2;
        --point.x;
        this.setKo((n += this.tryCullGroup(stone, point)) == 1 ? point : null);
    }

    public boolean isLegalKoEnabled() {
        return this._legalKo;
    }

    public void toggleLegalKo() {
        this._legalKo = !this._legalKo;
    }

    public boolean isSelfCaptureEnabled() {
        return this._legalSelfCapture;
    }

    public void toggleSelfCapture() {
        this._legalSelfCapture = !this._legalSelfCapture;
    }

    public double getKomi() {
        return this.komi;
    }

    public void setKomi(double d) {
        this.komi = d;
    }

    public double getWhiteCaptures() {
        return this.whiteCaptures;
    }

    public double getBlackCaptures() {
        return this.blackCaptures;
    }

    public boolean canPlay(Point point) {
        return this.canPlay(this.isWhiteToPlay(), point);
    }

    public boolean canPlay(boolean bl, Point point) {
        if (this.getGoban().hasStone(point)) {
            return false;
        }
        if (this.isLegalKoEnabled() && this.isKo(point)) {
            return false;
        }
        if (this.countLiberties(point.x, point.y) == 0) {
            if (this.libertiesAfterPlaying(bl, point) > 0) {
                return true;
            }
            if (this.wouldCapture(bl, point.x, point.y)) {
                return true;
            }
            return this.isSelfCaptureEnabled();
        }
        return true;
    }

    public void resetCaptures() {
        this.resetWhiteCaptures();
        this.resetBlackCaptures();
    }

    public void resetWhiteCaptures() {
        this.setWhiteCaptures(this.getKomi());
    }

    public void resetBlackCaptures() {
        this.setBlackCaptures(0.0);
    }

    @Override
    public void addObserver(Observer observer) {
        super.addObserver(observer);
        this.setChanged();
        this.notifyObservers();
    }

    public void togglePlayer() {
        this.setWhiteToPlay(!this.isWhiteToPlay());
    }

    public boolean isWhiteToPlay() {
        return this.whiteToPlay;
    }

    private int tryCullGroup(Stone stone, Point point) {
        int n = 0;
        if (!this.isValid(point.x, point.y)) {
            return n;
        }
        Stone stone2 = this.getGoban().getStone(point);
        if (stone2 != null && stone.isWhite() != stone2.isWhite()) {
            this.resetStoneMap();
            if (this.countGroupLiberties(point.x, point.y) == 0) {
                n = this.removeStones();
            }
            if (n > 0) {
                if (stone2.isWhite()) {
                    this.setWhiteCaptures(this.getWhiteCaptures() + (double)n);
                } else {
                    this.setBlackCaptures(this.getBlackCaptures() + (double)n);
                }
            }
        }
        return n;
    }

    private int removeStones() {
        byte[][] byArray = this.getStoneMap();
        Goban goban = this.getGoban();
        int n = byArray.length - 1;
        int n2 = 0;
        Point point = new Point();
        for (byte by = (byte)n; by >= 0; by = (byte)(by - 1)) {
            for (byte by2 = (byte)n; by2 >= 0; by2 = (byte)(by2 - 1)) {
                if (byArray[by][by2] != 2) continue;
                point.x = by;
                point.y = by2;
                goban.removeStone(point);
                ++n2;
            }
        }
        return n2;
    }

    private int libertiesAfterPlaying(boolean bl, Point point) {
        byte[][] byArray = this.getStoneMap();
        this.resetStoneMap();
        this.makeStoneMap(bl, point.x, point.y - 1, byArray);
        this.makeStoneMap(bl, point.x, point.y + 1, byArray);
        this.makeStoneMap(bl, point.x - 1, point.y, byArray);
        this.makeStoneMap(bl, point.x + 1, point.y, byArray);
        return this.countStoneMap(1) - 1;
    }

    private boolean sameGroup(Point point, Point point2) {
        boolean bl = this.getGoban().hasWhiteStone(point2);
        return this.sameGroup(point.x - 1, point.y, point2) || this.sameGroup(point.x + 1, point.y, point2) || this.sameGroup(point.x, point.y - 1, point2) || this.sameGroup(point.x, point.y + 1, point2);
    }

    private boolean sameGroup(int n, int n2, Point point) {
        return true;
    }

    private boolean wouldCapture(boolean bl, int n, int n2) {
        return this.captures(bl, n, n2 - 1) || this.captures(bl, n, n2 + 1) || this.captures(bl, n - 1, n2) || this.captures(bl, n + 1, n2);
    }

    private boolean captures(boolean bl, int n, int n2) {
        if (this.isValid(n, n2) && this.getGoban().hasBlackStone(n, n2) == bl) {
            this.resetStoneMap();
            if (this.countGroupLiberties(n, n2) == 1) {
                return true;
            }
        }
        return false;
    }

    private int liberties(boolean bl, int n, int n2) {
        if (this.isValid(n, n2) && this.getGoban().hasWhiteStone(n, n2) == bl) {
            this.resetStoneMap();
            return this.countGroupLiberties(n, n2);
        }
        return 0;
    }

    private boolean isKo(Point point) {
        return this.getKo().equals(point);
    }

    private int countLiberties(int n, int n2) {
        return this.countLiberty(n, n2 - 1) + this.countLiberty(n, n2 + 1) + this.countLiberty(n - 1, n2) + this.countLiberty(n + 1, n2);
    }

    private int countLiberty(int n, int n2) {
        return this.isValid(n, n2) ? (this.hasLiberty(n, n2) ? 1 : 0) : 0;
    }

    private boolean hasLiberty(int n, int n2) {
        return !this.getGoban().hasStone(n, n2);
    }

    private int countGroupLiberties(int n, int n2) {
        Stone stone = this.getGoban().getStone(n, n2);
        if (stone == null) {
            return 0;
        }
        this.makeStoneMap(stone.isWhite(), n, n2, this.getStoneMap());
        return this.countStoneMap(1);
    }

    private void initStoneMap(int n) {
        this.emptyStoneMap = new byte[n];
        this.stoneMap = new byte[n][n];
    }

    private void resetStoneMap() {
        byte[] byArray = this.emptyStoneMap;
        byte[][] byArray2 = this.getStoneMap();
        int n = byArray.length;
        for (int i = n - 1; i >= 0; --i) {
            System.arraycopy(byArray, 0, byArray2[i], 0, n);
        }
    }

    private boolean isValid(int n, int n2) {
        return this.getGoban().isValid(n, n2);
    }

    private boolean isValid(Point point) {
        return this.getGoban().isValid(point);
    }

    private boolean makeStoneMap(int n, int n2) {
        Stone stone = this.getGoban().getStone(n, n2);
        if (stone == null) {
            return false;
        }
        this.resetStoneMap();
        this.makeStoneMap(stone.isWhite(), n, n2, this.getStoneMap());
        return true;
    }

    private void makeStoneMap(boolean bl, int n, int n2, byte[][] byArray) {
        if (!this.isValid(n, n2)) {
            return;
        }
        if (byArray[n][n2] != 0) {
            return;
        }
        Stone stone = this.getGoban().getStone(n, n2);
        if (stone != null) {
            if (stone.isWhite() == bl) {
                byArray[n][n2] = 2;
                this.makeStoneMap(bl, n, n2 - 1, byArray);
                this.makeStoneMap(bl, n, n2 + 1, byArray);
                this.makeStoneMap(bl, n - 1, n2, byArray);
                this.makeStoneMap(bl, n + 1, n2, byArray);
            }
        } else {
            byArray[n][n2] = 1;
        }
    }

    private int countStoneMap(int n) {
        int n2;
        byte[][] byArray = this.getStoneMap();
        int n3 = 0;
        for (int i = n2 = byArray.length - 1; i >= 0; --i) {
            for (int j = n2; j >= 0; --j) {
                n3 += byArray[i][j] == n ? 1 : 0;
            }
        }
        return n3;
    }

    protected Goban getGoban() {
        return this.goban;
    }

    private void setGoban(Goban goban) {
        if (goban != null) {
            this.goban = goban;
            this.goban.addObserver(this);
        }
    }

    private void setWhiteCaptures(double d) {
        this.whiteCaptures = d;
        this.setChanged();
        this.notifyObservers();
    }

    private void setBlackCaptures(double d) {
        this.blackCaptures = d;
        this.setChanged();
        this.notifyObservers();
    }

    private void setKo(Point point) {
        if (point != null) {
            this.ko.x = point.x;
            this.ko.y = point.y;
        } else {
            this.ko.x = -1;
        }
    }

    private Point getKo() {
        return this.ko;
    }

    private void setWhiteToPlay(boolean bl) {
        this.whiteToPlay = bl;
    }

    private byte[][] getStoneMap() {
        return this.stoneMap;
    }
}

