/*
 * Decompiled with CFR 0.152.
 */
package com.joot.jigo.examples;

import com.joot.awt.util.AlertBox;
import com.joot.jigo.Goban;
import com.joot.jigo.GobanHighlighter;
import com.joot.jigo.JiGoApplet;
import com.joot.jigo.Markup;
import com.joot.jigo.Point;
import com.joot.jigo.Rules;
import com.joot.jigo.Stone;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class RandomPlayer
extends JiGoApplet
implements MouseListener {
    private static final int GOBAN_SIZE = 9;
    private Goban goban;
    private Rules rules;

    @Override
    public void init() {
        this.setGoban(new Goban(9, (Stone)this.getWhiteStone()));
        this.goban.setHoshiPixelSize(4);
        this.add(this.goban);
        GobanHighlighter gobanHighlighter = new GobanHighlighter(this.getGoban());
        this.goban.addMouseListener(this);
        this.setRules(new Rules(this.getGoban()));
        this.makeMove();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        Goban goban = this.getGoban();
        Rules rules = this.getRules();
        Point point = new Point();
        if (goban.translateCoord(mouseEvent.getX(), mouseEvent.getY(), point) && rules.canPlay(point)) {
            this.getGoban().placeStone(this.getStone(), point);
            this.makeMove();
        }
    }

    private void makeMove() {
        boolean bl = false;
        boolean bl2 = false;
        int n = 81;
        Point point = new Point();
        Rules rules = this.getRules();
        this.getGoban().removeAllMarks();
        while (!bl && --n > 0) {
            point.x = (int)(Math.random() * 9.0);
            point.y = (int)(Math.random() * 9.0);
            bl = rules.canPlay(point);
            if (!bl) continue;
            this.getGoban().placeStone(this.getStone(), point);
            this.getGoban().placeMark(new Markup(3), point);
        }
        if (!bl) {
            rules.togglePlayer();
            new AlertBox(new Frame(), "Game Over", "RandomPlayer Passes");
        }
    }

    private Stone getStone() {
        return this.getRules().isWhiteToPlay() ? this.getWhiteStone() : this.getBlackStone();
    }

    protected Goban getGoban() {
        return this.goban;
    }

    private void setGoban(Goban goban) {
        this.goban = goban;
    }

    private void setRules(Rules rules) {
        this.rules = rules;
    }

    private Rules getRules() {
        return this.rules;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }
}

