/*
 * Decompiled with CFR 0.152.
 */
package com.joot.awt.util;

import com.joot.awt.widgets.EscapableDialog;
import com.joot.awt.widgets.OrderedList;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class FileDialog
extends EscapableDialog
implements ActionListener,
WindowListener {
    private static final String DEFAULT_TITLE = "Choose a File ...";
    private static final String DIRECTORY_INDEX = "directory.dat";
    private static final String PREVIOUS_DIRECTORY = "<< Back <<";
    private static final int VISIBLE_ITEMS = 12;
    private static final char DIRECTORY_CHAR = '+';
    private static final char SEPARATOR = '/';
    private Vector<ActionListener> myActionListeners = new Vector();
    private String myFileName;
    private String myRootDir;
    private String myCurrentDir = "";
    private String myHostName;
    private OrderedList myDirectories;
    private OrderedList myFiles;
    private Button myOKButton = new Button("OK");
    private Button myCancelButton = new Button("Cancel");

    public FileDialog(Frame frame, String string, String string2) {
        this(frame, DEFAULT_TITLE, string, string2);
    }

    public FileDialog(Frame frame, String string, URL uRL) {
        this(frame, string, uRL.getHost(), uRL.getPath());
    }

    public FileDialog(Frame frame, String string, String string2, String string3) {
        super(frame, string, true);
        this.setHostName(string2);
        this.setRootDir(string3);
        this.initGUI();
        this.addWindowListener(this);
    }

    private void initGUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.setLayout(gridBagLayout);
        Label label = new Label("Directories");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        gridBagConstraints.gridwidth = 0;
        label = new Label("Files");
        gridBagLayout.setConstraints(label, gridBagConstraints);
        this.add(label);
        this.setDirectoryList(new OrderedList(12, false));
        this.setFileList(new OrderedList(12, false));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagLayout.setConstraints(this.getDirectoryList(), gridBagConstraints);
        this.add(this.getDirectoryList());
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.getFileList(), gridBagConstraints);
        this.add(this.getFileList());
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagLayout.setConstraints(this.myOKButton, gridBagConstraints);
        this.add(this.myOKButton);
        gridBagLayout.setConstraints(this.myCancelButton, gridBagConstraints);
        this.add(this.myCancelButton);
        this.myOKButton.addActionListener(this);
        this.myCancelButton.addActionListener(this);
        this.getDirectoryList().addActionListener(this);
        this.getFileList().addActionListener(this);
        this.resize();
        this.pack();
    }

    protected void resize() {
        this.setSize(this.getDefaultWidth(), this.getDefaultHeight());
    }

    protected int getDefaultWidth() {
        return 320;
    }

    protected int getDefaultHeight() {
        return 270;
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.cancelSelected();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.updateLists();
        this.myOKButton.requestFocus();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.getDirectoryList().scrollToSelected();
            this.getFileList().scrollToSelected();
        }
    }

    private void updateLists() {
        OrderedList orderedList = this.getDirectoryList();
        OrderedList orderedList2 = this.getFileList();
        orderedList.setVisible(false);
        orderedList2.setVisible(false);
        orderedList2.removeAll();
        orderedList.removeAll();
        try {
            URL uRL = new URL("http", this.getHostName(), this.getRootDir() + this.getCurrentDir() + this.getDirectoryIndex());
            this.downloadLists(uRL.openConnection().getInputStream());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getCurrentDir() != "") {
            orderedList.add(this.getPreviousDirectory(), 0);
        }
        orderedList.setVisible(true);
        orderedList2.setVisible(true);
    }

    private void downloadLists(InputStream inputStream) throws MalformedURLException, IOException {
        String string;
        OrderedList orderedList = this.getDirectoryList();
        OrderedList orderedList2 = this.getFileList();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            if (string.length() <= 1) continue;
            if (string.charAt(0) == '+') {
                orderedList.add(string.substring(1));
                continue;
            }
            orderedList2.add(string);
        }
        bufferedReader.close();
        inputStream.close();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.getFileList().getSelectedItem();
        String string2 = this.getDirectoryList().getSelectedItem();
        Object object = actionEvent.getSource();
        if (object == this.myOKButton || object == this.getFileList()) {
            if (string != null) {
                this.fileSelected(string);
            } else if (string2 != null) {
                this.directorySelected(string2);
            }
        } else if (object == this.getDirectoryList() && string2 != null) {
            this.directorySelected(string2);
        } else if (object == this.myCancelButton) {
            this.cancelSelected();
        }
    }

    private void fileSelected(String string) {
        this.setVisible(false);
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.getRootDir() + this.getCurrentDir() + string);
        this.notifyListeners(actionEvent);
        this.dispose();
    }

    private void directorySelected(String string) {
        String string2 = this.getCurrentDir();
        int n = -1;
        if (string2.length() > 1) {
            n = string2.lastIndexOf(47, string2.length() - 2);
        }
        if (string.equals(this.getPreviousDirectory())) {
            this.setCurrentDir(n != -1 ? string2.substring(0, n) + '/' : "");
        } else {
            this.setCurrentDir(string2 + string + '/');
        }
        this.updateLists();
    }

    private void cancelSelected() {
        this.setVisible(false);
        this.dispose();
    }

    private void notifyListeners(ActionEvent actionEvent) {
        Enumeration<ActionListener> enumeration = this.myActionListeners.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().actionPerformed(actionEvent);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.myActionListeners.removeElement(actionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.myActionListeners.addElement(actionListener);
    }

    protected String getDirectoryIndex() {
        return DIRECTORY_INDEX;
    }

    protected String getPreviousDirectory() {
        return PREVIOUS_DIRECTORY;
    }

    private String getHostName() {
        return this.myHostName;
    }

    private void setHostName(String string) {
        this.myHostName = string;
    }

    private String getRootDir() {
        return this.myRootDir;
    }

    private void setRootDir(String string) {
        this.myRootDir = string;
    }

    private String getCurrentDir() {
        return this.myCurrentDir;
    }

    private void setCurrentDir(String string) {
        this.myCurrentDir = string;
    }

    private void setFileList(OrderedList orderedList) {
        this.myFiles = orderedList;
    }

    private OrderedList getFileList() {
        return this.myFiles;
    }

    private void setDirectoryList(OrderedList orderedList) {
        this.myDirectories = orderedList;
    }

    private OrderedList getDirectoryList() {
        return this.myDirectories;
    }
}

