/*
 * Decompiled with CFR 0.152.
 */
package com.joot.awt.widgets;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.Vector;

public class ImageButton
extends Container
implements MouseListener {
    private Image myImage;
    private Image myDisabledImage;
    private Vector<ActionListener> myListeners = new Vector(1);
    private static final Color UL_OUT = new Color(192, 192, 192);
    private static final Color UL_IN = new Color(238, 238, 238);
    private static final Color LR_IN = new Color(128, 128, 128);
    private static final Color LR_OUT = new Color(0, 0, 0);
    protected boolean amPressed;
    private boolean wasPressed;
    private String myCommand;

    public ImageButton(Image image, String string) {
        this(image, null, string);
    }

    public ImageButton(Image image, Image image2, String string) {
        this.setCommand(string);
        this.setImage(image);
        this.setDisabledImage(image2);
        this.setSize(new Dimension(image.getWidth(null) + 4, image.getHeight(null) + 4));
        this.addMouseListener(this);
        this.setEnabled(true);
    }

    @Override
    public void update(Graphics graphics) {
        if (this.isPressed() && this.isEnabled()) {
            this.drawLoweredBorder(graphics);
        } else {
            this.drawRaisedBorder(graphics);
        }
        Image image = this.getDisabledImage();
        if (this.isEnabled() || image == null) {
            image = this.getImage();
        }
        Dimension dimension = this.getSize();
        int n = image.getHeight(null) >> 1;
        int n2 = image.getWidth(null) >> 1;
        int n3 = dimension.height >> 1;
        int n4 = dimension.width >> 1;
        graphics.drawImage(image, n4 - n2 + 1, n3 - n + 1, this);
    }

    @Override
    public void paint(Graphics graphics) {
        ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.update(graphics);
    }

    private void drawRaisedBorder(Graphics graphics) {
        int n = this.getPreferredSize().width;
        int n2 = this.getPreferredSize().height;
        graphics.setColor(UL_OUT);
        graphics.drawLine(0, 0, 0, n2);
        graphics.drawLine(0, 0, n - 1, 0);
        graphics.setColor(UL_IN);
        graphics.drawLine(1, 1, 1, n2 - 1);
        graphics.drawLine(1, 1, n - 2, 1);
        graphics.setColor(LR_IN);
        graphics.drawLine(2, n2 - 1, n - 1, n2 - 1);
        graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
        graphics.setColor(LR_OUT);
        graphics.drawLine(1, n2, n, n2);
        graphics.drawLine(n, 0, n, n2);
    }

    private void drawLoweredBorder(Graphics graphics) {
        int n = this.getPreferredSize().width;
        int n2 = this.getPreferredSize().height;
        graphics.setColor(LR_OUT);
        graphics.drawLine(0, 0, 0, n2);
        graphics.drawLine(0, 0, n - 1, 0);
        graphics.setColor(LR_IN);
        graphics.drawLine(1, 1, 1, n2 - 1);
        graphics.drawLine(1, 1, n - 2, 1);
        graphics.setColor(UL_IN);
        graphics.drawLine(2, n2 - 1, n - 1, n2 - 1);
        graphics.drawLine(n - 1, 1, n - 1, n2 - 1);
        graphics.setColor(UL_OUT);
        graphics.drawLine(1, n2, n, n2);
        graphics.drawLine(n, 0, n, n2);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isEnabled()) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, this.getCommand(), mouseEvent.getModifiers());
            Enumeration enumeration = this.getListeners();
            while (enumeration.hasMoreElements()) {
                try {
                    ((ActionListener)enumeration.nextElement()).actionPerformed(actionEvent);
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.wasPressed = true;
        this.setPressed(true);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.wasPressed = false;
        this.setPressed(false);
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.isPressed()) {
            this.setPressed(false);
            this.wasPressed = true;
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.wasPressed) {
            this.setPressed(true);
            this.wasPressed = false;
            this.repaint();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.myListeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.myListeners.removeElement(actionListener);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private Enumeration getListeners() {
        return this.myListeners.elements();
    }

    protected Image getImage() {
        return this.myImage;
    }

    protected void setImage(Image image) {
        this.myImage = image;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            super.setEnabled(bl);
            this.repaint();
        }
    }

    private Image getDisabledImage() {
        return this.myDisabledImage;
    }

    protected void setDisabledImage(Image image) {
        this.myDisabledImage = image;
    }

    protected boolean isPressed() {
        return this.amPressed;
    }

    private void setPressed(boolean bl) {
        this.amPressed = bl;
    }

    private String getCommand() {
        return this.myCommand;
    }

    private void setCommand(String string) {
        this.myCommand = string;
    }
}

