/*
 * Decompiled with CFR 0.152.
 */
package com.joot.awt.widgets;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public class ImageComponent
extends Component {
    private Image image;
    private Image offscreen;

    public ImageComponent(Image image) {
        this.setImage(image);
    }

    public ImageComponent(Image image, int n, int n2) {
        this(image.getScaledInstance(n, n2, 4));
    }

    @Override
    public void update(Graphics graphics) {
        if (graphics != null) {
            graphics.drawImage(this.getOffscreen(), 0, 0, null);
        }
    }

    public void redraw() {
        this.getOffscreen().getGraphics().drawImage(this.getImage(), 0, 0, this);
    }

    @Override
    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.getImage().getWidth(this), this.getImage().getHeight(this));
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getSize();
    }

    protected Image createOffscreen() {
        return this.createImage(this.getWidth(), this.getHeight());
    }

    protected Image getOffscreen() {
        if (this.offscreen == null) {
            this.offscreen = this.createOffscreen();
            this.redraw();
        }
        return this.offscreen;
    }

    private void setOffscreen(Image image) {
        this.offscreen = image;
    }

    protected Image getImage() {
        return this.image;
    }

    protected void setImage(Image image) {
        this.image = image;
    }
}

