/*
 * Decompiled with CFR 0.152.
 */
package com.joot.jigo.dataformats;

import com.joot.jigo.dataformats.GameReaderDriver;
import com.joot.jigo.dataformats.GoGame;
import com.joot.jigo.dataformats.exceptions.DataFormatException;
import com.joot.jigo.dataformats.exceptions.UnknownFileFormatException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

public class GameReader {
    private static final int HEADER_BYTES = 4096;
    private static Vector<GameReaderDriver> myDrivers = new Vector();

    private GameReader() {
    }

    public static void registerDriver(GameReaderDriver gameReaderDriver) {
        myDrivers.addElement(gameReaderDriver);
    }

    public static void registerDriver(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            GameReader.registerDriver((GameReaderDriver)clazz.newInstance());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void deregisterDriver(GameReaderDriver gameReaderDriver) {
        myDrivers.removeElement(gameReaderDriver);
    }

    private static Enumeration getDrivers() {
        return myDrivers.elements();
    }

    public static synchronized GoGame read(InputStream inputStream) throws IOException, DataFormatException {
        GoGame goGame = null;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(4096);
        Enumeration enumeration = GameReader.getDrivers();
        while (enumeration.hasMoreElements() && goGame == null) {
            GameReaderDriver gameReaderDriver = (GameReaderDriver)enumeration.nextElement();
            try {
                goGame = gameReaderDriver.read(bufferedInputStream);
            }
            catch (DataFormatException dataFormatException) {
                bufferedInputStream.reset();
            }
        }
        if (goGame == null) {
            throw new UnknownFileFormatException();
        }
        return goGame;
    }
}

