/*
 * Decompiled with CFR 0.152.
 */
package com.joot.jigo.dataformats;

import com.joot.jigo.dataformats.GameLeaf;
import com.joot.jigo.dataformats.tokens.GameToken;
import com.joot.jigo.dataformats.tokens.InfoToken;
import java.util.Enumeration;
import java.util.Vector;

public class GameTree {
    private static final int AVERAGE_VARIATIONS = 2;
    private static final int AVERAGE_LEAVES = 5;
    private static final int AVERAGE_LEAF_INCR = 50;
    private static final int AVERAGE_INFO_TOKENS = 10;
    private Vector<GameLeaf> myLeaves;
    private Vector<GameTree> myTrees;

    public void add(GameLeaf gameLeaf) {
        if (gameLeaf != null) {
            if (this.myLeaves == null) {
                this.myLeaves = new Vector(5, 50);
            }
            this.myLeaves.addElement(gameLeaf);
        }
    }

    public void addLeaf(GameLeaf gameLeaf) {
        this.add(gameLeaf);
    }

    public Enumeration getLeaves() {
        return this.myLeaves == null ? null : this.myLeaves.elements();
    }

    public Enumeration getInfoTokens() {
        Vector<GameToken> vector = null;
        Enumeration enumeration = this.getLeaves();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                GameLeaf gameLeaf = (GameLeaf)enumeration.nextElement();
                Enumeration enumeration2 = gameLeaf.getTokens();
                while (enumeration2.hasMoreElements()) {
                    GameToken gameToken = (GameToken)enumeration2.nextElement();
                    if (!(gameToken instanceof InfoToken)) continue;
                    if (vector == null) {
                        vector = new Vector<GameToken>(10);
                    }
                    vector.addElement(gameToken);
                }
            }
        }
        return vector == null ? null : vector.elements();
    }

    public int getLeafCount() {
        return this.myLeaves == null ? 0 : this.myLeaves.size();
    }

    public int getTreeCount() {
        return this.myTrees == null ? 0 : this.myTrees.size();
    }

    public int getVariationCount() {
        return this.getTreeCount();
    }

    public void add(GameTree gameTree) {
        if (this.myTrees == null) {
            this.myTrees = new Vector(2);
        }
        this.myTrees.addElement(gameTree);
    }

    public void addTree(GameTree gameTree) {
        this.add(gameTree);
    }

    public Enumeration getTrees() {
        return this.myTrees == null ? null : this.myTrees.elements();
    }
}

