/*
 * Decompiled with CFR 0.152.
 */
package com.joot.jigo.dataformats.sgf;

import com.joot.jigo.dataformats.GameLeaf;
import com.joot.jigo.dataformats.GameReaderDriver;
import com.joot.jigo.dataformats.GoGame;
import com.joot.jigo.dataformats.exceptions.DataFormatException;
import com.joot.jigo.dataformats.sgf.SGFException;
import com.joot.jigo.dataformats.sgf.SGFGame;
import com.joot.jigo.dataformats.sgf.SGFLeaf;
import com.joot.jigo.dataformats.sgf.SGFTree;
import com.joot.jigo.dataformats.sgf.tokens.AddBlackTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.AddWhiteTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.ArrowTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.BadMoveTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.BlackMoveTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.BlackNameTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.BlackRankTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.BlackSpeciesTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.BlackStonesLeftTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.BlackTimeTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.CharacterEncodingTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.CircleTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.CommentTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.CopyrightTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.DateTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.DimTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.DoubtfulMoveTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.EvenPositionTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.EventTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.FigureTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.FileFormatTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.GameCommentTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.GameIDTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.GameNameTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.GameTypeTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.GoodBlackMoveTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.GoodWhiteMoveTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.InterestingMoveTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.KoTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.KomiTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.LetterTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.LineTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.MoveNumberTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.NodeNameTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.PlaceTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.PrintModeTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.ResultTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.RoundTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.RuleSetTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.SGFTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.SelectedListTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.SizeTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.SourceTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.SquareTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.SystemTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.TesujiTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.TimeLimitTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.UnclearPositionTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.UserTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.ViewTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.WhiteMoveTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.WhiteNameTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.WhiteRankTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.WhiteSpeciesTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.WhiteStonesLeftTokenImpl;
import com.joot.jigo.dataformats.sgf.tokens.WhiteTimeTokenImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.Hashtable;

public final class SGFReaderDriver
implements GameReaderDriver {
    private static final String INVALID_SGF_FILE = "Invalid SGF File.";
    private static Hashtable<String, Class> tokenClasses = new Hashtable(128);

    @Override
    public GoGame read(InputStream inputStream) throws IOException, DataFormatException {
        StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new InputStreamReader(inputStream)));
        this.resetTokenizer(streamTokenizer);
        return this.readGame(streamTokenizer);
    }

    private SGFGame readGame(StreamTokenizer streamTokenizer) throws IOException, DataFormatException {
        return new SGFGame(this.readTree(streamTokenizer));
    }

    private SGFTree readTree(StreamTokenizer streamTokenizer) throws IOException, SGFException {
        SGFTree sGFTree = new SGFTree();
        int n = 0;
        block6: while ((n = streamTokenizer.nextToken()) != -1) {
            switch (n) {
                case 59: {
                    sGFTree.add(this.readLeaf(streamTokenizer));
                    continue block6;
                }
                case 40: {
                    sGFTree.add(this.readTree(streamTokenizer));
                    continue block6;
                }
                case 41: {
                    return sGFTree;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block6;
                }
            }
            throw new SGFException(INVALID_SGF_FILE);
        }
        return sGFTree;
    }

    private SGFLeaf readLeaf(StreamTokenizer streamTokenizer) throws IOException, SGFException {
        int n = 0;
        GameLeaf gameLeaf = null;
        while ((n = streamTokenizer.nextToken()) != -1 && n != 59 && n != 40 && n != 41) {
            SGFTokenImpl sGFTokenImpl;
            if (n != -3 || (sGFTokenImpl = this.readToken(streamTokenizer)) == null) continue;
            if (gameLeaf == null) {
                gameLeaf = new SGFLeaf(sGFTokenImpl);
                continue;
            }
            gameLeaf.addToken(sGFTokenImpl);
        }
        streamTokenizer.pushBack();
        return gameLeaf;
    }

    private SGFTokenImpl readToken(StreamTokenizer streamTokenizer) throws IOException, SGFException {
        SGFTokenImpl sGFTokenImpl = this.getTokenForName(streamTokenizer.sval);
        if (sGFTokenImpl != null) {
            sGFTokenImpl.setStreamTokenizer(streamTokenizer);
            sGFTokenImpl.parse();
        }
        return sGFTokenImpl;
    }

    private void resetTokenizer(StreamTokenizer streamTokenizer) {
        streamTokenizer.lowerCaseMode(false);
        streamTokenizer.eolIsSignificant(false);
        streamTokenizer.ordinaryChars(0, 255);
        streamTokenizer.wordChars(33, 126);
        streamTokenizer.ordinaryChar(59);
        streamTokenizer.ordinaryChar(92);
        streamTokenizer.ordinaryChars(91, 93);
        streamTokenizer.ordinaryChars(40, 41);
    }

    private SGFTokenImpl getTokenForName(String string) {
        Class clazz = tokenClasses.get(string.toUpperCase());
        try {
            return (SGFTokenImpl)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        tokenClasses.put("B", BlackMoveTokenImpl.class);
        tokenClasses.put("BLACK", BlackMoveTokenImpl.class);
        tokenClasses.put("W", WhiteMoveTokenImpl.class);
        tokenClasses.put("WHITE", WhiteMoveTokenImpl.class);
        tokenClasses.put("C", CommentTokenImpl.class);
        tokenClasses.put("CP", CopyrightTokenImpl.class);
        tokenClasses.put("COMMENT", CommentTokenImpl.class);
        tokenClasses.put("N", NodeNameTokenImpl.class);
        tokenClasses.put("NAME", NodeNameTokenImpl.class);
        tokenClasses.put("FG", FigureTokenImpl.class);
        tokenClasses.put("AR", ArrowTokenImpl.class);
        tokenClasses.put("CR", CircleTokenImpl.class);
        tokenClasses.put("SQ", SquareTokenImpl.class);
        tokenClasses.put("LB", LetterTokenImpl.class);
        tokenClasses.put("LETTER", LetterTokenImpl.class);
        tokenClasses.put("MN", MoveNumberTokenImpl.class);
        tokenClasses.put("LN", LineTokenImpl.class);
        tokenClasses.put("DD", DimTokenImpl.class);
        tokenClasses.put("SL", SelectedListTokenImpl.class);
        tokenClasses.put("VW", ViewTokenImpl.class);
        tokenClasses.put("VIEW", ViewTokenImpl.class);
        tokenClasses.put("AB", AddBlackTokenImpl.class);
        tokenClasses.put("ADDBLACK", AddBlackTokenImpl.class);
        tokenClasses.put("AW", AddWhiteTokenImpl.class);
        tokenClasses.put("ADDWHITE", AddWhiteTokenImpl.class);
        tokenClasses.put("TE", TesujiTokenImpl.class);
        tokenClasses.put("BM", BadMoveTokenImpl.class);
        tokenClasses.put("GB", GoodBlackMoveTokenImpl.class);
        tokenClasses.put("GW", GoodWhiteMoveTokenImpl.class);
        tokenClasses.put("DM", EvenPositionTokenImpl.class);
        tokenClasses.put("UC", UnclearPositionTokenImpl.class);
        tokenClasses.put("IT", InterestingMoveTokenImpl.class);
        tokenClasses.put("DO", DoubtfulMoveTokenImpl.class);
        tokenClasses.put("KO", KoTokenImpl.class);
        tokenClasses.put("FF", FileFormatTokenImpl.class);
        tokenClasses.put("CA", CharacterEncodingTokenImpl.class);
        tokenClasses.put("GM", GameTypeTokenImpl.class);
        tokenClasses.put("GAME", GameTypeTokenImpl.class);
        tokenClasses.put("SZ", SizeTokenImpl.class);
        tokenClasses.put("SIZE", SizeTokenImpl.class);
        tokenClasses.put("KM", KomiTokenImpl.class);
        tokenClasses.put("KOMI", KomiTokenImpl.class);
        tokenClasses.put("PW", WhiteNameTokenImpl.class);
        tokenClasses.put("PLAYERWHITE", WhiteNameTokenImpl.class);
        tokenClasses.put("PB", BlackNameTokenImpl.class);
        tokenClasses.put("PLAYERBLACK", BlackNameTokenImpl.class);
        tokenClasses.put("WR", WhiteRankTokenImpl.class);
        tokenClasses.put("WHITERANK", WhiteRankTokenImpl.class);
        tokenClasses.put("BR", BlackRankTokenImpl.class);
        tokenClasses.put("BLACKRANK", BlackRankTokenImpl.class);
        tokenClasses.put("DT", DateTokenImpl.class);
        tokenClasses.put("DATE", DateTokenImpl.class);
        tokenClasses.put("RE", ResultTokenImpl.class);
        tokenClasses.put("RESULT", ResultTokenImpl.class);
        tokenClasses.put("TM", TimeLimitTokenImpl.class);
        tokenClasses.put("TIME", TimeLimitTokenImpl.class);
        tokenClasses.put("WL", WhiteTimeTokenImpl.class);
        tokenClasses.put("BL", BlackTimeTokenImpl.class);
        tokenClasses.put("OW", WhiteStonesLeftTokenImpl.class);
        tokenClasses.put("OB", BlackStonesLeftTokenImpl.class);
        tokenClasses.put("PM", PrintModeTokenImpl.class);
        tokenClasses.put("ST", SystemTokenImpl.class);
        tokenClasses.put("PC", PlaceTokenImpl.class);
        tokenClasses.put("PLACE", PlaceTokenImpl.class);
        tokenClasses.put("EV", EventTokenImpl.class);
        tokenClasses.put("EVENT", EventTokenImpl.class);
        tokenClasses.put("RO", RoundTokenImpl.class);
        tokenClasses.put("ROUND", RoundTokenImpl.class);
        tokenClasses.put("SO", SourceTokenImpl.class);
        tokenClasses.put("SOURCE", SourceTokenImpl.class);
        tokenClasses.put("US", UserTokenImpl.class);
        tokenClasses.put("GC", GameCommentTokenImpl.class);
        tokenClasses.put("RU", RuleSetTokenImpl.class);
        tokenClasses.put("WS", WhiteSpeciesTokenImpl.class);
        tokenClasses.put("BS", BlackSpeciesTokenImpl.class);
        tokenClasses.put("GN", GameNameTokenImpl.class);
        tokenClasses.put("GAMENAME", GameNameTokenImpl.class);
        tokenClasses.put("ID", GameIDTokenImpl.class);
    }
}

