/*
 * Decompiled with CFR 0.152.
 */
package com.joot.jigo.dataformats.sgf.tokens;

import com.joot.jigo.dataformats.sgf.SGFException;
import com.joot.jigo.dataformats.sgf.tokens.TextTokenImpl;
import com.joot.jigo.dataformats.tokens.ResultToken;
import java.io.IOException;
import java.io.StreamTokenizer;

public final class ResultTokenImpl
extends TextTokenImpl
implements ResultToken {
    public static final int WHITE_WINS = 1;
    public static final int BLACK_WINS = 2;
    public static final int JIGO = 3;
    public static final int SUSPENDED = 4;
    public static final int BY_SCORE = 1;
    public static final int BY_RESIGNATION = 2;
    public static final int BY_TIME = 3;
    public static final int BY_FORFEIT = 4;
    public static final int BY_UNKNOWN = 5;
    public static final int BY_JIGO = 6;
    private static final int SCORE_INDEX = 2;
    private int myWinner = 4;
    private int myReason = 5;
    private float myScore;

    @Override
    protected boolean parseContent(StreamTokenizer streamTokenizer) throws IOException, SGFException {
        if (!super.parseContent(streamTokenizer)) {
            return false;
        }
        String string = this.getText();
        if (string.startsWith("B")) {
            this.setWinner(2);
        } else if (string.startsWith("W")) {
            this.setWinner(1);
        } else if (string.equals("0") || string.equalsIgnoreCase("DRAW") || string.equalsIgnoreCase("JIGO")) {
            this.setWinner(3);
        } else {
            this.setWinner(4);
            return true;
        }
        try {
            switch (string.charAt(2)) {
                case 'R': {
                    this.setReason(2);
                    break;
                }
                case 'T': {
                    this.setReason(3);
                    break;
                }
                case 'F': {
                    this.setReason(4);
                    break;
                }
                case '0': 
                case 'J': {
                    this.setReason(6);
                    break;
                }
                default: {
                    this.setReason(1);
                    this.setScore(Float.valueOf(string.substring(2, string.length())).floatValue());
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    @Override
    public int getWinner() {
        return this.myWinner;
    }

    private void setWinner(int n) {
        this.myWinner = n;
    }

    @Override
    public int getReason() {
        return this.myReason;
    }

    private void setReason(int n) {
        this.myReason = n;
    }

    @Override
    public float getScore() {
        return this.myScore;
    }

    private void setScore(float f) {
        this.myScore = f;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.getWinner()) {
            case 1: {
                stringBuffer.append("W+");
                break;
            }
            case 2: {
                stringBuffer.append("B+");
                break;
            }
            case 3: {
                stringBuffer.append("Jigo");
                return stringBuffer.toString();
            }
            case 4: {
                stringBuffer.append("Suspended");
                return stringBuffer.toString();
            }
        }
        switch (this.getReason()) {
            case 1: {
                stringBuffer.append(this.getScore());
                break;
            }
            case 2: {
                stringBuffer.append('R');
                break;
            }
            case 3: {
                stringBuffer.append('T');
                break;
            }
            case 4: {
                stringBuffer.append('F');
                break;
            }
            case 5: {
                stringBuffer.append('?');
                break;
            }
            case 6: {
                stringBuffer.append('J');
            }
        }
        return stringBuffer.toString();
    }
}

