/*
 * Decompiled with CFR 0.152.
 */
package com.joot.jigo.replayer;

import com.joot.awt.widgets.ImageComponent;
import com.joot.jigo.Rules;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Observable;
import java.util.Observer;

public class InfoPanel
extends ImageComponent
implements Runnable,
Observer {
    private static final int INVALID = 666;
    private static final String DEFAULT_TEXT = "JiGo by Dave Jarvis ... http://www.joot.com/jigo";
    private byte[] _marqueeBytes;
    private Thread _marqueeThread = new Thread(this);
    private boolean _running = true;
    private Rectangle _whiteCapturesRect = new Rectangle(195, 15, 35, 20);
    private Rectangle _blackCapturesRect = new Rectangle(195, 55, 35, 20);
    private Rectangle _resultRect = new Rectangle(185, 95, 40, 20);
    private Rectangle _marqueeRect = new Rectangle(25, 140, 195, 20);
    private int wCaptures = 0;
    private int bCaptures = 0;
    private Image _originalBackground;
    private int _horizIndex = 666;
    private int textWidth;

    public InfoPanel(Image image) {
        super(image);
        this.setMarqueeText(DEFAULT_TEXT);
    }

    @Override
    public void run() {
        while (this.isRunning()) {
            this.scroll(this.getGraphics());
            this.sleep(this.getMarqueeDelay());
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        Rules rules = (Rules)observable;
        this.setWhiteCaptures((int)rules.getWhiteCaptures());
        this.setBlackCaptures((int)rules.getBlackCaptures());
    }

    protected int getMarqueeDelay() {
        return 40;
    }

    private void display(Rectangle rectangle, String string) {
        Graphics graphics = this.getOffscreen().getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        byte[] byArray = string.getBytes();
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.drawImage(this.getOriginalBackground(), 0, 0, null);
        graphics.drawBytes(byArray, 0, byArray.length, rectangle.x + fontMetrics.getLeading(), rectangle.y + fontMetrics.getAscent());
        this.getGraphics().drawImage(this.getOffscreen(), 0, 0, null);
        graphics.setClip(0, 0, this.getWidth(), this.getHeight());
    }

    public void setWhiteCaptures(int n) {
        if (this.wCaptures != n) {
            this.wCaptures = n;
            this.display(this.getWhiteCapturesRect(), Integer.toString(n));
        }
    }

    public void setBlackCaptures(int n) {
        if (this.bCaptures != n) {
            this.bCaptures = n;
            this.display(this.getBlackCapturesRect(), Integer.toString(n));
        }
    }

    public void setResult(String string) {
        this.display(this.getResultRect(), string);
        this.repaint();
    }

    private void scroll(Graphics graphics) {
        if (graphics != null) {
            Rectangle rectangle = this.getMarqueeRect();
            Image image = this.getOffscreen();
            Graphics graphics2 = image.getGraphics();
            graphics2.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics2.drawImage(this.getOriginalBackground(), 0, 0, null);
            this.drawText(graphics2, rectangle);
            graphics.drawImage(image, 0, 0, null);
            graphics2.setClip(0, 0, this.getWidth(), this.getHeight());
        }
    }

    private void drawText(Graphics graphics, Rectangle rectangle) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        byte[] byArray = this.getMarqueeBytes();
        int n = this.getHorizontalIndex();
        if (n == 666) {
            n = rectangle.width;
            this.textWidth = fontMetrics.bytesWidth(byArray, 0, byArray.length);
        }
        graphics.drawBytes(byArray, 0, byArray.length, rectangle.x + fontMetrics.getLeading() + n, rectangle.y + fontMetrics.getAscent());
        if (--n + rectangle.width + this.textWidth < 0) {
            n = rectangle.width;
        }
        this.setHorizontalIndex(n);
    }

    private void sleep(int n) {
        try {
            this.getMarqueeThread();
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void startMarquee() {
        this.setRunning(true);
        if (!this.getMarqueeThread().isAlive()) {
            this.getMarqueeThread().start();
        }
    }

    public void stopMarquee() {
        this.setRunning(false);
    }

    private int getHorizontalIndex() {
        return this._horizIndex;
    }

    private void setHorizontalIndex(int n) {
        this._horizIndex = n;
    }

    private boolean isRunning() {
        return this._running;
    }

    private void setRunning(boolean bl) {
        this._running = bl;
    }

    private void setResultRect(Rectangle rectangle) {
        this._resultRect = rectangle;
    }

    private Rectangle getResultRect() {
        return this._resultRect;
    }

    private void setWhiteCapturesRect(Rectangle rectangle) {
        this._whiteCapturesRect = rectangle;
    }

    private Rectangle getWhiteCapturesRect() {
        return this._whiteCapturesRect;
    }

    private void setBlackCapturesRect(Rectangle rectangle) {
        this._blackCapturesRect = rectangle;
    }

    private Rectangle getBlackCapturesRect() {
        return this._blackCapturesRect;
    }

    private void setMarqueeRect(Rectangle rectangle) {
        this._marqueeRect = rectangle;
    }

    private Rectangle getMarqueeRect() {
        return this._marqueeRect;
    }

    public void setMarqueeText(String string) {
        this.setMarqueeBytes(string.getBytes());
        this.setHorizontalIndex(666);
    }

    private void setMarqueeBytes(byte[] byArray) {
        this._marqueeBytes = byArray;
    }

    private byte[] getMarqueeBytes() {
        return this._marqueeBytes;
    }

    private void setOriginalBackground(Image image) {
        this._originalBackground = image;
    }

    private Image getOriginalBackground() {
        if (this._originalBackground == null) {
            this._originalBackground = this.createImage(this.getWidth(), this.getHeight());
            this._originalBackground.getGraphics().drawImage(this.getImage(), 0, 0, null);
        }
        return this._originalBackground;
    }

    private void setMarqueeThread(Thread thread) {
        this._marqueeThread = thread;
    }

    private Thread getMarqueeThread() {
        return this._marqueeThread;
    }
}

