/*
 * Decompiled with CFR 0.152.
 */
package com.joot.jigo.replayer;

import com.joot.awt.util.AlertBox;
import com.joot.awt.util.FileDialog;
import com.joot.awt.util.PnutsLayout;
import com.joot.awt.widgets.ImageButton;
import com.joot.awt.widgets.ToolbarPanel;
import com.joot.jigo.BlackStone;
import com.joot.jigo.Goban;
import com.joot.jigo.GobanPanel;
import com.joot.jigo.JiGoApplet;
import com.joot.jigo.Markup;
import com.joot.jigo.Point;
import com.joot.jigo.Rules;
import com.joot.jigo.WhiteStone;
import com.joot.jigo.dataformats.GameLeaf;
import com.joot.jigo.dataformats.GameReader;
import com.joot.jigo.dataformats.GameTree;
import com.joot.jigo.dataformats.GoGame;
import com.joot.jigo.dataformats.sgf.SGFReaderDriver;
import com.joot.jigo.dataformats.tokens.AddBlackToken;
import com.joot.jigo.dataformats.tokens.AddWhiteToken;
import com.joot.jigo.dataformats.tokens.BlackNameToken;
import com.joot.jigo.dataformats.tokens.BlackRankToken;
import com.joot.jigo.dataformats.tokens.CommentToken;
import com.joot.jigo.dataformats.tokens.DateToken;
import com.joot.jigo.dataformats.tokens.EventToken;
import com.joot.jigo.dataformats.tokens.GameToken;
import com.joot.jigo.dataformats.tokens.KomiToken;
import com.joot.jigo.dataformats.tokens.LetterToken;
import com.joot.jigo.dataformats.tokens.MoveToken;
import com.joot.jigo.dataformats.tokens.PlaceToken;
import com.joot.jigo.dataformats.tokens.ResultToken;
import com.joot.jigo.dataformats.tokens.WhiteNameToken;
import com.joot.jigo.dataformats.tokens.WhiteRankToken;
import com.joot.jigo.replayer.InfoPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class ReplayerPanel
extends GobanPanel
implements ActionListener,
KeyListener {
    private static final String IMG_EXT = ".png";
    private static final String TB_DIRECTORY = "images/toolbar/";
    private static final String INFO_PANEL = "images/info-panel.png";
    private static final String PARAM_OPEN_GAME_TITLE = "Open Game Title";
    private static final String PARAM_OPEN_GAME_FILE = "Open Game File";
    private static final String PARAM_OPEN_GAME_ENABLED = "Open Game Enabled";
    private static final String PARAM_OPEN_GAME_FAILED = "Open Game Failed";
    private static final String PARAM_OPEN_GAME_SUPPRESS_ERROR = "Open Game Suppress Error";
    private static final String PARAM_OPEN_GAME_FAILED_TITLE = "Open Game Failed Title";
    private static final String PARAM_ROOT_DIR = "Root Directory";
    private static final String PARAM_EMBED_APPLET = "Embed Applet";
    private static final String PARAM_MARQUEE_TEXT = "Marquee Text";
    private static final char STARTING_LETTER_CHAR = 'a';
    private static final int STARTING_INDEX = 0;
    private static final int OPEN = 1;
    private static final int NEXT = 2;
    private static final int BACK = 3;
    private static final int START = 4;
    private static final int END = 5;
    private static final String OPEN_ENABLED_ICON = "tb-open.png";
    private static final String START_ENABLED_ICON = "tb-start.png";
    private static final String BACK_ENABLED_ICON = "tb-back.png";
    private static final String NEXT_ENABLED_ICON = "tb-next.png";
    private static final String END_ENABLED_ICON = "tb-end.png";
    private static final String OPEN_DISABLED_ICON = "tb-open-disabled.png";
    private static final String START_DISABLED_ICON = "tb-start-disabled.png";
    private static final String END_DISABLED_ICON = "tb-end-disabled.png";
    private static final String NEXT_DISABLED_ICON = "tb-next-disabled.png";
    private static final String BACK_DISABLED_ICON = "tb-back-disabled.png";
    private static final Markup CIRCLE_MARK = new Markup(1);
    private static Point point = new Point();
    private Rules _rules;
    private ToolbarPanel _toolbar;
    private Vector<GameLeaf> myLeaves = new Vector(200, 5);
    private FileDialog fileDialog;
    private int _moveIndex = 0;
    private ImageButton _openButton;
    private ImageButton _startButton;
    private ImageButton _nextButton;
    private ImageButton _backButton;
    private ImageButton _endButton;
    private AddBlackToken _blackStones;
    private AddWhiteToken _whiteStones;
    private InfoPanel _infoPanel;
    private TextArea commentArea;

    public ReplayerPanel(JiGoApplet jiGoApplet) {
        super(jiGoApplet);
        this.setRules(new Rules(this.getGoban()));
        GameReader.registerDriver(new SGFReaderDriver());
    }

    @Override
    protected void initGUI() {
        Image image = null;
        try {
            image = this.loadImage(INFO_PANEL);
            this.setInfoPanel(this.createInfoPanel(image));
            this.setToolbar(this.createToolbarPanel());
            this.initToolbar();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setLayout(new BorderLayout());
        this.add((Component)this.getGoban(), "West");
        Panel panel = new Panel();
        panel.setLayout(new PnutsLayout("cols=1, halign=fill, valign=fill"));
        panel.add(this.getInfoPanel());
        panel.add((Component)this.getCommentArea(), "expand=xy");
        panel.add((Component)this.getToolbar(), "expand=x");
        this.add((Component)panel, "East");
        this.getGoban().addKeyListener(this);
        this.getToolbar().addKeyListener(this);
        this.getInfoPanel().addKeyListener(this);
        this.getCommentArea().addKeyListener(this);
    }

    private void centreGoban() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Rectangle rectangle = this.getBounds();
        rectangle.x = (dimension.width >> 1) - (rectangle.width >> 1);
        rectangle.y = (dimension.height >> 1) - (rectangle.height >> 1);
        this.setBounds(rectangle);
    }

    protected InfoPanel createInfoPanel(Image image) {
        return new InfoPanel(image);
    }

    protected ToolbarPanel createToolbarPanel() {
        return new ToolbarPanel();
    }

    protected boolean shouldHighlight() {
        return false;
    }

    private void initToolbar() throws IOException, MalformedURLException, InterruptedException {
        ToolbarPanel toolbarPanel = this.getToolbar();
        toolbarPanel.setBackground(Color.lightGray);
        if (this.openEnabled()) {
            this._openButton = new ImageButton(this.loadImage("images/toolbar/tb-open.png"), this.loadImage("images/toolbar/tb-open-disabled.png"), Integer.toString(1));
            this._openButton.setEnabled(true);
            toolbarPanel.addButton(this._openButton);
        }
        this._startButton = new ImageButton(this.loadImage("images/toolbar/tb-start.png"), this.loadImage("images/toolbar/tb-start-disabled.png"), Integer.toString(4));
        this._startButton.setEnabled(false);
        toolbarPanel.addButton(this._startButton);
        this._backButton = new ImageButton(this.loadImage("images/toolbar/tb-back.png"), this.loadImage("images/toolbar/tb-back-disabled.png"), Integer.toString(3));
        this._backButton.setEnabled(false);
        toolbarPanel.addButton(this._backButton);
        this._nextButton = new ImageButton(this.loadImage("images/toolbar/tb-next.png"), this.loadImage("images/toolbar/tb-next-disabled.png"), Integer.toString(2));
        this._nextButton.setEnabled(false);
        toolbarPanel.addButton(this._nextButton);
        this._endButton = new ImageButton(this.loadImage("images/toolbar/tb-end.png"), this.loadImage("images/toolbar/tb-end-disabled.png"), Integer.toString(5));
        this._endButton.setEnabled(false);
        toolbarPanel.addButton(this._endButton);
        toolbarPanel.addActionListener(this);
    }

    private void showDefaultCursor() {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private void showWaitCursor() {
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 79: {
                this.openFile();
                break;
            }
            case 38: {
                this.showStart();
                break;
            }
            case 40: {
                this.showEnd();
                break;
            }
            case 37: 
            case 226: {
                this.showPrevMove();
                break;
            }
            case 39: 
            case 227: {
                this.showNextMove();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof ImageButton) {
            switch (Integer.parseInt(actionEvent.getActionCommand())) {
                case 1: {
                    this.openFile();
                    break;
                }
                case 4: {
                    this.showStart();
                    break;
                }
                case 5: {
                    this.showEnd();
                    break;
                }
                case 3: {
                    this.showPrevMove();
                    break;
                }
                case 2: {
                    this.showNextMove();
                }
            }
        } else {
            this.loadGame(actionEvent.getActionCommand());
            this.getGoban().requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGame(String string) {
        Exception exception = null;
        try {
            this.showWaitCursor();
            URL uRL = this.getURL(string);
            InputStream inputStream = uRL.openStream();
            GoGame goGame = GameReader.read(inputStream);
            inputStream.close();
            this.getGoban().removeAllStones();
            this.getGoban().removeAllMarks();
            this.setGoGame(goGame);
            this.hasNextMove(true);
            this.hasPrevMove(false);
            this.getInfoPanel().startMarquee();
        }
        catch (Exception exception2) {
            exception = exception2;
            exception2.printStackTrace();
        }
        finally {
            this.showDefaultCursor();
        }
        if (exception != null && !this.suppressFailure()) {
            this.showError(string, exception);
        }
        this.getCommentArea().setText(null);
    }

    protected void showError(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(this.getErrorText());
        stringBuffer.append(string);
        stringBuffer.append("\n");
        stringBuffer.append(string2);
        AlertBox alertBox = this.createAlertBox(PARAM_OPEN_GAME_FAILED_TITLE, stringBuffer.toString());
        alertBox.setVisible(true);
    }

    protected void showError(String string, Exception exception) {
        this.showError(string, exception.toString());
    }

    protected String getErrorText() {
        return this.getParam(PARAM_OPEN_GAME_FAILED);
    }

    protected AlertBox createAlertBox(String string, String string2) {
        return new AlertBox(new Frame(), this.getParam(string), string2);
    }

    protected boolean openEnabled() {
        return this.getBooleanParam(PARAM_OPEN_GAME_ENABLED, true);
    }

    protected boolean suppressFailure() {
        return this.getBooleanParam(PARAM_OPEN_GAME_SUPPRESS_ERROR, true);
    }

    protected FileDialog createFileDialog() throws IOException {
        return new FileDialog(new Frame(), this.getParam(PARAM_OPEN_GAME_TITLE), this.getURL(this.getParam(PARAM_ROOT_DIR)));
    }

    private void openFile() {
        block3: {
            if (this.openEnabled()) {
                FileDialog fileDialog = null;
                try {
                    fileDialog = this.getFileDialog();
                    fileDialog.setVisible(true);
                }
                catch (IOException iOException) {
                    if (fileDialog == null) break block3;
                    fileDialog.setVisible(false);
                }
            }
        }
    }

    private FileDialog getFileDialog() throws IOException {
        if (this.fileDialog == null) {
            this.fileDialog = this.createFileDialog();
            this.fileDialog.addActionListener(this);
        }
        return this.fileDialog;
    }

    protected void autoLoadGame() {
        String string = this.getParam(PARAM_OPEN_GAME_FILE);
        if (string.length() > 0) {
            this.loadGame(string);
        }
    }

    protected void showNotes() {
        this.showComment();
        this.showMarkup();
    }

    private void showComment() {
        CommentToken commentToken = this.getCommentToken();
        this.setCommentArea(commentToken == null ? "" : commentToken.getComment());
    }

    private void showMarkup() {
        GameLeaf gameLeaf = this.getCurrentLeaf();
        Enumeration enumeration = gameLeaf.getTokens();
        while (enumeration.hasMoreElements()) {
            GameToken gameToken = (GameToken)enumeration.nextElement();
            if (!(gameToken instanceof LetterToken)) continue;
            char c = 'a';
            Enumeration enumeration2 = ((LetterToken)gameToken).getPoints();
            while (enumeration2.hasMoreElements()) {
                Markup markup = new Markup(5);
                markup.setLetter(c);
                Point point = (Point)enumeration2.nextElement();
                this.getGoban().placeMark(markup, point.x - 1, point.y - 1);
                c = (char)(c + '\u0001');
            }
        }
    }

    protected void playMove(MoveToken moveToken) {
        Goban goban = this.getGoban();
        Point point = ReplayerPanel.point;
        point.x = moveToken.getX() - 1;
        point.y = moveToken.getY() - 1;
        goban.placeStone(moveToken.isWhite() ? this.getWhiteStone() : this.getBlackStone(), point);
    }

    public void showNextMove() {
        Goban goban;
        MoveToken moveToken = this.getNextMove();
        if (this.isPlayable(moveToken, (goban = this.getGoban()).getBoardSize())) {
            this.playMove(moveToken);
            this.hasPrevMove(true);
            goban.removeAllMarks();
            this.markCurrentPoint();
        }
        this.hasNextMove(this.getMoveIndex() < this.getLeaves().size());
        this.showNotes();
    }

    private void markCurrentPoint() {
        MoveToken moveToken = this.getCurrentMove();
        CIRCLE_MARK.setColour(moveToken.isWhite() ? Color.black : Color.white);
        this.getGoban().placeMark(CIRCLE_MARK, point);
    }

    public void showStart() {
        this.resetGame();
        this.showNotes();
    }

    private void playMovesTo(int n) {
        Goban goban = this.getGoban();
        goban.setForceRepaint(false);
        InfoPanel infoPanel = this.getInfoPanel();
        this.getRules().deleteObserver(infoPanel);
        int n2 = goban.getBoardSize();
        while (this.getMoveIndex() != n) {
            MoveToken moveToken = this.getNextMove();
            if (!this.isPlayable(moveToken, n2)) continue;
            this.playMove(moveToken);
        }
        goban.setForceRepaint(true);
        goban.removeAllMarks();
        goban.forceRepaint();
        this.getRules().addObserver(infoPanel);
    }

    private boolean isPlayable(MoveToken moveToken, int n) {
        return moveToken != null && !moveToken.isPass(n);
    }

    public void showEnd() {
        this.playMovesTo(this.getLeaves().size());
        this.markCurrentPoint();
        this.hasPrevMove(true);
        this.hasNextMove(false);
        this.showNotes();
    }

    public void showPrevMove() {
        int n = this.getMoveIndex() - 1;
        this.resetGame();
        if (n > 0) {
            this.playMovesTo(n);
            this.markCurrentPoint();
        }
        this.hasPrevMove(n > 0);
        this.showNotes();
        this.showMarkup();
    }

    public void resetGame() {
        this.getGoban().initializeBoard();
        this.setMoveIndex(0);
        this.hasNextMove(true);
        this.hasPrevMove(false);
        this.getRules().resetCaptures();
        this.placeStartingStones();
    }

    private void placeStartingStones() {
        Point point;
        Goban goban = this.getGoban();
        BlackStone blackStone = this.getBlackStone();
        WhiteStone whiteStone = this.getWhiteStone();
        goban.setForceRepaint(false);
        Enumeration enumeration = this.getBlackSetup();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                point = (Point)enumeration.nextElement();
                ReplayerPanel.point.x = point.x - 1;
                ReplayerPanel.point.y = point.y - 1;
                goban.placeStone(blackStone, ReplayerPanel.point);
            }
        }
        if ((enumeration = this.getWhiteSetup()) != null) {
            while (enumeration.hasMoreElements()) {
                point = (Point)enumeration.nextElement();
                ReplayerPanel.point.x = point.x - 1;
                ReplayerPanel.point.y = point.y - 1;
                goban.placeStone(whiteStone, ReplayerPanel.point);
            }
        }
        goban.setForceRepaint(true);
        goban.forceRepaint();
    }

    private void extractMoves(GameTree gameTree) {
        Object object;
        Object object2;
        Enumeration enumeration = gameTree.getTrees();
        Enumeration enumeration2 = gameTree.getLeaves();
        Vector<GameLeaf> vector = this.getLeaves();
        while (enumeration2 != null && enumeration2.hasMoreElements()) {
            object2 = (GameLeaf)enumeration2.nextElement();
            object = ((GameLeaf)object2).getMoveToken();
            if (object == null) continue;
            vector.addElement((GameLeaf)object2);
        }
        if (enumeration != null && enumeration.hasMoreElements()) {
            object2 = (GameTree)enumeration.nextElement();
            object = ((GameTree)object2).getInfoTokens();
            if (object != null) {
                this.extractSetup((Enumeration)object);
            }
            this.extractMoves((GameTree)object2);
        }
    }

    private void extractSetup(Enumeration enumeration) {
        Object object;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        this.getInfoPanel().setResult("  ?");
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (object instanceof AddBlackToken) {
                this.setBlackStones((AddBlackToken)object);
                continue;
            }
            if (object instanceof AddWhiteToken) {
                this.setWhiteStones((AddWhiteToken)object);
                continue;
            }
            if (object instanceof ResultToken) {
                this.getInfoPanel().setResult(object.toString());
                continue;
            }
            if (object instanceof WhiteNameToken) {
                string = object.toString();
                continue;
            }
            if (object instanceof BlackNameToken) {
                string2 = object.toString();
                continue;
            }
            if (object instanceof PlaceToken) {
                string3 = object.toString();
                continue;
            }
            if (object instanceof EventToken) {
                string4 = object.toString();
                continue;
            }
            if (object instanceof DateToken) {
                string8 = object.toString();
                continue;
            }
            if (object instanceof WhiteRankToken) {
                string6 = object.toString();
                continue;
            }
            if (object instanceof BlackRankToken) {
                string5 = object.toString();
                continue;
            }
            if (!(object instanceof KomiToken)) continue;
            string7 = object.toString();
        }
        object = new StringBuffer(100);
        if (string != null) {
            ((StringBuffer)object).append("(W) ");
            ((StringBuffer)object).append(string);
        }
        if (string6 != null) {
            ((StringBuffer)object).append(" ");
            ((StringBuffer)object).append(string6);
        }
        if (string != null && string2 != null) {
            ((StringBuffer)object).append(" vs. ");
        }
        if (string2 != null) {
            ((StringBuffer)object).append("(B) ");
            ((StringBuffer)object).append(string2);
        }
        if (string5 != null) {
            ((StringBuffer)object).append(" ");
            ((StringBuffer)object).append(string5);
        }
        if (string7 != null) {
            ((StringBuffer)object).append(" ... ");
            ((StringBuffer)object).append(" Komi: " + string7);
        }
        if (string3 != null) {
            ((StringBuffer)object).append(" ... ");
            ((StringBuffer)object).append(string3);
        }
        if (string4 != null) {
            ((StringBuffer)object).append(" ... ");
            ((StringBuffer)object).append(string4);
        }
        if (string8 != null) {
            ((StringBuffer)object).append(" ... ");
            ((StringBuffer)object).append(string8);
        }
        ((StringBuffer)object).append(this.getParam(PARAM_MARQUEE_TEXT));
        this.getInfoPanel().setMarqueeText(((StringBuffer)object).toString());
    }

    private void setBlackStones(AddBlackToken addBlackToken) {
        this._blackStones = addBlackToken;
    }

    private void setWhiteStones(AddWhiteToken addWhiteToken) {
        this._whiteStones = addWhiteToken;
    }

    private Enumeration getBlackSetup() {
        return this._blackStones == null ? null : this._blackStones.getPoints();
    }

    private Enumeration getWhiteSetup() {
        return this._whiteStones == null ? null : this._whiteStones.getPoints();
    }

    protected CommentToken getCommentToken() {
        GameLeaf gameLeaf = this.getCurrentLeaf();
        return gameLeaf == null ? null : gameLeaf.getCommentToken();
    }

    private void setGoGame(GoGame goGame) {
        this.getLeaves().setSize(0);
        this.setBlackStones(null);
        this.setWhiteStones(null);
        this.extractMoves(goGame.getTree());
        this.showGameInfo(goGame);
        this.resetGame();
    }

    protected GameLeaf getCurrentLeaf() {
        try {
            return this.getLeaves().elementAt(this.getMoveIndex() - 1);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected final MoveToken getCurrentMove() {
        GameLeaf gameLeaf = this.getCurrentLeaf();
        return gameLeaf == null ? null : gameLeaf.getMoveToken();
    }

    private MoveToken getNextMove() {
        int n = this.getMoveIndex();
        if (n == this.getLeaves().size()) {
            return null;
        }
        this.setMoveIndex(n + 1);
        return this.getCurrentMove();
    }

    protected void showGameInfo(GoGame goGame) {
        InfoPanel infoPanel = this.getInfoPanel();
        this.getRules().deleteObserver(infoPanel);
        this.getRules().addObserver(infoPanel);
    }

    protected void hasNextMove(boolean bl) {
        this._nextButton.setEnabled(bl);
        this._endButton.setEnabled(bl);
    }

    protected void hasPrevMove(boolean bl) {
        this._backButton.setEnabled(bl);
        this._startButton.setEnabled(bl);
    }

    private Vector<GameLeaf> getLeaves() {
        return this.myLeaves;
    }

    private void setMoveIndex(int n) {
        this._moveIndex = n;
    }

    private int getMoveIndex() {
        return this._moveIndex;
    }

    private Rules getRules() {
        return this._rules;
    }

    private void setRules(Rules rules) {
        this._rules = rules;
    }

    private void setToolbar(ToolbarPanel toolbarPanel) {
        this._toolbar = toolbarPanel;
    }

    private ToolbarPanel getToolbar() {
        return this._toolbar;
    }

    private void setInfoPanel(InfoPanel infoPanel) {
        this._infoPanel = infoPanel;
    }

    private InfoPanel getInfoPanel() {
        return this._infoPanel;
    }

    private TextArea getCommentArea() {
        if (this.commentArea == null) {
            this.commentArea = this.createCommentArea();
            this.commentArea.setEditable(false);
        }
        return this.commentArea;
    }

    protected TextArea createCommentArea() {
        return new TextArea("", 12, 15, 1);
    }

    private void setCommentArea(String string) {
        if (!string.equals(this.getCommentArea().getText())) {
            this.getCommentArea().setText(string);
            this.getCommentArea().setCaretPosition(0);
        }
    }

    private URL getURL(String string) throws IOException, MalformedURLException {
        URL uRL = this.getCodeBase();
        return string.startsWith("/") ? new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string) : new URL(uRL, string);
    }

    @Override
    public void paint(Graphics graphics) {
        this.getInfoPanel().repaint();
    }
}

