/*
 * Decompiled with CFR 0.152.
 */
package com.joot.jigo;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class Markup {
    public static final int UNKNOWN = 0;
    public static final int CIRCLE = 1;
    public static final int SQUARE = 2;
    public static final int TRIANGLE = 3;
    public static final int NUMBER = 4;
    public static final int LETTER = 5;
    private int myType = 0;
    private int myNumber;
    private char myLetter;
    private Color myColour = Color.black;

    public Markup(int n) {
        this.setType(n);
    }

    public Markup(int n, Color color) {
        this.setType(n);
        this.setColour(color);
    }

    protected void draw(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n3 >>= 1;
        int n6 = n4 >>= 1;
        int n7 = n + (n5 >> 1) + (n5 & 1);
        int n8 = n2 + (n6 >> 1) + (n6 & 1);
        graphics.setColor(this.getColour());
        switch (this.getType()) {
            case 1: {
                this.drawCircle(graphics, n7, n8, n5, n6);
                break;
            }
            case 2: {
                this.drawSquare(graphics, n7, n8, n5, n6);
                break;
            }
            case 3: {
                this.drawTriangle(graphics, n7, n8 - 2, n5, n6);
                break;
            }
            case 4: {
                this.drawNumber(graphics, n + n3, n2 + n4);
                break;
            }
            case 5: {
                this.drawLetter(graphics, n + n3, n2 + n4);
            }
        }
    }

    private void drawCircle(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawOval(n, n2, n3, n4);
    }

    private void drawSquare(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawRect(n, n2, n3, n4);
    }

    private void drawTriangle(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(n + n3 / 2, n2, n, n2 + n4);
        graphics.drawLine(n + n3 / 2, n2, n + n3, n2 + n4);
        graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
    }

    private void drawLetter(Graphics graphics, int n, int n2) {
        this.drawString(graphics, "" + this.getLetter(), n, n2);
    }

    private void drawNumber(Graphics graphics, int n, int n2) {
        this.drawString(graphics, Integer.toString(this.getNumber()), n, n2);
    }

    private void drawString(Graphics graphics, String string, int n, int n2) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, n - (fontMetrics.stringWidth(string) >> 1), n2 + fontMetrics.getDescent());
    }

    public void setColour(Color color) {
        this.myColour = color;
    }

    private Color getColour() {
        return this.myColour;
    }

    protected int getType() {
        return this.myType;
    }

    public void setType(int n) {
        this.myType = n;
    }

    protected int getNumber() {
        return this.myNumber;
    }

    public void setNumber(int n) {
        this.myNumber = n;
    }

    protected char getLetter() {
        return this.myLetter;
    }

    public void setLetter(char c) {
        this.myLetter = c;
    }

    public String toString() {
        return this.getType() == 5 ? "Letter" : "Circle";
    }

    protected void emptyIntersection() {
        this.setColour(Color.black);
    }

    protected void stone(boolean bl) {
        this.setColour(bl ? Color.black : Color.white);
    }
}

