/*
 * Decompiled with CFR 0.152.
 */
package com.joot.jigo;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

public abstract class Stone {
    public static final int DEFAULT_WIDTH = 20;
    public static final int DEFAULT_HEIGHT = 22;
    private boolean mustDrawImage;
    private Image myImage;
    private static int myWidth = 20;
    private static int myHeight = 22;

    public Stone() {
    }

    public Stone(int n, int n2) {
        this.setWidth(n);
        this.setHeight(n2);
    }

    public Stone(Image image) {
        this.setImage(image);
    }

    public void draw(Graphics graphics, int n, int n2) {
        if (this.mustDrawImage()) {
            graphics.drawImage(this.getImage(), n, n2, null);
        } else {
            if (this.isWhite()) {
                graphics.setColor(Color.white);
                graphics.fillOval(n, n2, this.getWidth(), this.getHeight());
            }
            graphics.setColor(Color.black);
            if (this.isWhite()) {
                graphics.drawOval(n, n2, this.getWidth(), this.getHeight());
            } else {
                graphics.fillOval(n, n2, this.getWidth(), this.getHeight());
            }
        }
    }

    public abstract boolean isWhite();

    protected int getWidth() {
        return myWidth;
    }

    protected void setWidth(int n) {
        if ((n & 1) == 1) {
            --n;
        }
        myWidth = n;
    }

    protected int getHeight() {
        return myHeight;
    }

    protected void setHeight(int n) {
        if ((n & 1) == 1) {
            --n;
        }
        myHeight = n;
    }

    private Image getImage() {
        return this.myImage;
    }

    public void setImage(Image image) {
        if (image == null) {
            this.setDrawImage(false);
        } else {
            this.myImage = image;
            this.setWidth(this.myImage.getWidth(null));
            this.setHeight(this.myImage.getHeight(null));
            this.setDrawImage(true);
        }
    }

    public boolean equals(Stone stone) {
        return this.isWhite() && stone.isWhite() || !this.isWhite() && !stone.isWhite();
    }

    public void toggleDrawImage() {
        this.setDrawImage(!this.mustDrawImage());
    }

    private boolean mustDrawImage() {
        return this.mustDrawImage;
    }

    private void setDrawImage(boolean bl) {
        this.mustDrawImage = bl;
    }
}

