/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileContentInfo;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.FileContentThreadData;
import org.apache.commons.vfs2.util.MonitorInputStream;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.MonitorRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultFileContent
implements FileContent {
    static final int STATE_CLOSED = 0;
    static final int STATE_OPENED = 1;
    private final AbstractFileObject fileObject;
    private Map<String, Object> attrs;
    private Map<String, Object> roAttrs;
    private FileContentInfo fileContentInfo;
    private final FileContentInfoFactory fileContentInfoFactory;
    private final ThreadLocal<FileContentThreadData> threadData = new ThreadLocal();
    private boolean resetAttributes;
    private int openStreams;

    public DefaultFileContent(AbstractFileObject file2, FileContentInfoFactory fileContentInfoFactory) {
        this.fileObject = file2;
        this.fileContentInfoFactory = fileContentInfoFactory;
    }

    private FileContentThreadData getThreadData() {
        FileContentThreadData data = this.threadData.get();
        if (data == null) {
            data = new FileContentThreadData();
            this.threadData.set(data);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamOpened() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            ++this.openStreams;
        }
        ((AbstractFileSystem)this.fileObject.getFileSystem()).streamOpened();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            if (this.openStreams > 0) {
                --this.openStreams;
                if (this.openStreams < 1) {
                    this.fileObject.notifyAllStreamsClosed();
                }
            }
        }
        ((AbstractFileSystem)this.fileObject.getFileSystem()).streamClosed();
    }

    @Override
    public FileObject getFile() {
        return this.fileObject;
    }

    @Override
    public long getSize() throws FileSystemException {
        if (!this.fileObject.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/get-size-not-file.error", this.fileObject);
        }
        try {
            return this.fileObject.doGetContentSize();
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider/get-size.error", new Object[]{this.fileObject}, (Throwable)exc);
        }
    }

    @Override
    public long getLastModifiedTime() throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-last-modified-no-exist.error", this.fileObject);
        }
        try {
            return this.fileObject.doGetLastModifiedTime();
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-last-modified.error", this.fileObject, (Throwable)e);
        }
    }

    @Override
    public void setLastModifiedTime(long modTime) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-last-modified-no-exist.error", this.fileObject);
        }
        try {
            if (!this.fileObject.doSetLastModifiedTime(modTime)) {
                throw new FileSystemException("vfs.provider/set-last-modified.error", this.fileObject);
            }
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/set-last-modified.error", this.fileObject, (Throwable)e);
        }
    }

    @Override
    public boolean hasAttribute(String attrName) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/exists-attributes-no-exist.error", this.fileObject);
        }
        this.getAttributes();
        return this.attrs.containsKey(attrName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getAttributes() throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/get-attributes-no-exist.error", this.fileObject);
        }
        if (this.resetAttributes || this.roAttrs == null) {
            try {
                DefaultFileContent defaultFileContent = this;
                synchronized (defaultFileContent) {
                    this.attrs = this.fileObject.doGetAttributes();
                    this.roAttrs = Collections.unmodifiableMap(this.attrs);
                    this.resetAttributes = false;
                }
            }
            catch (Exception e) {
                throw new FileSystemException("vfs.provider/get-attributes.error", this.fileObject, (Throwable)e);
            }
        }
        return this.roAttrs;
    }

    public void resetAttributes() {
        this.resetAttributes = true;
    }

    @Override
    public String[] getAttributeNames() throws FileSystemException {
        this.getAttributes();
        Set<String> names2 = this.attrs.keySet();
        return names2.toArray(new String[names2.size()]);
    }

    @Override
    public Object getAttribute(String attrName) throws FileSystemException {
        this.getAttributes();
        return this.attrs.get(attrName);
    }

    @Override
    public void setAttribute(String attrName, Object value) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/set-attribute-no-exist.error", new Object[]{attrName, this.fileObject});
        }
        try {
            this.fileObject.doSetAttribute(attrName, value);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/set-attribute.error", new Object[]{attrName, this.fileObject}, (Throwable)e);
        }
        if (this.attrs != null) {
            this.attrs.put(attrName, value);
        }
    }

    @Override
    public void removeAttribute(String attrName) throws FileSystemException {
        if (!this.fileObject.getType().hasAttributes()) {
            throw new FileSystemException("vfs.provider/remove-attribute-no-exist.error", this.fileObject);
        }
        try {
            this.fileObject.doRemoveAttribute(attrName);
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/remove-attribute.error", new Object[]{attrName, this.fileObject}, (Throwable)e);
        }
        if (this.attrs != null) {
            this.attrs.remove(attrName);
        }
    }

    @Override
    public Certificate[] getCertificates() throws FileSystemException {
        if (!this.fileObject.exists()) {
            throw new FileSystemException("vfs.provider/get-certificates-no-exist.error", this.fileObject);
        }
        try {
            Certificate[] certs = this.fileObject.doGetCertificates();
            if (certs != null) {
                return certs;
            }
            return new Certificate[0];
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider/get-certificates.error", this.fileObject, (Throwable)e);
        }
    }

    @Override
    public InputStream getInputStream() throws FileSystemException {
        InputStream instr = this.fileObject.getInputStream();
        FileContentInputStream wrappedInstr = new FileContentInputStream(this.fileObject, instr);
        this.getThreadData().addInstr(wrappedInstr);
        this.streamOpened();
        return wrappedInstr;
    }

    @Override
    public RandomAccessContent getRandomAccessContent(RandomAccessMode mode) throws FileSystemException {
        RandomAccessContent rastr = this.fileObject.getRandomAccessContent(mode);
        FileRandomAccessContent rac = new FileRandomAccessContent(this.fileObject, rastr);
        this.getThreadData().addRastr(rac);
        this.streamOpened();
        return rac;
    }

    @Override
    public OutputStream getOutputStream() throws FileSystemException {
        return this.getOutputStream(false);
    }

    @Override
    public OutputStream getOutputStream(boolean bAppend) throws FileSystemException {
        if (this.getThreadData().getOutstr() != null) {
            throw new FileSystemException("vfs.provider/write-in-use.error", this.fileObject);
        }
        OutputStream outstr = this.fileObject.getOutputStream(bAppend);
        this.getThreadData().setOutstr(new FileContentOutputStream(this.fileObject, outstr));
        this.streamOpened();
        return this.getThreadData().getOutstr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws FileSystemException {
        try {
            while (this.getThreadData().getInstrsSize() > 0) {
                FileContentInputStream instr = (FileContentInputStream)this.getThreadData().removeInstr(0);
                instr.close();
            }
            while (this.getThreadData().getRastrsSize() > 0) {
                RandomAccessContent ra = (RandomAccessContent)this.getThreadData().removeRastr(0);
                try {
                    ra.close();
                }
                catch (IOException e) {
                    throw new FileSystemException(e);
                }
            }
            if (this.getThreadData().getOutstr() != null) {
                this.getThreadData().closeOutstr();
            }
        }
        finally {
            this.threadData.set(null);
        }
    }

    private void endInput(FileContentInputStream instr) {
        this.getThreadData().removeInstr(instr);
        this.streamClosed();
    }

    private void endRandomAccess(RandomAccessContent rac) {
        this.getThreadData().removeRastr(rac);
        this.streamClosed();
    }

    private void endOutput() throws Exception {
        this.streamClosed();
        this.getThreadData().setOutstr(null);
        this.fileObject.endOutput();
    }

    @Override
    public boolean isOpen() {
        return this.getThreadData().hasStreams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpenGlobal() {
        DefaultFileContent defaultFileContent = this;
        synchronized (defaultFileContent) {
            return this.openStreams > 0;
        }
    }

    @Override
    public FileContentInfo getContentInfo() throws FileSystemException {
        if (this.fileContentInfo == null) {
            this.fileContentInfo = this.fileContentInfoFactory.create(this);
        }
        return this.fileContentInfo;
    }

    final class FileContentOutputStream
    extends MonitorOutputStream {
        private final FileObject file;

        FileContentOutputStream(FileObject file2, OutputStream outstr) {
            super(outstr);
            this.file = file2;
        }

        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-outstr.error", this.file, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                try {
                    DefaultFileContent.this.endOutput();
                }
                catch (Exception e) {
                    throw new FileSystemException("vfs.provider/close-outstr.error", this.file, (Throwable)e);
                }
            }
        }
    }

    private final class FileRandomAccessContent
    extends MonitorRandomAccessContent {
        private final FileObject file;
        private final RandomAccessContent content;

        FileRandomAccessContent(FileObject file2, RandomAccessContent content) {
            super(content);
            this.file = file2;
            this.content = content;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endRandomAccess(this);
            }
        }
    }

    private final class FileContentInputStream
    extends MonitorInputStream {
        private final FileObject file;

        FileContentInputStream(FileObject file2, InputStream instr) {
            super(instr);
            this.file = file2;
        }

        public void close() throws FileSystemException {
            try {
                super.close();
            }
            catch (IOException e) {
                throw new FileSystemException("vfs.provider/close-instr.error", this.file, (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onClose() throws IOException {
            try {
                super.onClose();
            }
            finally {
                DefaultFileContent.this.endInput(this);
            }
        }
    }
}

