/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.compressed;

import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.compressed.CompressedFileFileSystem;

public abstract class CompressedFileFileObject
extends AbstractFileObject
implements FileObject {
    private final FileObject container;
    private final String[] children;

    protected CompressedFileFileObject(AbstractFileName name, FileObject container, CompressedFileFileSystem fs) {
        super(name, fs);
        this.container = container;
        String basename2 = container.getName().getBaseName();
        int pos = basename2.lastIndexOf(46);
        basename2 = basename2.substring(0, pos);
        this.children = new String[]{basename2};
    }

    public boolean isWriteable() throws FileSystemException {
        return this.getFileSystem().hasCapability(Capability.WRITE_CONTENT);
    }

    protected FileType doGetType() throws FileSystemException {
        if (this.getName().getPath().endsWith("/")) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    protected String[] doListChildren() {
        return this.children;
    }

    protected long doGetContentSize() {
        return -1L;
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.container.getContent().getLastModifiedTime();
    }

    protected FileObject getContainer() {
        return this.container;
    }

    public void createFile() throws FileSystemException {
        this.container.createFile();
        this.injectType(FileType.FILE);
    }
}

