/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.jar;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.jar.JarFileObject;

public class JarURLConnectionImpl
extends JarURLConnection {
    private static final String HACK_URL = "jar:http://somehost/somejar.jar!/";
    private final FileContent content;
    private final URL parentURL;
    private final JarFileObject file;
    private final String entryName;

    public JarURLConnectionImpl(JarFileObject file2, FileContent content) throws MalformedURLException, FileSystemException {
        super(new URL(HACK_URL));
        this.url = file2.getURL();
        this.content = content;
        this.parentURL = file2.getURL();
        this.entryName = file2.getName().getPath();
        this.file = file2;
    }

    public URL getJarFileURL() {
        return this.parentURL;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public JarFile getJarFile() throws IOException {
        throw new FileSystemException("vfs.provider.jar/jar-file-no-access.error");
    }

    public Manifest getManifest() throws IOException {
        return this.file.getManifest();
    }

    public JarEntry getJarEntry() throws IOException {
        throw new FileSystemException("vfs.provider.jar/jar-entry-no-access.error");
    }

    public Attributes getAttributes() throws IOException {
        return this.file.getAttributes();
    }

    public Certificate[] getCertificates() {
        return this.file.doGetCertificates();
    }

    public void connect() {
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        return this.content.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.content.getOutputStream();
    }

    public int getContentLength() {
        try {
            return (int)this.content.getSize();
        }
        catch (FileSystemException fileSystemException) {
            return -1;
        }
    }
}

