/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.functions;

import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.Constant;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.SimpleExpression;
import org.renjin.compiler.ir.tac.expressions.Temp;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.TranslationContext;
import org.renjin.compiler.ir.tac.statements.Assignment;
import org.renjin.compiler.ir.tac.statements.GotoStatement;
import org.renjin.compiler.ir.tac.statements.IfStatement;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.SEXP;

public class IfTranslator
extends FunctionCallTranslator {
    @Override
    public Expression translateToExpression(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall call2) {
        SimpleExpression condition = builder.translateSimpleExpression(context, (SEXP)call2.getArgument(0));
        Temp ifResult = builder.newTemp();
        IRLabel trueTarget = builder.newLabel();
        IRLabel falseTarget = builder.newLabel();
        IRLabel endLabel = builder.newLabel();
        IfStatement jump = new IfStatement(condition, trueTarget, falseTarget);
        builder.addStatement(jump);
        builder.addLabel(trueTarget);
        Expression ifTrueResult = builder.translateExpression(context, (SEXP)call2.getArgument(1));
        builder.addStatement(new Assignment(ifResult, ifTrueResult));
        builder.addStatement(new GotoStatement(endLabel));
        builder.addLabel(falseTarget);
        SimpleExpression ifFalseResult = this.hasElse(call2) ? builder.translateSimpleExpression(context, (SEXP)call2.getArgument(2)) : Constant.NULL;
        builder.addStatement(new Assignment(ifResult, ifFalseResult));
        builder.addLabel(endLabel);
        return ifResult;
    }

    private boolean hasElse(FunctionCall call2) {
        return call2.getArguments().length() == 3;
    }

    @Override
    public void addStatement(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall call2) {
        SimpleExpression condition = builder.translateSimpleExpression(context, (SEXP)call2.getArgument(0));
        IRLabel trueLabel = builder.newLabel();
        IRLabel falseLabel = builder.newLabel();
        IRLabel endLabel = this.hasElse(call2) ? builder.newLabel() : falseLabel;
        IfStatement jump = new IfStatement(condition, trueLabel, falseLabel);
        builder.addStatement(jump);
        builder.addLabel(trueLabel);
        builder.translateStatements(context, (SEXP)call2.getArgument(1));
        if (this.hasElse(call2)) {
            builder.addStatement(new GotoStatement(endLabel));
            builder.addLabel(falseLabel);
            builder.translateStatements(context, (SEXP)call2.getArgument(2));
        }
        builder.addLabel(endLabel);
    }
}

