/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.functions;

import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.IRLabel;
import org.renjin.compiler.ir.tac.expressions.Constant;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.LoopContext;
import org.renjin.compiler.ir.tac.functions.TranslationContext;
import org.renjin.compiler.ir.tac.statements.GotoStatement;
import org.renjin.compiler.ir.tac.statements.IfStatement;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.SEXP;

public class WhileTranslator
extends FunctionCallTranslator {
    @Override
    public Expression translateToExpression(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall call2) {
        this.addLoop(builder, context, call2);
        return Constant.NULL;
    }

    @Override
    public void addStatement(IRBodyBuilder builder, TranslationContext context, Function resolvedFunction, FunctionCall call2) {
        this.addLoop(builder, context, call2);
    }

    private void addLoop(IRBodyBuilder factory, TranslationContext context, FunctionCall call2) {
        Object condition = call2.getArgument(0);
        Object body2 = call2.getArgument(1);
        IRLabel checkLabel = factory.newLabel();
        IRLabel bodyLabel = factory.newLabel();
        IRLabel exitLabel = factory.newLabel();
        factory.addLabel(checkLabel);
        factory.addStatement(new IfStatement(factory.translateSimpleExpression(context, (SEXP)condition), bodyLabel, exitLabel));
        factory.addLabel(bodyLabel);
        LoopContext loopContext = new LoopContext(context, checkLabel, exitLabel);
        factory.translateStatements(loopContext, (SEXP)body2);
        factory.addStatement(new GotoStatement(checkLabel));
        factory.addLabel(exitLabel);
    }
}

