/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.pipeline.accessor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.renjin.compiler.pipeline.ComputeMethod;
import org.renjin.compiler.pipeline.DeferredNode;
import org.renjin.compiler.pipeline.accessor.Accessor;
import org.renjin.compiler.pipeline.accessor.Accessors;
import org.renjin.compiler.pipeline.accessor.InputGraph;
import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.repackaged.asm.AnnotationVisitor;
import org.renjin.repackaged.asm.ClassReader;
import org.renjin.repackaged.asm.ClassVisitor;
import org.renjin.repackaged.asm.FieldVisitor;
import org.renjin.repackaged.asm.MethodVisitor;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Maps;

public class ComputationAccessor
extends Accessor {
    private DeferredComputation computation;
    private List<Accessor> operands = Lists.newArrayList();
    private Map<String, Accessor> fieldMap = Maps.newHashMap();

    public ComputationAccessor(DeferredNode node, InputGraph inputGraph) {
        this.computation = node.getComputation();
        for (DeferredNode operand : node.getOperands()) {
            this.operands.add(Accessors.create(operand, inputGraph));
        }
        this.visitComputationClass(new FieldMapper());
    }

    @Override
    public void init(ComputeMethod method) {
        for (Accessor operand : this.operands) {
            operand.init(method);
        }
    }

    @Override
    public void pushLength(ComputeMethod method) {
        this.transformMethod(method, "length", Lists.newArrayList());
    }

    @Override
    public void pushDouble(ComputeMethod method) {
        throw new UnsupportedOperationException();
    }

    private void transformMethod(ComputeMethod method, String methodToRewrite, ArrayList<Integer> parameters) {
        this.visitComputationClass(new Transformer(method, methodToRewrite, parameters));
    }

    private void visitComputationClass(ClassVisitor classVisitor) {
        try {
            ClassReader reader = new ClassReader(this.computation.getClass().getName());
            reader.accept(classVisitor, 0);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception transforming class", e);
        }
    }

    private class MethodRewriter
    extends MethodVisitor {
        private ComputeMethod method;
        private ArrayList<Integer> parameters;
        private Map<Integer, Integer> localVariableMapping;

        public MethodRewriter(ComputeMethod method, ArrayList<Integer> parameters) {
            super(262144, method.getVisitor());
            this.localVariableMapping = Maps.newHashMap();
            this.method = method;
            this.parameters = parameters;
        }

        @Override
        public void visitVarInsn(int opcode, int var) {
            this.mv.visitVarInsn(opcode, this.mapLocalVariableIndex(var, opcode));
        }

        private int mapLocalVariableIndex(int var, int opcode) {
            if (var < this.parameters.size()) {
                return this.parameters.get(var);
            }
            Integer mappedLocal = this.localVariableMapping.get(var);
            if (mappedLocal == null) {
                mappedLocal = this.method.reserveLocal(this.localSize(opcode));
            }
            return mappedLocal;
        }

        private int localSize(int opcode) {
            if (opcode == 24 || opcode == 57) {
                return 2;
            }
            return 1;
        }

        @Override
        public void visitInsn(int opcode) {
            switch (opcode) {
                case 172: 
                case 175: {
                    break;
                }
                default: {
                    this.mv.visitInsn(opcode);
                }
            }
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (!ComputationAccessor.this.fieldMap.containsKey(name)) {
                throw new RuntimeException("Can't translate code because of field reference:" + name);
            }
        }
    }

    private class Transformer
    extends ClassVisitor {
        private ComputeMethod method;
        private String methodToRewrite;
        private ArrayList<Integer> parameters;

        private Transformer(ComputeMethod method, String methodToRewrite, ArrayList<Integer> parameters) {
            super(262144);
            this.method = method;
            this.methodToRewrite = methodToRewrite;
            this.parameters = parameters;
        }

        @Override
        public MethodVisitor visitMethod(int access2, String name, String desc, String signature, String[] exceptions) {
            if (name.endsWith(this.methodToRewrite)) {
                return new MethodRewriter(this.method, this.parameters);
            }
            return null;
        }
    }

    private class FieldMapper
    extends ClassVisitor {
        public FieldMapper() {
            super(262144);
        }

        @Override
        public FieldVisitor visitField(int access2, final String name, String desc, String signature, Object value) {
            return new FieldVisitor(262144){

                @Override
                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    if (desc.equals("Lorg/renjin/primitives/annotations/Operand;")) {
                        ComputationAccessor.this.fieldMap.put(name, ComputationAccessor.this.operands.get(0));
                    }
                    return super.visitAnnotation(desc, visible);
                }
            };
        }
    }
}

