/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.eval.vfs;

import java.io.InputStream;
import java.util.jar.JarEntry;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.renjin.eval.vfs.FastJarFileSystem;

public class FastJarFileObject
extends AbstractFileObject
implements FileObject {
    private final FastJarFileSystem fs;
    protected JarEntry entry;
    private FileType type;

    protected FastJarFileObject(AbstractFileName name, JarEntry entry, FastJarFileSystem fs) throws FileSystemException {
        super(name, fs);
        this.fs = fs;
        this.setZipEntry(entry);
    }

    protected void setZipEntry(JarEntry entry) {
        if (this.entry != null) {
            return;
        }
        this.type = entry == null || entry.isDirectory() ? FileType.FOLDER : FileType.FILE;
        this.entry = entry;
    }

    @Override
    public boolean isWriteable() throws FileSystemException {
        return false;
    }

    @Override
    protected FileType doGetType() {
        return this.type;
    }

    @Override
    protected String[] doListChildren() {
        return this.fs.listChildren(this.entry.getName());
    }

    @Override
    protected long doGetContentSize() {
        return this.entry.getSize();
    }

    @Override
    protected long doGetLastModifiedTime() throws Exception {
        return this.entry.getTime();
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        return this.fs.getInputStream(this.entry);
    }
}

