/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.invoke.reflection.AbstractOverload;
import org.renjin.invoke.reflection.ExceptionUtil;
import org.renjin.invoke.reflection.converters.Converter;
import org.renjin.invoke.reflection.converters.Converters;
import org.renjin.repackaged.guava.collect.Iterables;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;

public class FunctionBinding {
    private List<Overload> overloads = Lists.newArrayList();
    private int maxArgCount;

    public FunctionBinding(Iterable<Method> overloads) {
        for (Method method : overloads) {
            this.addOverload(method);
        }
        AbstractOverload.sortOverloads(this.overloads);
    }

    public Class getDeclaringClass() {
        return Iterables.get(this.overloads, 0).getDeclaringClass();
    }

    public List<Overload> getOverloads() {
        return this.overloads;
    }

    public String getName() {
        return Iterables.get(this.overloads, 0).getName();
    }

    private void addOverload(Method method) {
        Overload overload = new Overload(method);
        if (overload.getArgCount() > this.maxArgCount) {
            this.maxArgCount = overload.getArgCount();
        }
        this.overloads.add(overload);
    }

    public SEXP evaluateArgsAndInvoke(Object instance, Context context, Environment rho, PairList arguments) {
        ArrayList<SEXP> args2 = Lists.newArrayListWithCapacity(this.maxArgCount);
        ArgumentIterator it = new ArgumentIterator(context, rho, arguments);
        while (it.hasNext()) {
            args2.add(context.evaluate(it.next(), rho));
        }
        return this.invoke(instance, context, args2);
    }

    public SEXP invoke(Object instance, Context context, ListVector evaluatedArguments) {
        ArrayList<SEXP> args2 = Lists.newArrayList(evaluatedArguments);
        return this.invoke(instance, context, args2);
    }

    private SEXP invoke(Object instance, Context context, List<SEXP> args2) {
        for (Overload overload : this.overloads) {
            if (!overload.accept(args2)) continue;
            return overload.invoke(context, instance, args2);
        }
        throw new EvalException("Cannot match arguments (%s) to any JVM method overload:\n%s", ExceptionUtil.toString(args2), ExceptionUtil.overloadListToString(this.overloads));
    }

    public String toString() {
        return this.getName();
    }

    public static class Overload
    extends AbstractOverload {
        private Method method;
        private Converter returnValueConverter;

        public Overload(Method method) {
            super(method.getParameterTypes(), method.getParameterAnnotations(), method.isVarArgs());
            this.method = method;
            this.returnValueConverter = Converters.get(method.getReturnType());
            if (!Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
                try {
                    this.method.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
        }

        public Class getDeclaringClass() {
            return this.method.getDeclaringClass();
        }

        public String getName() {
            return this.method.getName();
        }

        public SEXP invoke(Context context, Object instance, List<SEXP> args2) {
            Object[] converted = this.convertArguments(context, args2);
            try {
                Object result = this.method.invoke(instance, converted);
                return this.returnValueConverter.convertToR(result);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Exception invoking " + this.method, e);
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.method.toString();
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

