/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.IntPtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.bessel_j;
import org.renjin.nmath.cospi;

public class bessel_y {
    public static double[] $Y_bessel$ch = new double[21];
    public static double $Y_bessel$pim5;
    public static double $Y_bessel$fivpi;

    private bessel_y() {
    }

    public static void Y_bessel(DoublePtr doublePtr, DoublePtr doublePtr2, IntPtr intPtr, DoublePtr doublePtr3, IntPtr intPtr2) {
        double[] x$array = doublePtr.array;
        int x$offset = doublePtr.offset;
        double[] alpha$array = doublePtr2.array;
        int alpha$offset = doublePtr2.offset;
        int[] nb$array = intPtr.array;
        int nb$offset = intPtr.offset;
        double[] by$array = doublePtr3.array;
        int by$offset = doublePtr3.offset;
        int[] ncalc$array = intPtr2.array;
        int ncalc$offset = intPtr2.offset;
        double x2 = 0.0;
        double dmu = 0.0;
        double den = 0.0;
        double twobyx = 0.0;
        double ya1 = 0.0;
        double ya = 0.0;
        double ex = 0.0;
        double nu = 0.0;
        double q0 = 0.0;
        double s = 0.0;
        double r = 0.0;
        double e = 0.0;
        double d = 0.0;
        double c2 = 0.0;
        double b = 0.0;
        double sinmu = 0.0;
        double cosmu = 0.0;
        double ddiv = 0.0;
        int na2 = 0;
        int k = 0;
        double en1 = ya = (ya1 = 0.0);
        ex = x$array[x$offset];
        nu = alpha$array[alpha$offset];
        if (nb$array[nb$offset] > 0 && nu >= 0.0 && nu < 1.0) {
            if (ex < Double.MIN_NORMAL || ex > 1.0E8) {
                int n;
                ncalc$array[ncalc$offset] = n = nb$array[nb$offset];
                if (ex > 1.0E8) {
                    by$array[by$offset] = 0.0;
                } else if (ex < Double.MIN_NORMAL) {
                    double d2;
                    by$array[by$offset] = d2 = -1.0 / 0.0;
                }
                int i = 0;
                while (nb$array[nb$offset] > i) {
                    double d3;
                    int n2 = i * 8;
                    double[] dArray = by$array;
                    int n3 = by$offset + n2 / 8;
                    dArray[n3] = d3 = by$array[by$offset];
                    ++i;
                }
            } else {
                double h;
                double q;
                double g;
                double aye;
                int i;
                double en;
                double f;
                double p;
                double xna = Mathlib.trunc(nu + 0.5);
                na2 = (int)xna;
                if (na2 == 1) {
                    nu -= xna;
                }
                if (nu == -0.5) {
                    double d4 = Mathlib.sqrt(ex);
                    p = 0.7978845608028654 / d4;
                    ya = Mathlib.sin(ex) * p;
                    double d5 = -p;
                    double d6 = Mathlib.cos(ex);
                    ya1 = d5 * d6;
                } else if (ex < 3.0) {
                    double d7;
                    double d8;
                    double d9;
                    double d10;
                    b = ex * 0.5;
                    d = -Math.log(b);
                    f = nu * d;
                    double d11 = -nu;
                    e = Mathlib.pow(b, d11);
                    if (Math.abs(nu) < 2.149E-8) {
                        c2 = 0.3183098861837907;
                    } else {
                        double d12 = cospi.sinpi(nu);
                        c2 = nu / d12;
                    }
                    if (Math.abs(f) < 1.0) {
                        double d13 = f;
                        x2 = d13 * d13;
                        en = 19.0;
                        s = 1.0;
                        i = 1;
                        while (i <= 9) {
                            double d14 = s * x2 / en;
                            double d15 = en - 1.0;
                            s = d14 / d15 + 1.0;
                            en -= 2.0;
                            ++i;
                        }
                    } else {
                        double d16 = 1.0 / e;
                        s = (e - d16) * 0.5 / f;
                    }
                    double d17 = nu;
                    x2 = d17 * d17 * 8.0;
                    aye = $Y_bessel$ch[0];
                    double even = 0.0;
                    double alfa = $Y_bessel$ch[1];
                    double odd = 0.0;
                    i = 3;
                    while (i <= 19) {
                        even = -(aye * 2.0 + even);
                        double d18 = -even * x2 - aye;
                        int n = i + -1;
                        double d19 = $Y_bessel$ch[0 + n];
                        aye = d18 + d19;
                        odd = -(alfa * 2.0 + odd);
                        double d20 = -odd * x2 - alfa;
                        double d21 = $Y_bessel$ch[0 + i];
                        alfa = d20 + d21;
                        i += 2;
                    }
                    double d22 = (even * 0.5 + aye) * x2 - aye;
                    double d23 = $Y_bessel$ch[20];
                    even = d22 + d23;
                    odd = (odd + alfa) * 2.0;
                    double gamma2 = odd * nu + even;
                    g = e * gamma2;
                    e = (1.0 / e + e) * 0.5;
                    double d24 = c2 * 2.0;
                    double d25 = odd * e;
                    double d26 = even * s * d;
                    double d27 = d25 + d26;
                    f = d24 * d27;
                    double d28 = nu;
                    e = d28 * d28;
                    p = g * c2;
                    q = 0.3183098861837907 / g;
                    c2 = nu * 1.5707963267948966;
                    r = Math.abs(c2) < 2.149E-8 ? 1.0 : cospi.sinpi(nu / 2.0) / c2;
                    r = c2 * Math.PI * r * r;
                    c2 = 1.0;
                    d = -b * b;
                    h = 0.0;
                    ya = r * q + f;
                    ya1 = p;
                    en = 1.0;
                    while ((d10 = Math.abs(g / (d9 = Math.abs(ya) + 1.0))) + (d8 = Math.abs(h / (d7 = Math.abs(ya1) + 1.0))) > 2.220446049250313E-16) {
                        double d29 = f * en + p + q;
                        double d30 = en;
                        double d31 = d30 * d30 - e;
                        f = d29 / d31;
                        c2 = d / en * c2;
                        double d32 = en - nu;
                        double d33 = en + nu;
                        g = (r * (q /= d33) + f) * c2;
                        double d34 = c2 * (p /= d32);
                        double d35 = en * g;
                        h = d34 - d35;
                        ya += g;
                        ya1 += h;
                        en += 1.0;
                    }
                    ya = -ya;
                    ya1 = -ya1 / b;
                } else if (ex < 16.0) {
                    double d36 = 0.5 - nu;
                    double d37 = nu + 0.5;
                    c2 = d36 * d37;
                    b = ex * 2.0;
                    double d38 = ex * 0.3183098861837907;
                    double d39 = cospi.cospi(nu);
                    double d40 = e = d38 * d39 / 2.220446049250313E-16;
                    e = d40 * d40;
                    p = 1.0;
                    q = -ex;
                    double d41 = ex;
                    s = r = d41 * d41 + 1.0;
                    en = 2.0;
                    while (r * en * en < e) {
                        en1 = en + 1.0;
                        double d42 = en - 1.0;
                        double d43 = c2 / en;
                        d = (d42 + d43) / s;
                        double d44 = en * 2.0;
                        double d45 = p * d;
                        p = (d44 - d45) / en1;
                        q = (q * d - b) / en1;
                        double d46 = p;
                        double d47 = d46 * d46;
                        double d48 = q;
                        double d49 = d48 * d48;
                        s = d47 + d49;
                        r *= s;
                        en = en1;
                    }
                    p = f = p / s;
                    q = g = -q / s;
                    while ((en -= 1.0) > 0.0) {
                        r = (2.0 - p) * en1 - 2.0;
                        s = en1 * q + b;
                        double d50 = en - 1.0;
                        double d51 = c2 / en;
                        double d52 = d50 + d51;
                        double d53 = r;
                        double d54 = d53 * d53;
                        double d55 = s;
                        double d56 = d55 * d55;
                        double d57 = d54 + d56;
                        d = d52 / d57;
                        p = d * r;
                        q = d * s;
                        e = f + 1.0;
                        double d58 = p * e;
                        double d59 = g * q;
                        f = d58 - d59;
                        double d60 = q * e;
                        double d61 = p * g;
                        g = d60 + d61;
                        en1 = en;
                    }
                    double d62 = f += 1.0;
                    double d63 = d62 * d62;
                    double d64 = g;
                    double d65 = d64 * d64;
                    d = d63 + d65;
                    double pa = f / d;
                    double qa = -g / d;
                    d = nu + 0.5 - p;
                    double d66 = pa * (q += ex);
                    double d67 = qa * d;
                    double pa1 = (d66 - d67) / ex;
                    double d68 = qa * q;
                    double d69 = pa * d;
                    double qa1 = (d68 + d69) / ex;
                    double d70 = (nu + 0.5) * 1.5707963267948966;
                    b = ex - d70;
                    c2 = Mathlib.cos(b);
                    s = Mathlib.sin(b);
                    double d71 = Mathlib.sqrt(ex);
                    d = 0.7978845608028654 / d71;
                    double d72 = pa * s;
                    double d73 = qa * c2;
                    ya = (d72 + d73) * d;
                    double d74 = qa1 * s;
                    double d75 = pa1 * c2;
                    ya1 = (d74 - d75) * d;
                } else {
                    na2 = 0;
                    double fivpi$1 = $Y_bessel$fivpi;
                    double d1 = Mathlib.trunc(ex / fivpi$1);
                    i = (int)d1;
                    double d76 = d1 * 15.0;
                    double d77 = ex - d76;
                    double pim5$2 = $Y_bessel$pim5;
                    double d78 = d1 * pim5$2;
                    double d79 = d77 - d78;
                    double d80 = (alpha$array[alpha$offset] + 0.5) * 1.5707963267948966;
                    dmu = d79 - d80;
                    if (i / 2 << 1 == i) {
                        cosmu = Mathlib.cos(dmu);
                        sinmu = Mathlib.sin(dmu);
                    } else {
                        cosmu = -Mathlib.cos(dmu);
                        sinmu = -Mathlib.sin(dmu);
                    }
                    ddiv = ex * 8.0;
                    dmu = alpha$array[alpha$offset];
                    den = Mathlib.sqrt(ex);
                    k = 1;
                    while (k <= 2) {
                        p = cosmu;
                        cosmu = sinmu;
                        sinmu = -p;
                        double d81 = dmu * 2.0 - 1.0;
                        double d82 = dmu * 2.0 + 1.0;
                        d1 = d81 * d82;
                        double d2 = 0.0;
                        double div2 = ddiv;
                        p = 0.0;
                        q = 0.0;
                        double term = q0 = d1 / div2;
                        i = 2;
                        while (i <= 20) {
                            term = -term * (d1 -= (d2 += 8.0)) / (div2 += ddiv);
                            p += term;
                            term = (d1 -= (d2 += 8.0)) / (div2 += ddiv) * term;
                            q += term;
                            if (Math.abs(term) <= 2.220446049250313E-16) break;
                            ++i;
                        }
                        p += 1.0;
                        q += q0;
                        if (k == 1) {
                            double d83 = p * cosmu;
                            double d84 = q * sinmu;
                            ya = (d83 - d84) * 0.7978845608028654 / den;
                        } else {
                            double d85 = p * cosmu;
                            double d86 = q * sinmu;
                            ya1 = (d85 - d86) * 0.7978845608028654 / den;
                        }
                        dmu += 1.0;
                        ++k;
                    }
                }
                if (na2 == 1) {
                    double d87;
                    double d88;
                    h = (nu + 1.0) * 2.0 / ex;
                    if (h > 1.0 && (d88 = Math.abs(ya1)) > (d87 = Double.MAX_VALUE / h)) {
                        h = 0.0;
                        ya = 0.0;
                    }
                    h = h * ya1 - ya;
                    ya = ya1;
                    ya1 = h;
                }
                by$array[by$offset] = ya;
                ncalc$array[ncalc$offset] = 1;
                if (nb$array[nb$offset] > 1) {
                    double[] dArray = by$array;
                    int n = by$offset + 1;
                    dArray[n] = ya1;
                    if (ya1 != 0.0) {
                        aye = alpha$array[alpha$offset] + 1.0;
                        twobyx = 2.0 / ex;
                        ncalc$array[ncalc$offset] = 2;
                        i = 2;
                        while (nb$array[nb$offset] > i) {
                            int n4;
                            double d89;
                            double d90;
                            int n5;
                            int n6;
                            double[] dArray2;
                            double d91;
                            double d92;
                            int n7;
                            int n8;
                            double[] dArray3;
                            double d93;
                            if (!(twobyx < 1.0 ? !((d93 = Math.abs((dArray3 = by$array)[n8 = by$offset + (n7 = (i + -1) * 8) / 8]) * twobyx) >= (d92 = Double.MAX_VALUE / aye)) : !((d91 = Math.abs((dArray2 = by$array)[n6 = by$offset + (n5 = (i + -1) * 8) / 8])) >= (d90 = Double.MAX_VALUE / aye / twobyx)))) break;
                            int n9 = i * 8;
                            double[] dArray4 = by$array;
                            int n10 = by$offset + n9 / 8;
                            double d94 = twobyx * aye;
                            int n11 = (i + -1) * 8;
                            double[] dArray5 = by$array;
                            int n12 = by$offset + n11 / 8;
                            double d95 = dArray5[n12];
                            double d96 = d94 * d95;
                            int n13 = (i + -2) * 8;
                            double[] dArray6 = by$array;
                            int n14 = by$offset + n13 / 8;
                            double d97 = dArray6[n14];
                            dArray4[n10] = d89 = d96 - d97;
                            aye += 1.0;
                            ncalc$array[ncalc$offset] = n4 = ncalc$array[ncalc$offset] + 1;
                            ++i;
                        }
                    }
                }
                i = ncalc$array[ncalc$offset];
                while (nb$array[nb$offset] > i) {
                    double d98;
                    int n = i * 8;
                    double[] dArray = by$array;
                    int n15 = by$offset + n / 8;
                    dArray[n15] = d98 = -1.0 / 0.0;
                    ++i;
                }
            }
        } else {
            int n;
            by$array[by$offset] = 0.0;
            ncalc$array[ncalc$offset] = n = Math.min(nb$array[nb$offset], 0) + -1;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double bessel_y_ex(double d, double d2, DoublePtr doublePtr) {
        double x$45;
        double alpha$31;
        int nb$28;
        double[] by$array = doublePtr.array;
        int by$offset = doublePtr.offset;
        double[] x = new double[]{d};
        double[] alpha = new double[]{d2};
        int[] ncalc = new int[1];
        int[] nb = new int[1];
        ncalc[0] = 0;
        if (Builtins.__isnan(x[0]) != 0 || Builtins.__isnan(alpha[0]) != 0) {
            double x$11 = x[0];
            double alpha$12 = alpha[0];
            return x$11 + alpha$12;
        }
        if (x[0] < 0.0) {
            byte[] msg = "\u0000".getBytes();
            int msg$offset = 0;
            msg = "value out of range in '%s'\n\u0000".getBytes();
            msg$offset = 0;
            Stdlib.printf(new BytePtr(msg, msg$offset), new BytePtr("bessel_y\u0000".getBytes(), 0));
            return 0.0 / 0.0;
        }
        double na2 = Mathlib.floor(alpha[0]);
        if (alpha[0] < 0.0) {
            double iftmp$21;
            double iftmp$16;
            if (alpha[0] - na2 != 0.5) {
                double d3 = -alpha[0];
                double d4 = bessel_y.bessel_y_ex(x[0], d3, new DoublePtr(by$array, by$offset));
                double d5 = cospi.cospi(alpha[0]);
                iftmp$16 = d4 * d5;
            } else {
                iftmp$16 = 0.0;
            }
            if (alpha[0] != na2) {
                double d6 = -alpha[0];
                double d7 = bessel_j.bessel_j_ex(x[0], d6, new DoublePtr(by$array, by$offset));
                double d8 = cospi.sinpi(alpha[0]);
                iftmp$21 = d7 * d8;
                return iftmp$16 - iftmp$21;
            } else {
                iftmp$21 = 0.0;
            }
            return iftmp$16 - iftmp$21;
        }
        if (alpha[0] > 1.0E7) {
            double alpha$27 = alpha[0];
            Stdlib.printf(new BytePtr("besselY(x, nu): nu=%g too large for bessel_y() algorithm\u0000".getBytes(), 0), alpha$27);
            return 0.0 / 0.0;
        }
        nb[0] = nb$28 = (int)na2 + 1;
        double alpha$29 = alpha[0];
        double d9 = nb[0] + -1;
        alpha[0] = alpha$31 = alpha$29 - d9;
        bessel_y.Y_bessel(new DoublePtr(x, 0), new DoublePtr(alpha, 0), new IntPtr(nb, 0), new DoublePtr(by$array, by$offset), new IntPtr(ncalc, 0));
        int ncalc$32 = ncalc[0];
        int nb$33 = nb[0];
        if (ncalc$32 != nb$33) {
            if (ncalc[0] == -1) return 1.0 / 0.0;
            if (ncalc[0] < -1) {
                double alpha$36 = alpha[0];
                int nb$37 = nb[0];
                int ncalc$38 = ncalc[0];
                double x$39 = x[0];
                Stdlib.printf(new BytePtr("bessel_y(%g): ncalc (=%d) != nb (=%d); alpha=%g. Arg. out of range?\n\u0000".getBytes(), 0), x$39, ncalc$38, nb$37, alpha$36);
            } else {
                double d10 = nb[0];
                double alpha$41 = alpha[0];
                double d11 = d10 + alpha$41 - 1.0;
                double x$42 = x[0];
                Stdlib.printf(new BytePtr("bessel_y(%g,nu=%g): precision lost in result\n\u0000".getBytes(), 0), x$42, d11);
            }
        }
        int n = (nb[0] + -1) * 8;
        double[] dArray = by$array;
        int n2 = by$offset + n / 8;
        x[0] = x$45 = dArray[n2];
        return x[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double bessel_y(double d, double d2) {
        double x$84;
        double alpha$68;
        int nb$65;
        double[] x = new double[]{d};
        double[] alpha = new double[]{d2};
        int[] ncalc = new int[1];
        int[] nb = new int[1];
        ncalc[0] = 0;
        if (Builtins.__isnan(x[0]) != 0 || Builtins.__isnan(alpha[0]) != 0) {
            double x$48 = x[0];
            double alpha$49 = alpha[0];
            return x$48 + alpha$49;
        }
        if (x[0] < 0.0) {
            byte[] msg = "\u0000".getBytes();
            int msg$offset = 0;
            msg = "value out of range in '%s'\n\u0000".getBytes();
            msg$offset = 0;
            Stdlib.printf(new BytePtr(msg, msg$offset), new BytePtr("bessel_y\u0000".getBytes(), 0));
            return 0.0 / 0.0;
        }
        double na2 = Mathlib.floor(alpha[0]);
        if (alpha[0] < 0.0) {
            double iftmp$58;
            double iftmp$53;
            if (alpha[0] - na2 != 0.5) {
                double d3 = -alpha[0];
                double d4 = bessel_y.bessel_y(x[0], d3);
                double d5 = cospi.cospi(alpha[0]);
                iftmp$53 = d4 * d5;
            } else {
                iftmp$53 = 0.0;
            }
            if (alpha[0] != na2) {
                double d6 = -alpha[0];
                double d7 = bessel_j.bessel_j(x[0], d6);
                double d8 = cospi.sinpi(alpha[0]);
                iftmp$58 = d7 * d8;
                return iftmp$53 - iftmp$58;
            } else {
                iftmp$58 = 0.0;
            }
            return iftmp$53 - iftmp$58;
        }
        if (alpha[0] > 1.0E7) {
            double alpha$64 = alpha[0];
            Stdlib.printf(new BytePtr("besselY(x, nu): nu=%g too large for bessel_y() algorithm\u0000".getBytes(), 0), alpha$64);
            return 0.0 / 0.0;
        }
        nb[0] = nb$65 = (int)na2 + 1;
        double alpha$66 = alpha[0];
        double d9 = nb[0] + -1;
        alpha[0] = alpha$68 = alpha$66 - d9;
        double[] by = new double[Math.max(nb[0] * 8 / 8, 1)];
        int by$offset = 0;
        bessel_y.Y_bessel(new DoublePtr(x, 0), new DoublePtr(alpha, 0), new IntPtr(nb, 0), new DoublePtr(by, by$offset), new IntPtr(ncalc, 0));
        int ncalc$71 = ncalc[0];
        int nb$72 = nb[0];
        if (ncalc$71 != nb$72) {
            if (ncalc[0] == -1) return 1.0 / 0.0;
            if (ncalc[0] < -1) {
                double alpha$75 = alpha[0];
                int nb$76 = nb[0];
                int ncalc$77 = ncalc[0];
                double x$78 = x[0];
                Stdlib.printf(new BytePtr("bessel_y(%g): ncalc (=%d) != nb (=%d); alpha=%g. Arg. out of range?\n\u0000".getBytes(), 0), x$78, ncalc$77, nb$76, alpha$75);
            } else {
                double d10 = nb[0];
                double alpha$80 = alpha[0];
                double d11 = d10 + alpha$80 - 1.0;
                double x$81 = x[0];
                Stdlib.printf(new BytePtr("bessel_y(%g,nu=%g): precision lost in result\n\u0000".getBytes(), 0), x$81, d11);
            }
        }
        int n = (nb[0] + -1) * 8;
        double[] dArray = by;
        int n2 = by$offset + n / 8;
        x[0] = x$84 = dArray[n2];
        return x[0];
    }

    static {
        System.arraycopy(new double[]{-6.773524182239884E-24, -6.145518011604988E-23, 2.9017595056104746E-21, 1.36394179190731E-19, 2.3826220476859634E-18, -9.064290795755071E-18, -1.4943667065169001E-15, -3.391907830536221E-14, -1.702377664251273E-13, 9.160975093876865E-12, 2.42309579004827E-10, 1.7451364971382985E-9, -3.3126119768180853E-8, -8.659207996139126E-7, -4.9717367041957395E-6, 7.630959758590813E-5, 0.0012719271366545622, 0.0017063050710955563, -0.07685284084478668, -0.28387654227602355, 0.9218702936504527}, 0, $Y_bessel$ch, 0, 21);
        $Y_bessel$pim5 = 0.7079632679489662;
        $Y_bessel$fivpi = Math.PI * 5;
    }
}

