/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.choose;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.fmin2;

public class qhyper {
    private qhyper() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qhyper(double d, double d2, double d3, double d4, int n, int n2) {
        boolean small_N = false;
        double xend = 0.0;
        if (Builtins.__isnan(d) != 0) return d + d2 + d3 + d4;
        if (Builtins.__isnan(d2) != 0) return d + d2 + d3 + d4;
        if (Builtins.__isnan(d3) != 0) return d + d2 + d3 + d4;
        if (Builtins.__isnan(d4) != 0) return d + d2 + d3 + d4;
        if (Builtins.__finite(d) == 0) return 0.0 / 0.0;
        if (Builtins.__finite(d2) == 0) return 0.0 / 0.0;
        if (Builtins.__finite(d3) == 0) return 0.0 / 0.0;
        if (Builtins.__finite(d4) == 0) return 0.0 / 0.0;
        d2 = Mathlib.round(d2);
        d3 = Mathlib.round(d3);
        double N = d2 + d3;
        d4 = Mathlib.round(d4);
        if (d2 < 0.0) return 0.0 / 0.0;
        if (d3 < 0.0) return 0.0 / 0.0;
        if (d4 < 0.0) return 0.0 / 0.0;
        if (d4 > N) return 0.0 / 0.0;
        double d5 = d4 - d3;
        double xstart = fmax2.fmax2(0.0, d5);
        xend = fmin2.fmin2(d4, d2);
        if (n2 != 0) {
            if (d > 0.0) return 0.0 / 0.0;
            if (d == 0.0) {
                double iftmp$0 = n != 0 ? xend : xstart;
                return iftmp$0;
            }
            double d6 = -1.0 / 0.0;
            if (d == d6) {
                double iftmp$1 = n != 0 ? xstart : xend;
                return iftmp$1;
            }
        } else {
            if (d < 0.0) return 0.0 / 0.0;
            if (d > 1.0) return 0.0 / 0.0;
            if (d == 0.0) {
                double iftmp$2 = n != 0 ? xstart : xend;
                return iftmp$2;
            }
            if (d == 1.0) {
                double iftmp$3 = n != 0 ? xend : xstart;
                return iftmp$3;
            }
        }
        double xr = xstart;
        double xb = d4 - xr;
        small_N = N < 1000.0;
        double d7 = choose.Rf_lfastchoose(d2, xr);
        double d8 = choose.Rf_lfastchoose(d3, xb);
        double d9 = d7 + d8;
        double d10 = choose.Rf_lfastchoose(N, d4);
        double term = d9 - d10;
        if (small_N) {
            term = Math.exp(term);
        }
        d2 -= xr;
        d3 -= xb;
        if (n == 0 || n2 != 0) {
            double iftmp$4;
            if (n2 != 0) {
                double iftmp$5 = n != 0 ? Math.exp(d) : -Mathlib.expm1(d);
                iftmp$4 = iftmp$5;
            } else {
                double iftmp$6 = n == 0 ? 0.5 - d + 0.5 : d;
                iftmp$4 = iftmp$6;
            }
            d = iftmp$4;
        }
        d *= 0.999999999999778;
        double iftmp$7 = !small_N ? Math.exp(term) : term;
        double sum2 = iftmp$7;
        while (sum2 < d && xr < xend) {
            xr += 1.0;
            d3 += 1.0;
            if (small_N) {
                double d11 = d2 / xr;
                double d12 = xb / d3;
                term = d11 * d12 * term;
            } else {
                double d13 = d2 / xr;
                double d14 = xb / d3;
                term = Math.log(d13 * d14) + term;
            }
            double iftmp$8 = !small_N ? Math.exp(term) : term;
            sum2 = iftmp$8 + sum2;
            xb -= 1.0;
            d2 -= 1.0;
        }
        return xr;
    }
}

