/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.renjin.base.internals.AllNamesVisitor;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.graphics.internals.Graphics;
import org.renjin.graphics.internals.Par;
import org.renjin.graphics.internals.Plot;
import org.renjin.graphics.internals.RgbHsv;
import org.renjin.invoke.codegen.WrapperGenerator2;
import org.renjin.methods.Methods;
import org.renjin.primitives.Args;
import org.renjin.primitives.Attributes;
import org.renjin.primitives.Bitwise;
import org.renjin.primitives.Comparison;
import org.renjin.primitives.ComplexGroup;
import org.renjin.primitives.Conditions;
import org.renjin.primitives.Contexts;
import org.renjin.primitives.Deparse;
import org.renjin.primitives.Environments;
import org.renjin.primitives.Evaluation;
import org.renjin.primitives.Identical;
import org.renjin.primitives.Jvmi;
import org.renjin.primitives.MathGroup;
import org.renjin.primitives.Native;
import org.renjin.primitives.Ops;
import org.renjin.primitives.Print;
import org.renjin.primitives.S3;
import org.renjin.primitives.Scan;
import org.renjin.primitives.Sessions;
import org.renjin.primitives.Sort;
import org.renjin.primitives.Special;
import org.renjin.primitives.Split;
import org.renjin.primitives.Summary;
import org.renjin.primitives.System;
import org.renjin.primitives.Types;
import org.renjin.primitives.Vectors;
import org.renjin.primitives.Warning;
import org.renjin.primitives.combine.ColumnBindFunction;
import org.renjin.primitives.combine.Combine;
import org.renjin.primitives.combine.RowBindFunction;
import org.renjin.primitives.files.Files;
import org.renjin.primitives.io.Cat;
import org.renjin.primitives.io.DebianControlFiles;
import org.renjin.primitives.io.connections.Connections;
import org.renjin.primitives.io.serialization.Serialization;
import org.renjin.primitives.match.Duplicates;
import org.renjin.primitives.match.Match;
import org.renjin.primitives.matrix.Matrices;
import org.renjin.primitives.packaging.Namespaces;
import org.renjin.primitives.packaging.Packages;
import org.renjin.primitives.sequence.RepFunction;
import org.renjin.primitives.sequence.Sequences;
import org.renjin.primitives.special.AssignFunction;
import org.renjin.primitives.special.AssignLeftFunction;
import org.renjin.primitives.special.AssignSlotFunction;
import org.renjin.primitives.special.BeginFunction;
import org.renjin.primitives.special.BreakFunction;
import org.renjin.primitives.special.CallFunction;
import org.renjin.primitives.special.ClosureFunction;
import org.renjin.primitives.special.DollarFunction;
import org.renjin.primitives.special.ExpressionFunction;
import org.renjin.primitives.special.ForFunction;
import org.renjin.primitives.special.IfFunction;
import org.renjin.primitives.special.InternalFunction;
import org.renjin.primitives.special.NextFunction;
import org.renjin.primitives.special.OnExitFunction;
import org.renjin.primitives.special.ParenFunction;
import org.renjin.primitives.special.QuoteFunction;
import org.renjin.primitives.special.ReassignLeftFunction;
import org.renjin.primitives.special.RecallFunction;
import org.renjin.primitives.special.RepeatFunction;
import org.renjin.primitives.special.RestartFunction;
import org.renjin.primitives.special.ReturnFunction;
import org.renjin.primitives.special.SubstituteFunction;
import org.renjin.primitives.special.SwitchFunction;
import org.renjin.primitives.special.TildeFunction;
import org.renjin.primitives.special.WhileFunction;
import org.renjin.primitives.subset.Subsetting;
import org.renjin.primitives.text.Text;
import org.renjin.primitives.time.Time;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.repackaged.guava.collect.Sets;
import org.renjin.sexp.BuiltinFunction;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.Symbol;
import org.renjin.stats.internals.CompleteCases;
import org.renjin.stats.internals.Distributions;
import org.renjin.stats.internals.distributions.RNG;
import org.renjin.stats.internals.distributions.Sampling;
import org.renjin.stats.internals.models.Models;
import org.renjin.stats.internals.optimize.Optimizations;
import org.renjin.stats.internals.optimize.Roots;

public class Primitives {
    private IdentityHashMap<Symbol, PrimitiveFunction> reserved = new IdentityHashMap();
    private ConcurrentHashMap<Symbol, PrimitiveFunction> builtins = new ConcurrentHashMap();
    private ConcurrentHashMap<Symbol, PrimitiveFunction> internals = new ConcurrentHashMap();
    private IdentityHashMap<Symbol, Entry> builtinEntries = new IdentityHashMap();
    private IdentityHashMap<Symbol, Entry> internalEntries = new IdentityHashMap();
    private static final Primitives INSTANCE = new Primitives();

    public static PrimitiveFunction getBuiltin(String name) {
        return Primitives.getBuiltin(Symbol.get(name));
    }

    public static PrimitiveFunction getReservedBuiltin(Symbol symbol2) {
        assert (symbol2.isReservedWord());
        PrimitiveFunction fn = Primitives.INSTANCE.reserved.get(symbol2);
        assert (fn != null) : "missing reserved: " + symbol2;
        return fn;
    }

    public static PrimitiveFunction getBuiltin(Symbol symbol2) {
        return Primitives.getPrimitive(Primitives.INSTANCE.builtinEntries, Primitives.INSTANCE.builtins, symbol2);
    }

    public static PrimitiveFunction getInternal(Symbol symbol2) {
        return Primitives.getPrimitive(Primitives.INSTANCE.internalEntries, Primitives.INSTANCE.internals, symbol2);
    }

    private static PrimitiveFunction getPrimitive(IdentityHashMap<Symbol, Entry> entryMap, ConcurrentHashMap<Symbol, PrimitiveFunction> cache, Symbol symbol2) {
        PrimitiveFunction existing = cache.get(symbol2);
        if (existing != null) {
            return existing;
        }
        Entry entry = entryMap.get(symbol2);
        if (entry == null) {
            return null;
        }
        PrimitiveFunction newFunction = Primitives.createFunction(entry);
        existing = cache.putIfAbsent(symbol2, newFunction);
        if (existing != null) {
            return existing;
        }
        return newFunction;
    }

    public static List<Entry> getEntries() {
        ArrayList<Entry> set2 = Lists.newArrayList();
        set2.addAll(Primitives.INSTANCE.internalEntries.values());
        set2.addAll(Primitives.INSTANCE.builtinEntries.values());
        return set2;
    }

    public static Entry getBuiltinEntry(Symbol name) {
        return Primitives.INSTANCE.builtinEntries.get(name);
    }

    public static Entry getInternalEntry(Symbol name) {
        return Primitives.INSTANCE.internalEntries.get(name);
    }

    public static Entry getBuiltinEntry(String name) {
        return Primitives.getBuiltinEntry(Symbol.get(name));
    }

    public static Set<Symbol> getBuiltinSymbols() {
        return Sets.union(Primitives.INSTANCE.builtins.keySet(), Primitives.INSTANCE.builtinEntries.keySet());
    }

    private static PrimitiveFunction createFunction(final Entry entry) {
        try {
            return (PrimitiveFunction)Class.forName(WrapperGenerator2.toFullJavaName(entry.name)).newInstance();
        }
        catch (Exception e) {
            return new BuiltinFunction(entry.name){

                @Override
                public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList args2) {
                    throw new EvalException("Sorry! " + entry.name + " not yet implemented!", e);
                }
            };
        }
    }

    public Primitives() {
        this.add(new IfFunction());
        this.add(new WhileFunction());
        this.add(new ForFunction());
        this.add(new RepeatFunction());
        this.add(new BreakFunction());
        this.add(new NextFunction());
        this.add(new ReturnFunction());
        this.f("stop", Conditions.class, 11);
        this.f("warning", Warning.class, 111);
        this.f("gettext", Text.class, 11);
        this.f("ngettext", Text.class, 11);
        this.f("bindtextdomain", Text.class, 11);
        this.f("enc2utf8", Text.class, 1);
        this.f(".addCondHands", Conditions.class, 111);
        this.f(".resetCondHands", null, 111);
        this.f(".signalCondition", Conditions.class, 11);
        this.f(".dfltStop", Conditions.class, 11);
        this.f(".dfltWarn", null, 11);
        this.f(".addRestart", Conditions.class, 11);
        this.f(".getRestart", null, 11);
        this.f(".invokeRestart", null, 11);
        this.f(".addTryHandlers", null, 111);
        this.f("geterrmessage", Conditions.class, 11);
        this.f("seterrmessage", Conditions.class, 111);
        this.f("printDeferredWarnings", Warning.class, 111);
        this.f("interruptsSuspended", null, 11);
        this.addInternal("restart", new RestartFunction());
        this.add(new ClosureFunction());
        this.f("as.function.default", Types.class, 11);
        this.add(new AssignLeftFunction());
        this.add(new AssignFunction());
        this.add(new ReassignLeftFunction());
        this.add(new BeginFunction());
        this.add(new ParenFunction());
        this.add(new AssignSlotFunction());
        this.f(".subset", Subsetting.class, 1);
        this.f(".subset2", Subsetting.class, 1);
        this.f("[", Subsetting.class, -1);
        this.f("[[", Subsetting.class, -1);
        this.add(new DollarFunction());
        this.f("@", Subsetting.class, 2);
        this.f("[<-", Subsetting.class, 3);
        this.f("[[<-", Subsetting.class, 3);
        this.f("$<-", Subsetting.class, 3);
        this.add(new SwitchFunction());
        this.f("browser", null, 101);
        this.f("debug", null, 111);
        this.f("undebug", null, 111);
        this.f("isdebugged", null, 11);
        this.f("debugonce", null, 111);
        this.f(".primTrace", null, 101);
        this.f(".primUntrace", null, 101);
        this.add(new InternalFunction());
        this.add(new OnExitFunction());
        this.addInternal("Recall", new RecallFunction());
        this.f("delayedAssign", Evaluation.class, 111);
        this.f("makeLazy", Serialization.class, 111);
        this.f(".Primitive", Evaluation.class, 1);
        this.f("identical", Identical.class, 11);
        this.f("+", Ops.class, 2);
        this.f("-", Ops.class, 2);
        this.f("*", Ops.class, 2);
        this.f("/", Ops.class, 2);
        this.f("^", Ops.class, 2);
        this.f("%%", Ops.class, 2);
        this.f("%/%", Ops.class, 2);
        this.f("%*%", Matrices.class, 2);
        this.f("crossprod", Matrices.class, 11);
        this.f("tcrossprod", Matrices.class, 11);
        this.f("==", Ops.class, 2);
        this.f("!=", Ops.class, 2);
        this.f("<", Ops.class, 2);
        this.f("<=", Ops.class, 2);
        this.f(">=", Ops.class, 2);
        this.f(">", Ops.class, 2);
        this.f("&", Ops.class, 2);
        this.f("|", Ops.class, 2);
        this.f("!", Ops.class, 1);
        this.f("&&", Comparison.class, "and", 0);
        this.f("||", Comparison.class, "or", 0);
        this.f(":", Sequences.class, "colon", 1);
        this.add(new TildeFunction());
        this.f("all", Summary.class, 1);
        this.f("any", Summary.class, 1);
        this.f("vector", Vectors.class, 11);
        this.f("complex", Vectors.class, 11);
        this.f("matrix", Matrices.class, 11);
        this.f("length", Vectors.class, 1);
        this.f("length<-", Vectors.class, 2);
        this.f("row", Matrices.class, 11);
        this.f("col", Matrices.class, 11);
        this.f("c", Combine.class, 1);
        this.f("unlist", Combine.class, 11);
        this.addInternal("cbind", new ColumnBindFunction());
        this.addInternal("rbind", new RowBindFunction());
        this.f("drop", Vectors.class, 11);
        this.f("oldClass", Attributes.class, 1);
        this.f("oldClass<-", Attributes.class, 2);
        this.f("class", Attributes.class, "getClass", 1);
        this.f(".cache_class", Methods.class, 2);
        this.f("class<-", Attributes.class, "setClass", 1);
        this.f("unclass", Attributes.class, 1);
        this.f("names", Attributes.class, "getNames", 1);
        this.f("names<-", Attributes.class, "setNames", 1);
        this.f("dimnames", Attributes.class, 1);
        this.f("dimnames<-", Attributes.class, 2);
        this.f("all.names", AllNamesVisitor.class, 11);
        this.f("dim", Attributes.class, 1);
        this.f("dim<-", Attributes.class, 2);
        this.f("attributes", Attributes.class, 1);
        this.f("attributes<-", Attributes.class, null, 1);
        this.f("attr", Attributes.class, 1);
        this.f("attr<-", Attributes.class, 3);
        this.f("comment", Attributes.class, 11);
        this.f("comment<-", Attributes.class, 2);
        this.f("levels<-", Attributes.class, 2);
        this.f("get", Environments.class, 11);
        this.f("get0", Environments.class, 11);
        this.f("mget", Environments.class, 11);
        this.f("exists", Environments.class, 11);
        this.f("assign", Evaluation.class, 111);
        this.f("list2env", Environments.class, 11);
        this.f("remove", Evaluation.class, 111);
        this.f("duplicated", Duplicates.class, 11);
        this.f("unique", Duplicates.class, 11);
        this.f("anyDuplicated", Duplicates.class, 11);
        this.f("which.min", Sort.class, 11);
        this.f("which", Match.class, 11);
        this.f("pmin", Summary.class, 11);
        this.f("pmax", Summary.class, 11);
        this.f("which.max", Sort.class, 11);
        this.f("match", Match.class, 11);
        this.f("pmatch", Match.class, 11);
        this.f("charmatch", Match.class, 11);
        this.f("match.call", Match.class, 11);
        this.f("complete.cases", CompleteCases.class, 11);
        this.f("attach", Environments.class, 111);
        this.f("detach", Environments.class, 111);
        this.f("search", Environments.class, 11);
        this.f("round", MathGroup.class, 0);
        this.f("signif", MathGroup.class, 0);
        this.f("atan", MathGroup.class, 1);
        this.f("log", MathGroup.class, 0);
        this.f("log10", MathGroup.class, 1);
        this.f("log2", MathGroup.class, 1);
        this.f("abs", MathGroup.class, 1);
        this.f("floor", MathGroup.class, 1);
        this.f("ceiling", MathGroup.class, 1);
        this.f("sqrt", MathGroup.class, 1);
        this.f("sign", MathGroup.class, 1);
        this.f("trunc", MathGroup.class, 1);
        this.f("exp", MathGroup.class, 1);
        this.f("expm1", MathGroup.class, 1);
        this.f("log1p", MathGroup.class, 1);
        this.f("cos", MathGroup.class, 1);
        this.f("sin", MathGroup.class, 1);
        this.f("tan", MathGroup.class, 1);
        this.f("acos", MathGroup.class, 1);
        this.f("asin", MathGroup.class, 1);
        this.f("cosh", MathGroup.class, 1);
        this.f("sinh", MathGroup.class, 1);
        this.f("tanh", MathGroup.class, 1);
        this.f("acosh", MathGroup.class, 1);
        this.f("asinh", MathGroup.class, 1);
        this.f("atanh", MathGroup.class, 1);
        this.f("lgamma", MathGroup.class, 1);
        this.f("gamma", MathGroup.class, 1);
        this.f("digamma", MathGroup.class, 1);
        this.f("trigamma", MathGroup.class, 1);
        this.f("cospi", MathGroup.class, 1);
        this.f("sinpi", MathGroup.class, 1);
        this.f("tanpi", MathGroup.class, 1);
        this.f("atan2", MathGroup.class, 11);
        this.f("lbeta", Special.class, 11);
        this.f("beta", Special.class, 11);
        this.f("lchoose", Special.class, 11);
        this.f("choose", Special.class, 11);
        this.f("dchisq", Distributions.class, 11);
        this.f("pchisq", Distributions.class, 11);
        this.f("qchisq", Distributions.class, 11);
        this.f("dexp", Distributions.class, 11);
        this.f("pexp", Distributions.class, 11);
        this.f("qexp", Distributions.class, 11);
        this.f("dgeom", Distributions.class, 11);
        this.f("pgeom", Distributions.class, 11);
        this.f("qgeom", Distributions.class, 11);
        this.f("dpois", Distributions.class, 11);
        this.f("ppois", Distributions.class, 11);
        this.f("qpois", null, 11);
        this.f("dt", Distributions.class, 11);
        this.f("pt", Distributions.class, 11);
        this.f("qt", Distributions.class, 11);
        this.f("dsignrank", Distributions.class, 11);
        this.f("psignrank", Distributions.class, 11);
        this.f("qsignrank", Distributions.class, 11);
        this.f("besselJ", Special.class, 11);
        this.f("besselY", Special.class, 11);
        this.f("psigamma", Special.class, 11);
        this.f("Re", ComplexGroup.class, 1);
        this.f("Im", ComplexGroup.class, 1);
        this.f("Mod", ComplexGroup.class, 1);
        this.f("Arg", ComplexGroup.class, 1);
        this.f("Conj", ComplexGroup.class, 1);
        this.f("dbeta", Distributions.class, 11);
        this.f("pbeta", Distributions.class, 11);
        this.f("qbeta", Distributions.class, 11);
        this.f("dbinom", Distributions.class, 11);
        this.f("pbinom", Distributions.class, 11);
        this.f("qbinom", Distributions.class, 11);
        this.f("dcauchy", Distributions.class, 11);
        this.f("pcauchy", Distributions.class, 11);
        this.f("qcauchy", Distributions.class, 11);
        this.f("df", Distributions.class, 11);
        this.f("pf", Distributions.class, 11);
        this.f("qf", Distributions.class, 11);
        this.f("dgamma", Distributions.class, 11);
        this.f("pgamma", Distributions.class, 11);
        this.f("qgamma", Distributions.class, 11);
        this.f("dlnorm", Distributions.class, 11);
        this.f("plnorm", Distributions.class, 11);
        this.f("qlnorm", Distributions.class, 11);
        this.f("dlogis", Distributions.class, 11);
        this.f("plogis", Distributions.class, 11);
        this.f("qlogis", Distributions.class, 11);
        this.f("dnbinom", Distributions.class, 11);
        this.f("pnbinom", Distributions.class, 11);
        this.f("qnbinom", Distributions.class, 11);
        this.f("dnorm", Distributions.class, 11);
        this.f("pnorm", Distributions.class, 11);
        this.f("qnorm", Distributions.class, 11);
        this.f("dunif", Distributions.class, 11);
        this.f("punif", Distributions.class, 11);
        this.f("qunif", Distributions.class, 11);
        this.f("dweibull", Distributions.class, 11);
        this.f("pweibull", Distributions.class, 11);
        this.f("qweibull", Distributions.class, 11);
        this.f("dnchisq", Distributions.class, 11);
        this.f("pnchisq", Distributions.class, 11);
        this.f("qnchisq", Distributions.class, 11);
        this.f("dnt", Distributions.class, 11);
        this.f("pnt", Distributions.class, 11);
        this.f("qnt", Distributions.class, 11);
        this.f("dwilcox", Distributions.class, 11);
        this.f("pwilcox", Distributions.class, 11);
        this.f("qwilcox", Distributions.class, 11);
        this.f("besselI", Special.class, 11);
        this.f("besselK", Special.class, 11);
        this.f("dnbinom_mu", Distributions.class, 11);
        this.f("pnbinom_mu", Distributions.class, 11);
        this.f("qnbinom_mu", Distributions.class, 11);
        this.f("dhyper", Distributions.class, 11);
        this.f("phyper", Distributions.class, 11);
        this.f("qhyper", Distributions.class, 11);
        this.f("dnbeta", Distributions.class, 11);
        this.f("pnbeta", Distributions.class, 11);
        this.f("qnbeta", Distributions.class, 11);
        this.f("dnf", Distributions.class, 11);
        this.f("pnf", Distributions.class, 11);
        this.f("qnf", Distributions.class, 11);
        this.f("ptukey", Distributions.class, 11);
        this.f("qtukey", Distributions.class, 11);
        this.f("rchisq", Distributions.class, 11);
        this.f("rexp", Distributions.class, 11);
        this.f("rgeom", Distributions.class, 11);
        this.f("rpois", Distributions.class, 11);
        this.f("rt", Distributions.class, 11);
        this.f("rsignrank", Distributions.class, 11);
        this.f("rbeta", Distributions.class, 11);
        this.f("rbinom", Distributions.class, 11);
        this.f("rcauchy", Distributions.class, 11);
        this.f("rf", Distributions.class, 11);
        this.f("rgamma", Distributions.class, 11);
        this.f("rlnorm", Distributions.class, 11);
        this.f("rlogis", Distributions.class, 11);
        this.f("rnbinom", Distributions.class, 11);
        this.f("rnbinom_mu", Distributions.class, 11);
        this.f("rnchisq", Distributions.class, 11);
        this.f("rnorm", Distributions.class, 11);
        this.f("runif", Distributions.class, 11);
        this.f("rweibull", Distributions.class, 11);
        this.f("rwilcox", Distributions.class, 11);
        this.f("rhyper", Distributions.class, 11);
        this.f("rmultinom", Distributions.class, 11);
        this.f("sample", Sampling.class, 11);
        this.f("RNGkind", RNG.class, 11);
        this.f("set.seed", RNG.class, 11);
        this.f("sum", Summary.class, 1);
        this.f("mean", Summary.class, 11);
        this.f("min", Summary.class, 1);
        this.f("max", Summary.class, 1);
        this.f("prod", Summary.class, 1);
        this.f("range", Summary.class, 1);
        this.f("cumsum", MathGroup.class, 1);
        this.f("cumprod", MathGroup.class, 1);
        this.f("cummax", MathGroup.class, 1);
        this.f("cummin", MathGroup.class, 1);
        this.f("as.character", Vectors.class, "asCharacter", 1);
        this.f("as.integer", Vectors.class, "asInteger", 1);
        this.f("as.double", Vectors.class, "asDouble", 1);
        this.f("as.complex", Vectors.class, 1);
        this.f("as.logical", Vectors.class, 1);
        this.f("as.raw", Vectors.class, 1);
        this.f("as.vector", Vectors.class, 11);
        this.f("paste", Text.class, 11);
        this.f("file.path", Text.class, 11);
        this.f("format", Text.class, 11);
        this.f("format.info", null, 11);
        this.f("cat", Cat.class, 111);
        this.add(new CallFunction());
        this.f("do.call", Evaluation.class, 211);
        this.f("as.call", Types.class, 1);
        this.f("type.convert", Scan.class, 11);
        this.f("as.environment", Environments.class, "asEnvironment", 1);
        this.f("nchar", Text.class, 11);
        this.f("substr", Text.class, 11);
        this.f("substr<-", Text.class, 11);
        this.f("strsplit", Text.class, 11);
        this.f("abbreviate", null, 11);
        this.f("make.names", Text.class, 11);
        this.f("grep", Text.class, 11);
        this.f("grepl", Text.class, 11);
        this.f("sub", Text.class, 11);
        this.f("gsub", Text.class, 11);
        this.f("regexpr", Text.class, 11);
        this.f("gregexpr", Text.class, 11);
        this.f("agrep", Text.class, 11);
        this.f("tolower", Text.class, 11);
        this.f("toupper", Text.class, 11);
        this.f("chartr", Text.class, 11);
        this.f("sprintf", Text.class, 11);
        this.f("make.unique", Text.class, 11);
        this.f("charToRaw", Vectors.class, 11);
        this.f("rawToChar", Vectors.class, 11);
        this.f("rawShift", Vectors.class, 11);
        this.f("intToBits", Vectors.class, 11);
        this.f("rawToBits", Vectors.class, 11);
        this.f("packBits", null, 11);
        this.f("utf8ToInt", Text.class, 11);
        this.f("intToUtf8", Text.class, 11);
        this.f("encodeString", Text.class, 11);
        this.f("iconv", Text.class, 11);
        this.f("strtrim", Text.class, 11);
        this.f("strtoi", Text.class, 11);
        this.f("is.null", Types.class, 1);
        this.f("is.logical", Types.class, 1);
        this.f("is.integer", Types.class, 1);
        this.f("is.real", Types.class, 1);
        this.f("is.double", Types.class, 1);
        this.f("is.complex", Types.class, 1);
        this.f("is.character", Types.class, 1);
        this.f("is.symbol", Types.class, 1);
        this.f("is.environment", Types.class, "isEnvironment", 1);
        this.f("is.list", Types.class, "isList", 1);
        this.f("is.pairlist", Types.class, "isPairList", 1);
        this.f("is.expression", Types.class, "isExpression", 1);
        this.f("is.raw", Types.class, 1);
        this.f("is.object", Types.class, 1);
        this.f("is.numeric", Types.class, 1);
        this.f("is.matrix", Types.class, 1);
        this.f("is.array", Types.class, 1);
        this.f("is.atomic", Types.class, 1);
        this.f("is.recursive", Types.class, 1);
        this.f("is.call", Types.class, 1);
        this.f("is.language", Types.class, 1);
        this.f("is.function", Types.class, 1);
        this.f("is.single", Types.class, 1);
        this.f("is.vector", Types.class, 11);
        this.f("is.na", Types.class, 1);
        this.f("is.nan", Types.class, 1);
        this.f("is.finite", Types.class, 1);
        this.f("is.infinite", Types.class, 1);
        this.f("isS4", Types.class, 1);
        this.f("setS4Object", Types.class, 11);
        this.f(".isMethodsDispatchOn", Methods.class, 1);
        this.f("proc.time", System.class, 1);
        this.f("gc.time", null, 1);
        this.f("Version", System.class, 11);
        this.f("machine", System.class, 11);
        this.f("commandArgs", System.class, 11);
        this.f("unzip", Files.class, 111);
        this.f("system", System.class, 211);
        this.f("parse", Evaluation.class, 11);
        this.f("parse_Rd", null, 11);
        this.f("save", Serialization.class, 111);
        this.f("saveToConn", Serialization.class, 111);
        this.f("load", null, 111);
        this.f("loadFromConn2", Serialization.class, 111);
        this.f("serializeToConn", Serialization.class, 111);
        this.f("unserializeFromConn", Serialization.class, 111);
        this.f("deparse", Deparse.class, 11);
        this.f("deparseRd", null, 11);
        this.f("dump", null, 111);
        this.add(new SubstituteFunction());
        this.add(new QuoteFunction());
        this.f("quit", Sessions.class, 111);
        this.f("interactive", Sessions.class, 0);
        this.f("readline", null, 11);
        this.f("print.default", Print.class, 111);
        this.f("print.function", Print.class, 111);
        this.f("prmatrix", null, 111);
        this.f("invisible", Types.class, 101);
        this.f("memory.profile", null, 11);
        this.add(new RepFunction());
        this.f("rep.int", Sequences.class, 11);
        this.f("seq.int", Sequences.class, 0);
        this.f("seq_len", Sequences.class, 1);
        this.f("seq_along", Sequences.class, "seqAlong", 1);
        this.f("list", Vectors.class, "list", 1);
        this.f("split", Split.class, 11);
        this.f("is.loaded", null, -1);
        this.f(".C", Native.class, -1);
        this.f(".Fortran", Native.class, -1);
        this.f(".External", Native.class, -1);
        this.f(".Call", Native.class, -1);
        this.f(".External.graphics", null, 1);
        this.f(".Call.graphics", null, 1);
        this.f("recordGraphics", null, 211);
        this.f("dyn.load", null, 111);
        this.f("dyn.unload", null, 111);
        this.f("ls", Environments.class, 11);
        this.f("typeof", Types.class, 11);
        this.f("eval", Evaluation.class, 211);
        this.f("eval.with.vis", Evaluation.class, 211);
        this.f("withVisible", Evaluation.class, 10);
        this.add(new ExpressionFunction());
        this.f("sys.parent", Contexts.class, 11);
        this.f("sys.call", Contexts.class, 11);
        this.f("sys.frame", Contexts.class, 11);
        this.f("sys.nframe", Contexts.class, 11);
        this.f("sys.calls", Contexts.class, 11);
        this.f("sys.frames", Contexts.class, 11);
        this.f("sys.on.exit", Contexts.class, 11);
        this.f("sys.parents", Contexts.class, 11);
        this.f("sys.function", Contexts.class, 11);
        this.f("browserText", null, 11);
        this.f("browserCondition", null, 11);
        this.f("browserSetDebug", null, 111);
        this.f("parent.frame", Contexts.class, "parentFrame", 11);
        this.f("sort", Sort.class, 11);
        this.f("xtfrm", Sort.class, 1);
        this.f("is.unsorted", Sort.class, 11);
        this.f("psort", Sort.class, null, 11);
        this.f("qsort", Sort.class, 11);
        this.f("radixsort", null, 11);
        this.f("order", Sort.class, 11);
        this.f("rank", Sort.class, 11);
        this.f("missing", Evaluation.class, "missing", 0);
        this.f("nargs", Evaluation.class, 0);
        this.f("scan", Scan.class, 11);
        this.f("t.default", Matrices.class, 11);
        this.f("aperm", Matrices.class, 11);
        this.f("builtins", null, 11);
        this.f("edit", null, 11);
        this.f("dataentry", null, 11);
        this.f("dataviewer", null, 111);
        this.f("args", Args.class, 11);
        this.f("formals", Types.class, 11);
        this.f("body", Types.class, 11);
        this.f("bodyCode", null, 11);
        this.f("emptyenv", Environments.class, 1);
        this.f("baseenv", Environments.class, 1);
        this.f("globalenv", Environments.class, 1);
        this.f("environment", Environments.class, 11);
        this.f("environment<-", Environments.class, 2);
        this.f("environmentName", Environments.class, 11);
        this.f("env2list", Environments.class, 11);
        this.f("reg.finalizer", Environments.class, 11);
        this.f("options", Types.class, 211);
        this.f("sink", Connections.class, 111);
        this.f("sink.number", null, 11);
        this.f("lib.fixup", Types.class, 111);
        this.f("pos.to.env", null, 1);
        this.f("eapply", null, 10);
        this.f("lapply", Evaluation.class, 10);
        this.f("vapply", Evaluation.class, 10);
        this.f("mapply", Evaluation.class, 10);
        this.f("rapply", null, 11);
        this.f("islistfactor", Types.class, 11);
        this.f("colSums", Matrices.class, 11);
        this.f("colMeans", Matrices.class, 11);
        this.f("rowSums", Matrices.class, 11);
        this.f("rowMeans", Matrices.class, 11);
        this.f("Rprof", null, 11);
        this.f("Rprofmem", null, 11);
        this.f("tracemem", null, 1);
        this.f("retracemem", null, 1);
        this.f("untracemem", null, 101);
        this.f("object.size", null, 11);
        this.f("inspect", null, 111);
        this.f("mem.limits", null, 11);
        this.f("capabilities", System.class, 11);
        this.f("capabilitiesX11", null, 11);
        this.f("new.env", Environments.class, 11);
        this.f("parent.env", Environments.class, 11);
        this.f("parent.env<-", Environments.class, 11);
        this.f("visibleflag", null, 1);
        this.f("Cstack_info", null, 11);
        this.f("startHTTPD", null, 11);
        this.f("stopHTTPD", null, 11);
        this.f("file.show", null, 111);
        this.f("file.edit", null, 111);
        this.f("file.create", Files.class, 11);
        this.f("file.remove", Files.class, 11);
        this.f("file.rename", Files.class, 11);
        this.f("file.append", Files.class, 11);
        this.f("codeFiles.append", null, 11);
        this.f("file.symlink", null, 11);
        this.f("file.copy", Files.class, 11);
        this.f("list.files", Files.class, 11);
        this.f("file.exists", Files.class, 11);
        this.f("file.choose", null, 11);
        this.f("file.info", Files.class, 11);
        this.f("file.access", Files.class, 11);
        this.f("dir.create", Files.class, 11);
        this.f("dir.exists", Files.class, 11);
        this.f("tempfile", Files.class, 11);
        this.f("tempdir", Files.class, 11);
        this.f("R.home", System.class, "getRHome", 11);
        this.f("date", System.class, 11);
        this.f("index.search", null, 11);
        this.f("Sys.getenv", System.class, 11);
        this.f("Sys.setenv", System.class, 111);
        this.f("Sys.unsetenv", System.class, 111);
        this.f("getwd", Files.class, 11);
        this.f("setwd", Files.class, 111);
        this.f("basename", Files.class, 11);
        this.f("dirname", Files.class, 11);
        this.f("dirchmod", System.class, 111);
        this.f("Sys.chmod", System.class, 111);
        this.f("Sys.umask", System.class, 111);
        this.f("Sys.readlink", null, 11);
        this.f("Sys.info", System.class, 11);
        this.f("Sys.sleep", System.class, 11);
        this.f("Sys.getlocale", System.class, 11);
        this.f("Sys.setlocale", System.class, 11);
        this.f("Sys.localeconv", null, 11);
        this.f("path.expand", Files.class, "pathExpand", 11);
        this.f("Sys.getpid", System.class, 11);
        this.f("normalizePath", Files.class, 11);
        this.f("Sys.glob", Files.class, "glob", 11);
        this.f("unlink", Files.class, 111);
        this.f("polyroot", null, 11);
        this.f("dev.control", null, 111);
        this.f("dev.displaylist", null, 111);
        this.f("dev.copy", null, 111);
        this.f("dev.cur", null, 111);
        this.f("dev.next", null, 111);
        this.f("dev.off", null, 111);
        this.f("dev.prev", null, 111);
        this.f("dev.set", null, 111);
        this.f("rgb", RgbHsv.class, 11);
        this.f("rgb256", RgbHsv.class, 11);
        this.f("rgb2hsv", RgbHsv.class, 11);
        this.f("hsv", RgbHsv.class, 11);
        this.f("hcl", null, 11);
        this.f("gray", RgbHsv.class, 11);
        this.f("colors", null, 11);
        this.f("col2rgb", RgbHsv.class, 11);
        this.f("palette", null, 11);
        this.f("plot.new", Plot.class, 111);
        this.f("plot.window", Plot.class, 111);
        this.f("axis", Plot.class, 111);
        this.f("plot.xy", null, 111);
        this.f("text", null, 111);
        this.f("mtext", null, 111);
        this.f("title", Plot.class, 111);
        this.f("abline", null, 111);
        this.f("box", null, 111);
        this.f("rect", Plot.class, 111);
        this.f("polygon", null, 111);
        this.f("xspline", null, 111);
        this.f("par", Par.class, 11);
        this.f("segments", null, 111);
        this.f("arrows", null, 111);
        this.f("layout", null, 111);
        this.f("locator", null, 11);
        this.f("identify", null, 211);
        this.f("strheight", null, 11);
        this.f("strwidth", null, 11);
        this.f("contour", null, 11);
        this.f("contourLines", null, 11);
        this.f("image", null, 111);
        this.f("dend", null, 111);
        this.f("dend.window", null, 111);
        this.f("erase", null, 111);
        this.f("persp", null, 111);
        this.f("filledcontour", null, 111);
        this.f("getSnapshot", null, 111);
        this.f("playSnapshot", null, 111);
        this.f("symbols", null, 111);
        this.f("getGraphicsEvent", null, 11);
        this.f("devAskNewPage", null, 211);
        this.f("dev.size", null, 11);
        this.f("clip", null, 111);
        this.f("grconvertX", Graphics.class, 11);
        this.f("grconvertY", Graphics.class, 11);
        this.f("inherits", Attributes.class, 11);
        this.f("UseMethod", S3.class, 200);
        this.f("NextMethod", S3.class, 210);
        this.f("standardGeneric", Methods.class, 201);
        this.f("nlm", Optimizations.class, 11);
        this.f("fmin", Optimizations.class, 11);
        this.f("zeroin", null, 11);
        this.f("zeroin2", Roots.class, 11);
        this.f("optim", Optimizations.class, 11);
        this.f("optimhess", null, 11);
        this.f("terms.formula", Models.class, 11);
        this.f("update.formula", null, 11);
        this.f("model.matrix", Models.class, 11);
        this.f("D", null, 11);
        this.f("deriv.default", null, 11);
        this.f("loadhistory", null, 11);
        this.f("savehistory", null, 11);
        this.f("addhistory", null, 11);
        this.f("Sys.time", Time.class, 11);
        this.f("as.POSIXct", Time.class, 11);
        this.f("as.POSIXlt", Time.class, 11);
        this.f("format.POSIXlt", Time.class, 11);
        this.f("strptime", Time.class, 11);
        this.f("Date2POSIXlt", Time.class, 11);
        this.f("POSIXlt2Date", Time.class, 11);
        this.f("stdin", Connections.class, 11);
        this.f("stdout", Connections.class, 11);
        this.f("stderr", Connections.class, 11);
        this.f("isatty", Connections.class, 11);
        this.f("readLines", Connections.class, 11);
        this.f("writeLines", Connections.class, 11);
        this.f("readBin", null, 11);
        this.f("writeBin", null, 211);
        this.f("readChar", Connections.class, 11);
        this.f("writeChar", null, 211);
        this.f("open", Connections.class, 11);
        this.f("isOpen", Connections.class, 11);
        this.f("isIncomplete", null, 11);
        this.f("isSeekable", null, 11);
        this.f("close", Connections.class, 11);
        this.f("flush", null, 11);
        this.f("file", Connections.class, 11);
        this.f("url", Connections.class, 11);
        this.f("pipe", null, 11);
        this.f("fifo", null, 11);
        this.f("gzfile", Connections.class, 11);
        this.f("bzfile", Connections.class, 11);
        this.f("xzfile", Connections.class, 11);
        this.f("unz", null, 11);
        this.f("seek", null, 11);
        this.f("truncate", null, 11);
        this.f("pushBack", Connections.class, 11);
        this.f("clearPushBack", null, 11);
        this.f("pushBackLength", Connections.class, 11);
        this.f("rawConnection", null, 11);
        this.f("rawConnectionValue", null, 11);
        this.f("textConnection", Connections.class, 11);
        this.f("textConnectionValue", null, 11);
        this.f("socketConnection", Connections.class, 11);
        this.f("sockSelect", null, 11);
        this.f("getConnection", null, 11);
        this.f("getAllConnections", null, 11);
        this.f("summary.connection", Connections.class, 11);
        this.f("download", null, 11);
        this.f("nsl", null, 11);
        this.f("gzcon", null, 11);
        this.f("memCompress", null, 11);
        this.f("memDecompress", null, 11);
        this.f("readDCF", DebianControlFiles.class, 11);
        this.f("getNumRtoCConverters", null, 11);
        this.f("getRtoCConverterDescriptions", null, 11);
        this.f("getRtoCConverterStatus", null, 11);
        this.f("setToCConverterActiveStatus", null, 11);
        this.f("removeToCConverterActiveStatus", null, 11);
        this.f("lockEnvironment", Environments.class, 111);
        this.f("environmentIsLocked", Environments.class, 11);
        this.f("lockBinding", Environments.class, 111);
        this.f("unlockBinding", Environments.class, 111);
        this.f("bindingIsLocked", Environments.class, 11);
        this.f("makeActiveBinding", null, 111);
        this.f("bindingIsActive", null, 11);
        this.f("mkUnbound", null, 111);
        this.f("isNamespace", Namespaces.class, 0);
        this.f("getNamespace", Namespaces.class, 0);
        this.f("getRegisteredNamespace", Namespaces.class, 11);
        this.f("loadedNamespaces", Namespaces.class, 0);
        this.f("getNamespaceName", Namespaces.class, 0);
        this.f("getNamespaceExports", Namespaces.class, 0);
        this.f("getNamespaceImports", Namespaces.class, 0);
        this.f("getNamespaceRegistry", Namespaces.class, 11);
        this.f("env.profile", null, 211);
        this.f(":::", Namespaces.class, 0);
        this.f("::", Namespaces.class, 0);
        this.f("getDataset", Namespaces.class, 11);
        this.f("find.package", Namespaces.class, 11);
        this.f("Encoding", Types.class, 11);
        this.f("setEncoding", Types.class, 11);
        this.f("setTimeLimit", null, 111);
        this.f("setSessionTimeLimit", null, 111);
        this.f("icuSetCollate", null, 111);
        this.f("import", Jvmi.class, 0);
        this.f("jload", Jvmi.class, 0);
        this.f("library", Packages.class, 11);
        this.f("require", Packages.class, 11);
        this.f("bitwiseNot", Bitwise.class, 11);
        this.f("bitwiseXor", Bitwise.class, 11);
        this.f("bitwiseShiftL", Bitwise.class, 11);
        this.f("bitwiseShiftR", Bitwise.class, 11);
        this.f("bitwiseAnd", Bitwise.class, 11);
        this.f("bitwiseOr", Bitwise.class, 11);
        for (Map.Entry<Symbol, PrimitiveFunction> entry : this.builtins.entrySet()) {
            if (!entry.getKey().isReservedWord()) continue;
            this.reserved.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Symbol, Object> entry : this.builtinEntries.entrySet()) {
            if (!entry.getKey().isReservedWord()) continue;
            PrimitiveFunction fn = Primitives.createFunction((Entry)entry.getValue());
            this.builtins.put(entry.getKey(), fn);
            this.reserved.put(entry.getKey(), fn);
        }
    }

    private void add(SpecialFunction fn) {
        this.builtins.put(Symbol.get(fn.getName()), fn);
    }

    private void add(Entry entry) {
        Symbol symbol2 = Symbol.get(entry.name);
        if (entry.isInternal()) {
            this.internalEntries.put(symbol2, entry);
        } else {
            this.builtinEntries.put(symbol2, entry);
        }
    }

    private void addInternal(String name, PrimitiveFunction fn) {
        this.internals.put(Symbol.get(fn.getName()), fn);
    }

    private void f(String name, Class clazz, int eval2) {
        Entry e = new Entry();
        e.name = name;
        e.functionClass = clazz;
        e.eval = eval2;
        this.add(e);
    }

    private void f(String name, Class clazz, String methodName, int eval2) {
        Entry e = new Entry();
        e.name = name;
        e.functionClass = clazz;
        e.methodName = methodName;
        e.eval = eval2;
        this.add(e);
    }

    public static class Entry {
        public String name;
        public String group;
        public Class functionClass;
        public String methodName;
        public int eval;

        private Entry() {
        }

        public boolean isInternal() {
            return this.eval % 100 / 10 != 0;
        }

        private Entry(String name, Class functionClass, String methodName, int eval2) {
            this.name = name;
            this.functionClass = functionClass;
            this.methodName = methodName;
            this.eval = eval2;
        }

        public Entry group(String groupName) {
            this.group = groupName;
            return this;
        }

        public boolean isSpecial() {
            return this.eval % 10 == 0;
        }

        public boolean isGroupGeneric() {
            return this.group != null;
        }
    }
}

