/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.connections;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.commons.vfs2.FileSystemException;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Recycle;
import org.renjin.primitives.io.connections.BzipFileConnection;
import org.renjin.primitives.io.connections.Connection;
import org.renjin.primitives.io.connections.FileConnection;
import org.renjin.primitives.io.connections.GzFileConnection;
import org.renjin.primitives.io.connections.OpenSpec;
import org.renjin.primitives.io.connections.PushbackBufferedReader;
import org.renjin.primitives.io.connections.SingleThreadedFifoConnection;
import org.renjin.primitives.io.connections.SocketConnection;
import org.renjin.primitives.io.connections.TextConnection;
import org.renjin.primitives.io.connections.UrlConnection;
import org.renjin.primitives.io.connections.XzFileConnection;
import org.renjin.repackaged.guava.base.Charsets;
import org.renjin.repackaged.guava.base.Joiner;
import org.renjin.repackaged.guava.base.Strings;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Environment;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public class Connections {
    private static final String STD_OUT = "stdout";
    private static final String STD_IN = "stdin";
    private static final String STD_ERR = "stderr";

    @Internal
    public static IntVector gzfile(@Current Context context, String path2, String open2, String encoding, double compressionLevel) throws IOException {
        return Connections.newConnection(context, open2, new GzFileConnection(context.resolveFile(path2)));
    }

    @Internal
    public static IntVector xzfile(@Current Context context, String path2, String open2, String encoding, double compressionLevel) throws IOException {
        return Connections.newConnection(context, open2, new XzFileConnection(context.resolveFile(path2)));
    }

    @Internal
    public static IntVector bzfile(@Current Context context, String path2, String open2, String encoding, double compressionLevel) throws IOException {
        return Connections.newConnection(context, open2, new BzipFileConnection(context.resolveFile(path2)));
    }

    @Internal
    public static IntVector file(@Current Context context, String path2, String open2, boolean blocking, String encoding, boolean raw2) throws IOException {
        if (path2.isEmpty()) {
            return Connections.newConnection(context, open2, new SingleThreadedFifoConnection());
        }
        if (STD_OUT.equals(path2)) {
            return Connections.stdout(context);
        }
        if (STD_IN.equals(path2)) {
            return Connections.stdin(context);
        }
        if (STD_ERR.equals(path2)) {
            return Connections.stderr(context);
        }
        if (path2.startsWith("http://") || path2.startsWith("https://")) {
            return Connections.url(context, path2, open2, blocking, encoding);
        }
        return Connections.newConnection(context, open2, new FileConnection(context.resolveFile(path2)));
    }

    @Internal
    public static IntVector url(@Current Context context, String description, String open2, boolean blocking, String encoding) throws IOException {
        return Connections.newConnection(context, open2, new UrlConnection(new URL(description)));
    }

    @Internal
    public static IntVector textConnection(@Current Context context, String objectName, StringVector text, String open2, Environment env2, String type) throws IOException {
        return Connections.newConnection(context, open2, new TextConnection(objectName, Joiner.on('\n').join(text)));
    }

    @Internal
    public static IntVector stdin(@Current Context context) {
        return Connections.terminal(0);
    }

    @Internal
    public static IntVector stdout(@Current Context context) {
        return Connections.terminal(1);
    }

    @Internal
    public static IntVector stderr(@Current Context context) {
        return Connections.terminal(2);
    }

    @Internal
    public static boolean isatty(@Current Context context, SEXP connHandle) {
        int connectionIndex = Connections.getConnectionIndex(connHandle);
        return (connectionIndex == 0 || connectionIndex == 2 || connectionIndex == 1) && context.getSession().getSessionController().isTerminal();
    }

    private static IntVector terminal(int index) {
        return new IntArrayVector(new int[]{index}, AttributeMap.builder().setClass("connection", "terminal").build());
    }

    @Internal(value="summary.connection")
    public static ListVector summaryConnection(@Current Context context, SEXP connHandle) {
        ListVector.NamedBuilder result = new ListVector.NamedBuilder();
        Connection connection2 = Connections.getConnection(context, connHandle);
        result.add("description", connection2.getDescription());
        result.add("class", connection2.getClassName());
        result.add("mode", connection2.getMode());
        result.add("text", connection2.getType() == Connection.Type.TEXT ? "text" : "binary");
        result.add("opened", connection2.isOpen() ? "opened" : "closed");
        result.add("can read", connection2.canRead() ? "yes" : "no");
        result.add("can write", connection2.canWrite() ? "yes" : "no");
        return result.build();
    }

    @Internal
    public static void close(@Current Context context, SEXP conn, String type) throws IOException {
        Connections.close(context, conn);
    }

    public static void close(@Current Context context, SEXP conn) throws IOException {
        int connIndex = Connections.getConnectionIndex(conn);
        context.getSession().getConnectionTable().close(connIndex);
    }

    @Internal
    public static String readChar(@Current Context context, SEXP connIndex, int nchars, @Recycle(value=false) boolean useBytes) throws IOException {
        Connection conn = Connections.getConnection(context, connIndex);
        if (useBytes) {
            byte[] bytes = new byte[nchars];
            DataInputStream dis = new DataInputStream(conn.getInputStream());
            dis.readFully(bytes);
            return new String(bytes, Charsets.UTF_8);
        }
        PushbackBufferedReader in = conn.getReader();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i != nchars; ++i) {
            result.appendCodePoint(in.read());
        }
        return result.toString();
    }

    @Internal(value="readLines")
    public static StringVector readLines(@Current Context context, SEXP connection2, int numLines, boolean ok, boolean warn, String encoding) throws IOException {
        String line;
        PushbackBufferedReader reader = Connections.getConnection(context, connection2).getReader();
        StringVector.Builder lines = new StringVector.Builder();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
            if (numLines <= 0 || lines.length() != numLines) continue;
        }
        if (numLines > 0 && lines.length() < numLines && !ok) {
            throw new EvalException("too few lines read in readLines", new Object[0]);
        }
        return lines.build();
    }

    @Internal(value="writeLines")
    public static void writeLines(@Current Context context, StringVector x, SEXP connIndex, String seperator, boolean useBytes) throws IOException {
        PrintWriter writer = Connections.getConnection(context, connIndex).getPrintWriter();
        for (String line : x) {
            writer.print(line);
            writer.print(seperator);
        }
        writer.flush();
    }

    @Internal(value="socketConnection")
    public static IntVector socketConnection(@Current Context context, String host, double port) throws UnknownHostException, IOException {
        return Connections.newConnection(context, "", new SocketConnection(host, (int)port));
    }

    @Internal
    public static void sink(SEXP file2, SEXP closeOnExit, SEXP arg2, SEXP split2) {
    }

    @Internal
    public static void open(@Current Context context, SEXP conn, String open2, boolean blocking) throws IOException {
        Connections.getConnection(context, conn).open(new OpenSpec(open2));
    }

    @Internal
    public static boolean isOpen(@Current Context context, SEXP conn, String rw) {
        return Connections.getConnection(context, conn).isOpen();
    }

    @Internal
    public static void pushBack(@Current Context context, Vector data, SEXP connection2, boolean newLine) throws IOException {
        PushbackBufferedReader reader = Connections.getConnection(context, connection2).getReader();
        String suffix = newLine ? "\n" : "";
        for (int i = data.length() - 1; i >= 0; --i) {
            if (data.isElementNA(i)) {
                reader.pushBack("NA" + suffix);
                continue;
            }
            reader.pushBack(data.getElementAsString(i) + suffix);
        }
    }

    @Internal
    public static int pushBackLength(@Current Context context, SEXP connection2) throws IOException {
        PushbackBufferedReader reader = Connections.getConnection(context, connection2).getReader();
        return reader.countLinesPushedBack();
    }

    public static Connection getConnection(Context context, SEXP conn) {
        int connIndex = Connections.getConnectionIndex(conn);
        return context.getSession().getConnectionTable().getConnection(connIndex);
    }

    private static int getConnectionIndex(SEXP conn) {
        if (!conn.inherits("connection") || !(conn instanceof Vector) || conn.length() != 1) {
            throw new EvalException("'con' is not a connection", new Object[0]);
        }
        return ((Vector)conn).getElementAsInt(0);
    }

    private static IntVector newConnection(Context context, String open2, Connection conn) throws IOException, FileSystemException {
        if (!Strings.isNullOrEmpty(open2)) {
            conn.open(new OpenSpec(open2));
        }
        return context.getSession().getConnectionTable().newConnection(conn);
    }
}

