/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.io.serialization;

import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.Closure;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbols;

class Flags {
    public static final int MAX_PACKED_INDEX = 0x7FFFFF;
    private static final int IS_OBJECT_BIT_MASK = 256;
    private static final int HAS_ATTR_BIT_MASK = 512;
    private static final int HAS_TAG_BIT_MASK = 1024;

    private Flags() {
    }

    public static int getType(int flags) {
        return flags & 0xFF;
    }

    public static int getLevels(int flags) {
        return flags >> 12;
    }

    public static boolean hasAttributes(int flags) {
        return (flags & 0x200) == 512;
    }

    public static boolean hasTag(int flags) {
        return (flags & 0x400) == 1024;
    }

    public static boolean isUTF8Encoded(int flags) {
        return (Flags.getLevels(flags) & 8) == 8;
    }

    public static boolean isLatin1Encoded(int flags) {
        return (Flags.getLevels(flags) & 4) == 4;
    }

    public static int unpackRefIndex(int flags) {
        return flags >> 8;
    }

    public static int computeFlags(SEXP exp2, int type) {
        int flags = type;
        if (exp2.getAttribute(Symbols.CLASS) != Null.INSTANCE) {
            flags |= 0x100;
        }
        if (exp2.getAttributes() != AttributeMap.EMPTY) {
            flags |= 0x200;
        }
        if (exp2 instanceof PairList.Node && ((PairList.Node)exp2).hasTag()) {
            flags |= 0x400;
        }
        if (exp2 instanceof Closure | exp2 instanceof Environment) {
            flags |= 0x400;
        }
        return flags;
    }

    public static int computePromiseFlags(Promise promise) {
        int flags = 5;
        if (promise.getAttributes() != AttributeMap.EMPTY) {
            flags |= 0x200;
        }
        if (promise.getEnvironment() != null) {
            flags |= 0x400;
        }
        return flags;
    }

    public static int computeCharSexpFlags(int encodingFlag) {
        return 9 | Flags.encodeLevels(encodingFlag);
    }

    private static int encodeLevels(int value) {
        return value << 12;
    }
}

