/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.sequence;

import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;

public class IntSequence
extends IntVector {
    private int from;
    private int by;
    private int length;

    public IntSequence(int from, int by, int length2) {
        this.from = from;
        this.by = by;
        this.length = length2;
    }

    public IntSequence(AttributeMap attributes2, int from, int by, int length2) {
        super(attributes2);
        this.from = from;
        this.by = by;
        this.length = length2;
    }

    public int getFrom() {
        return this.from;
    }

    public int getBy() {
        return this.by;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int getElementAsInt(int i) {
        return this.from + i * this.by;
    }

    @Override
    public boolean isElementNA(int index) {
        return false;
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new IntSequence(attributes2, this.from, this.by, this.length);
    }

    public static AtomicVector fromTo(int n1, int n2) {
        if (n1 <= n2) {
            return new IntSequence(n1, 1, n2 - n1 + 1);
        }
        return new IntSequence(n1, -1, n1 - n2 + 1);
    }

    public static AtomicVector fromTo(double n1, double n2) {
        return IntSequence.fromTo((int)n1, (int)n2);
    }
}

